package com.gtis.portal.util;

import com.gtis.config.AppConfig;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.remoting.httpinvoker.CommonsHttpInvokerRequestExecutor;


public class OptimizedHttpInvokerRequestExecutor extends CommonsHttpInvokerRequestExecutor{

    public OptimizedHttpInvokerRequestExecutor()
    {
        HttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = httpConnectionManager.getParams();
        params.setDefaultMaxConnectionsPerHost(32);
        params.setMaxTotalConnections(128);
        setHttpClient(new HttpClient(httpConnectionManager));
            String timeOut= AppConfig.getProperty("httpConnection.interface.timeOut");
        if (StringUtils.isBlank(timeOut)) {
            timeOut = "30000";
        }
        setReadTimeout(Integer.parseInt(timeOut));
    }


}