/*
 * Project:  onemap
 * Module:   common
 * File:     FreeMarkerConfigurer.java
 * Modifier: xyang
 * Modified: 2013-05-17 12:14:48
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */
package com.gtis.portal.support.freemarker;

import freemarker.cache.*;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

import javax.servlet.ServletContext;
import java.io.File;
import java.io.IOException;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-9-8
 */
public class FreeMarkerConfigurer extends org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer implements ResourceLoaderAware{
    @Autowired
    private ServletContext context;

    private ObjectWrapper objectWrapper;

    public void setObjectWrapper(ObjectWrapper objectWrapper) {
        this.objectWrapper = objectWrapper;
    }


    @Override
    protected void postProcessConfiguration(Configuration config) throws IOException, TemplateException {
        if (objectWrapper != null) {
            config.setObjectWrapper(objectWrapper);
        }
        MultiTemplateLoader multiTemplateLoader = new MultiTemplateLoader(new TemplateLoader[]{
                new WebappTemplateLoader(context),new ClassTemplateLoader(FreeMarkerConfigurer.class,""),new FileTemplateLoader(new File("/"))});
        config.setTemplateLoader(multiTemplateLoader);
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        super.setResourceLoader(resourceLoader);
    }
}
