package com.gtis.portal.service.server.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.server.RandomTurnTaskDao;
import com.gtis.portal.entity.BdcSjpjjl;
import com.gtis.portal.service.impl.TaskAfterTurnGeneralServiceImpl;
import com.gtis.portal.service.server.RandomTurnTaskService;
import com.gtis.portal.util.QueryCondition;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

import static com.gtis.portal.entity.QBdcSjpjjl.bdcSjpjjl;

@Service
public class RandomTurnTaskServiceImpl extends TaskAfterTurnGeneralServiceImpl implements RandomTurnTaskService {
    @Autowired
    RandomTurnTaskDao randomTurnTaskDao;

    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;
    @Autowired
    SysUserService sysUserService;

    @Override
    public Page<BdcSjpjjl> queryBdcSjpjjlList(List<String> userIdList, String userid, String kqzt, QPageRequest pageable) {
        BooleanExpression expression = null;

        if (StringUtils.isNotBlank(userid)) {
            expression = bdcSjpjjl.yhid.eq(userid);
        }

        if (CollectionUtils.isNotEmpty(userIdList)) {
            if (expression == null)
                expression = bdcSjpjjl.yhid.in(userIdList);
            else
                expression = expression.and(bdcSjpjjl.yhid.in(userIdList));
        }

        if (StringUtils.isNotBlank(kqzt)) {
            if (expression == null)
                expression = bdcSjpjjl.kqzt.eq(kqzt);
            else
                expression = expression.and(bdcSjpjjl.kqzt.eq(kqzt));
        }
        return randomTurnTaskDao.findAll(expression, pageable);

    }

    @Override
    public BdcSjpjjl getBdcSjpjjlByYhid(String yhid) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("yhid", QueryCondition.EQ, yhid);

        queryConditions.add(queryCondition);

        List<BdcSjpjjl> bdcSjpjjlList = baseDao.get(BdcSjpjjl.class, queryConditions);
        if (CollectionUtils.isNotEmpty(bdcSjpjjlList))
            return bdcSjpjjlList.get(0);
        return null;
    }

    @Override
    public void save(BdcSjpjjl bdcSjpjjl) {
        if (StringUtils.isBlank(bdcSjpjjl.getPjjlid()))
            bdcSjpjjl.setPjjlid(UUIDGenerator.generate());
        //数据库查询出的对象
        BdcSjpjjl getBdcSjpjjl = getBdcSjpjjl(bdcSjpjjl.getPjjlid());
        if (StringUtils.isNotBlank(bdcSjpjjl.getYhid())) {
            PfUserVo pfUserVo = sysUserService.getUserVo(bdcSjpjjl.getYhid());
            if (pfUserVo != null)
                bdcSjpjjl.setYhmc(pfUserVo.getUserName());
        }
        if (StringUtils.isBlank(bdcSjpjjl.getKqzt()))
            bdcSjpjjl.setKqzt("1");
        if (getBdcSjpjjl != null) {

            updateBdcSjpjjl(bdcSjpjjl);
        } else {
            addBdcSjpjjl(bdcSjpjjl);
        }

    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public BdcSjpjjl getBdcSjpjjl(String yhjlId) {
        return baseDao.getById(BdcSjpjjl.class, yhjlId);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void delBdcSjpjjl(String id) {
        baseDao.delete(BdcSjpjjl.class, id);
    }

    @Override
    public List<BdcSjpjjl> getBdcSjpjjlByKqzt(String kqzt) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("kqzt", QueryCondition.EQ, kqzt);

        queryConditions.add(queryCondition);

        List<BdcSjpjjl> bdcSjpjjlList = baseDao.get(BdcSjpjjl.class, queryConditions);
        if (CollectionUtils.isNotEmpty(bdcSjpjjlList))
            return bdcSjpjjlList;
        return null;
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void updateBdcSjpjjl(BdcSjpjjl bdcSjpjjl) {
        baseDao.update(bdcSjpjjl);
    }

    public void addBdcSjpjjl(BdcSjpjjl bdcSjpjjl) {
        baseDao.save(bdcSjpjjl);
    }


}
