package com.gtis.portal.service.server.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.server.AutoTurnTaskDao;
import com.gtis.portal.entity.BdcXm;
import com.gtis.portal.entity.BdcZdpjjl;
import com.gtis.portal.entity.BdcZdpjjlAll;
import com.gtis.portal.service.impl.TaskAfterTurnGeneralServiceImpl;
import com.gtis.portal.service.server.AutoTurnAllTaskService;
import com.gtis.portal.service.server.AutoTurnTaskService;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.util.QueryCondition;
import com.gtis.portal.util.WorkFlowXml;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import static com.gtis.portal.entity.QBdcZdpjjl.bdcZdpjjl;

@Service
public class AutoTurnTaskServiceImpl extends TaskAfterTurnGeneralServiceImpl implements AutoTurnTaskService {
    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;

    @PersistenceContext(unitName = "entityManagerFactory_server")
    EntityManager em;
    @Autowired
    AutoTurnAllTaskService autoTurnAllTaskService;
    @Autowired
    AutoTurnTaskDao autoTurnTaskDao;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    BdcXmService bdcXmService;

    @Autowired
    SysTaskService sysTaskService;

    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;

    private static final Log log = LogFactory.getLog(AutoTurnTaskServiceImpl.class);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public BdcZdpjjl getBdcZdpjjl(String yhjlId) {
        return baseDao.getById(BdcZdpjjl.class, yhjlId);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void updateBdcZdpjjl(BdcZdpjjl bdcZdpjjl) {
        baseDao.update(bdcZdpjjl);
    }

    public void addBdcZdpjjl(BdcZdpjjl bdcZdpjjl) {
        baseDao.save(bdcZdpjjl);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void delBdcZdpjjl(String id) {
        baseDao.delete(BdcZdpjjl.class, id);
    }

    @Override
    public BdcZdpjjl getBdcZdpjjlByYhid(String yhid) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("yhid", QueryCondition.EQ, yhid);
        queryConditions.add(queryCondition);

        Object result = baseDao.getSingleResult(BdcZdpjjl.class, queryConditions);
        if (result != null)
            return (BdcZdpjjl) result;
        return null;
    }

    @Override
    public String getZdpjYhid(String wdid, String jdid, List<PfUserVo> userVoList) {
        if (StringUtils.isNotBlank(wdid) && StringUtils.isNotBlank(jdid) && CollectionUtils.isNotEmpty(userVoList)) {
            List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
            QueryCondition queryCondition = new QueryCondition("gzlid", QueryCondition.EQ, wdid);
            QueryCondition queryCondition1 = new QueryCondition("jdid", QueryCondition.EQ, jdid);
            QueryCondition queryCondition2 = new QueryCondition("kqzt", QueryCondition.EQ, "1");
            queryConditions.add(queryCondition);
            queryConditions.add(queryCondition1);
            queryConditions.add(queryCondition2);
            String orderBy = " order by to_number(nvl(xnpjsl,0)) ,to_number(nvl(pjsx,0))";
            List<BdcZdpjjl> bdcZdpjjlList = baseDao.get(BdcZdpjjl.class, queryConditions, orderBy);
            if (CollectionUtils.isNotEmpty(bdcZdpjjlList)) {
                for (BdcZdpjjl bdcZdpjjl : bdcZdpjjlList) {
                    for (PfUserVo pfUserVo : userVoList) {
                        if (StringUtils.equals(bdcZdpjjl.getYhid(), pfUserVo.getUserId())) {
                            return bdcZdpjjl.getYhid();
                        }
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean doWork(WorkFlowInfo infoObj) {
        boolean ignore = false;
        String[] sqlx = AppConfig.getProperty("autoTurnAllTask.sqlx.ignore") != null ? AppConfig.getProperty("autoTurnAllTask.sqlx.ignore").split(",") : new String[1];
        //获取当前流程的申请类型
        String wiid = infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId();
        List<BdcXm> bdcList = bdcXmService.getBdcXmList(wiid);

        if (CollectionUtils.isNotEmpty(bdcList)&&sqlx.length>0) {
            for (int i = 0; i < bdcList.size(); i++) {
                for (int j = 0; j <sqlx.length ; j++) {
                    if(bdcList.get(i).getSqlx().equals(sqlx[j]))
                    {
                        ignore=true;
                    }
                }

            }
        }
        //转发后执行更新工作量记录
        String autoTurnEnable = AppConfig.getProperty("autoTurnTask.enble");
        String onlyYhsq = AppConfig.getProperty("yhsq.only.autoTurnTask.enble");
        String autoTurnAllTaskEnable = AppConfig.getProperty("autoTurnAllTask.enble");
        String onlyPjsxEnable = AppConfig.getProperty("autoTurnTask.onlyPjsx.enable");
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = infoObj.getWorkFlowIntanceVo();
        PfActivityVo sourceActivity = infoObj.getSourceActivity();
        List<PfActivityVo> pfActivityVoList = infoObj.getTargetActivitys();
        List<PfTaskVo> pfTaskVoList = infoObj.getTargetTasks();

        //获取退回数据
        //使用Set过滤掉重复的用户
        Set taskPerfomerIds = Sets.newHashSet();
        if (pfWorkFlowInstanceVo != null && StringUtils.isNotBlank(pfWorkFlowInstanceVo.getWorkflowDefinitionId())
                && CollectionUtils.isNotEmpty(pfActivityVoList)) {
            if (CollectionUtils.isNotEmpty(pfActivityVoList)) {
                for (PfActivityVo targetActivity : pfActivityVoList) {
                    List<PfTaskVo> historyTaskList = sysTaskService.getHistoryTaskListByDefineId(pfWorkFlowInstanceVo.getWorkflowIntanceId(), targetActivity.getActivityDefinitionId());

                    for (PfTaskVo historyTask : historyTaskList) {
                        if (!taskPerfomerIds.contains(historyTask.getUserVo().getUserId())) {
                            taskPerfomerIds.add(historyTask.getUserVo().getUserId());
                        }
                    }
                }
            }
        }


        if (StringUtils.equals(autoTurnAllTaskEnable, "true")&&!ignore) {
            if (CollectionUtils.isNotEmpty(pfTaskVoList)) {
                for (PfTaskVo pfTaskVo : pfTaskVoList) {
                    List<BdcZdpjjlAll> bdcZdpjjlAllList = autoTurnAllTaskService.queryBdcZdpjjlList(pfTaskVo.getUserVo().getUserId(), "1");
                    if (bdcZdpjjlAllList.size() > 0 && !taskPerfomerIds.contains(pfTaskVo.getUserVo().getUserId())) {

                        BdcZdpjjlAll bdcZdpjjlAll = bdcZdpjjlAllList.get(0);
                        if (StringUtils.equals(onlyPjsxEnable,"true")) {
                            List<PfRoleVo> roleList = sysUserService.getRoleListByUser(bdcZdpjjlAll.getYhid());
                            if (CollectionUtils.isNotEmpty(roleList)) {
                                for (PfRoleVo pfRoleVo : roleList) {
                                    List<PfUserVo> userList = sysUserService.getUserListByRole(pfRoleVo.getRoleId());
                                    List<BdcZdpjjlAll> bdcZdpjjlAlls = baseDao.getAll(BdcZdpjjlAll.class);//找到所有的记录
                                    if (CollectionUtils.isNotEmpty(userList) && CollectionUtils.isNotEmpty(bdcZdpjjlAlls)) {
                                        for (PfUserVo pfUserVo : userList) {
                                            for (BdcZdpjjlAll zdpjjlAll : bdcZdpjjlAlls) {
                                                if (StringUtils.equals(pfUserVo.getUserId(),zdpjjlAll.getYhid()) && zdpjjlAll.getXnpjsl() != 0) {//表示上一个转发人
                                                    zdpjjlAll.setXnpjsl(0);
                                                    autoTurnAllTaskService.updateBdcZdpjjl(zdpjjlAll);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            bdcZdpjjlAll.setXnpjsl(1);

                        } else {
                            bdcZdpjjlAll.setXnpjsl(bdcZdpjjlAll.getXnpjsl() + 1);
                        }
                        bdcZdpjjlAll.setSjpjsl(bdcZdpjjlAll.getSjpjsl() + 1);
                        autoTurnAllTaskService.updateBdcZdpjjl(bdcZdpjjlAll);
                    }
                }
            }
        } else if (StringUtils.equals(autoTurnEnable, "true")) {
            //是否只有银行申请自动派件
            if (StringUtils.equals(onlyYhsq, "true")) {
                if (pfWorkFlowInstanceVo != null && StringUtils.isNotBlank(pfWorkFlowInstanceVo.getWorkflowIntanceId())) {
                    List<BdcXm> bdcXmList = bdcXmService.getBdcXmList(pfWorkFlowInstanceVo.getWorkflowIntanceId());
                    boolean isyhsq = false;
                    if (CollectionUtils.isNotEmpty(bdcXmList)) {
                        for (BdcXm bdcXm : bdcXmList) {
                            if (bdcXm != null && StringUtils.isNotBlank(bdcXm.getYhsqywh())) {
                                isyhsq = true;
                                break;
                            }
                        }
                    } else
                        isyhsq = true;
                    if (!isyhsq)
                        return true;
                }
            }

            if (pfWorkFlowInstanceVo != null && StringUtils.isNotBlank(pfWorkFlowInstanceVo.getWorkflowDefinitionId())
                    && CollectionUtils.isNotEmpty(pfActivityVoList) && CollectionUtils.isNotEmpty(pfTaskVoList)) {
                for (PfActivityVo pfActivityVo : pfActivityVoList) {
                    for (PfTaskVo pfTaskVo : pfTaskVoList) {
                        BdcZdpjjl bdcZdpjjl = getBdcZdpjjlByWdidAndJdidAndYhid(pfWorkFlowInstanceVo.getWorkflowDefinitionId(),
                                pfActivityVo.getActivityDefinitionId(), pfTaskVo.getUserVo().getUserId(), "1");
                        if (bdcZdpjjl != null && !taskPerfomerIds.contains(pfTaskVo.getUserVo().getUserId())) {
                            if (bdcZdpjjl.getSjpjsl() != null) {
                                bdcZdpjjl.setSjpjsl(bdcZdpjjl.getSjpjsl() + 1);
                            }
                            if (bdcZdpjjl.getXnpjsl() != null) {
                                if (StringUtils.equals(onlyPjsxEnable,"true")) {
                                    List<BdcZdpjjl> bdcZdpjjls = queryBdcZdpjjlList(bdcZdpjjl.getGzlid(), bdcZdpjjl.getJdid(), "");//获取同节点
                                    for (BdcZdpjjl pjjl : bdcZdpjjls) {
                                        if (pjjl.getXnpjsl() != 0) {
                                            pjjl.setXnpjsl(0);
                                            updateBdcZdpjjl(pjjl);
                                        }
                                    }
                                    bdcZdpjjl.setXnpjsl(1);
                                } else {
                                    bdcZdpjjl.setXnpjsl(bdcZdpjjl.getXnpjsl() + 1);
                                }
                            }
                            updateBdcZdpjjl(bdcZdpjjl);
                        }
                    }
                }
            }
        }

        return true;
    }

    @Override
    public BdcZdpjjl getBdcZdpjjlByWdidAndJdidAndYhid(String wdid, String jdid, String yhid, String kqzt) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("gzlid", QueryCondition.EQ, wdid);
        QueryCondition queryCondition1 = new QueryCondition("jdid", QueryCondition.EQ, jdid);
        QueryCondition queryCondition2 = new QueryCondition("kqzt", QueryCondition.EQ, kqzt);
        QueryCondition queryCondition3 = new QueryCondition("yhid", QueryCondition.EQ, yhid);
        queryConditions.add(queryCondition);
        queryConditions.add(queryCondition1);
        queryConditions.add(queryCondition2);
        queryConditions.add(queryCondition3);
        List<BdcZdpjjl> bdcZdpjjlList = baseDao.get(BdcZdpjjl.class, queryConditions);
        if (CollectionUtils.isNotEmpty(bdcZdpjjlList))
            return bdcZdpjjlList.get(0);
        return null;
    }

    @Override
    public Page<BdcZdpjjl> queryBdcZdpjjlList(List<String> pfUserVoList, String wdid, String jdmc, String userid, String kqzt, Pageable page) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank(wdid))
            expression = bdcZdpjjl.gzlid.eq(wdid);
        if (CollectionUtils.isNotEmpty(pfUserVoList)) {
            if (expression == null)
                expression = bdcZdpjjl.yhid.in(pfUserVoList);
            else
                expression = expression.and(bdcZdpjjl.yhid.in(pfUserVoList));
        }
        if (StringUtils.isNotBlank(jdmc)) {
            if (expression == null)
                expression = bdcZdpjjl.jdmc.eq(jdmc);
            else
                expression = expression.and(bdcZdpjjl.jdmc.eq(jdmc));
        }
        if (StringUtils.isNotBlank(userid)) {
            if (expression == null)
                expression = bdcZdpjjl.yhid.eq(userid);
            else
                expression = expression.and(bdcZdpjjl.yhid.eq(userid));
        }
        if (StringUtils.isNotBlank(kqzt)) {
            if (expression == null)
                expression = bdcZdpjjl.kqzt.eq(kqzt);
            else
                expression = expression.and(bdcZdpjjl.kqzt.eq(kqzt));
        }
        return autoTurnTaskDao.findAll(expression, page);
    }

    @Override
    public void save(BdcZdpjjl bdcZdpjjl) {
        if (StringUtils.isBlank(bdcZdpjjl.getPjjlid()))
            bdcZdpjjl.setPjjlid(UUIDGenerator.generate());
        //数据库查询出的对象
        BdcZdpjjl getBdcZdpjjl = getBdcZdpjjl(bdcZdpjjl.getPjjlid());
        if (StringUtils.isNotBlank(bdcZdpjjl.getGzlid()))
            bdcZdpjjl.setGzlmc(sysWorkFlowDefineService.getWorkFlowDefine(bdcZdpjjl.getGzlid()).getWorkflowName());
        if (StringUtils.isNotBlank(bdcZdpjjl.getJdid())) {
            List<ActivityModel> activityModelList = null;
            if (StringUtils.isNotBlank(bdcZdpjjl.getGzlid())) {

                String xml = sysWorkFlowDefineService.getWorkFlowDefineXml(bdcZdpjjl.getGzlid());
                if (StringUtils.isNotBlank(xml)) {
                    WorkFlowXml modelXml = new WorkFlowXml(xml);
                    activityModelList = modelXml.getActivityList();
                }
            }
            if (CollectionUtils.isNotEmpty(activityModelList)) {
                for (ActivityModel activityModel : activityModelList) {
                    if (activityModel != null && StringUtils.equals(activityModel.getDefineId(), bdcZdpjjl.getJdid())) {
                        bdcZdpjjl.setJdmc(activityModel.getActivityDefineName());
                    }
                }
            }
        }
        if (StringUtils.isNotBlank(bdcZdpjjl.getYhid())) {
            PfUserVo pfUserVo = sysUserService.getUserVo(bdcZdpjjl.getYhid());
            if (pfUserVo != null)
                bdcZdpjjl.setYhmc(pfUserVo.getUserName());
        }
        if (bdcZdpjjl.getSjpjsl() == null)
            bdcZdpjjl.setSjpjsl(0);
        if (bdcZdpjjl.getXnpjsl() == null)
            bdcZdpjjl.setXnpjsl(0);
        if (bdcZdpjjl.getPjsx() == null)
            bdcZdpjjl.setPjsx(1);
        if (StringUtils.isBlank(bdcZdpjjl.getKqzt()))
            bdcZdpjjl.setKqzt("1");

        if (getBdcZdpjjl != null) {

            updateBdcZdpjjl(bdcZdpjjl);
        } else {
            addBdcZdpjjl(bdcZdpjjl);
        }

        if (getBdcZdpjjl != null&&bdcZdpjjl != null && "1".equals(bdcZdpjjl.getKqzt()) && "0".equals(getBdcZdpjjl.getKqzt())) {
            if (!AppConfig.getBooleanProperty("autoTurnTask.onlyPjsx.enable")) {
                //如果这个人是从请假变为正常，那么把同角色的所有人虚拟派件数量都更新为0
                String gzlid=bdcZdpjjl.getGzlid();
                String jdid=bdcZdpjjl.getJdid();
                List<BdcZdpjjl> bdcZdpjjlList = queryBdcZdpjjlList(gzlid,jdid,"1");
                for (int i = 0; i < bdcZdpjjlList.size(); i++) {
                    BdcZdpjjl bdcZdpjjlval = bdcZdpjjlList.get(i);
                    bdcZdpjjlval.setXnpjsl(0);
                    updateBdcZdpjjl(bdcZdpjjlval);
                }
            }
        }
    }

    @Override
    public List<BdcZdpjjl> queryBdcZdpjjlList(String wdid, String jdmc, String userid, String kqzt) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        if (StringUtils.isNotBlank(wdid)) {
            QueryCondition queryCondition = new QueryCondition("gzlid", QueryCondition.LK, "%" + wdid + "%");
            queryConditions.add(queryCondition);
        }
        if (StringUtils.isNotBlank(jdmc)) {
            QueryCondition queryCondition1 = new QueryCondition("jdmc", QueryCondition.LK, "%" + jdmc + "%");
            queryConditions.add(queryCondition1);
        }
        if (StringUtils.isNotBlank(userid)) {
            QueryCondition queryCondition1 = new QueryCondition("yhid", QueryCondition.EQ, userid);
            queryConditions.add(queryCondition1);
        }
        if (StringUtils.isNotBlank(kqzt)) {
            QueryCondition queryCondition1 = new QueryCondition("yhid", QueryCondition.EQ, kqzt);
            queryConditions.add(queryCondition1);
        }

        return baseDao.get(BdcZdpjjl.class, queryConditions);
    }

    public List<BdcZdpjjl> queryBdcZdpjjlList(String gzlid, String jdid, String kqzt) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        if (StringUtils.isNotBlank(gzlid)) {
            QueryCondition queryCondition = new QueryCondition("gzlid", QueryCondition.EQ, gzlid);
            queryConditions.add(queryCondition);
        }
        if (StringUtils.isNotBlank(jdid)) {
            QueryCondition queryCondition1 = new QueryCondition("jdid", QueryCondition.EQ, jdid);
            queryConditions.add(queryCondition1);
        }
        if (StringUtils.isNotBlank(kqzt)) {
            QueryCondition queryCondition1 = new QueryCondition("kqzt", QueryCondition.EQ, kqzt);
            queryConditions.add(queryCondition1);
        }
        return baseDao.get(BdcZdpjjl.class, queryConditions);
    }

    public List<BdcZdpjjlAll> queryBdcZdpjjlAllList(String kqzt) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        if (StringUtils.isNotBlank(kqzt)) {
            QueryCondition queryCondition1 = new QueryCondition("kqzt", QueryCondition.EQ, kqzt);
            queryConditions.add(queryCondition1);
        }
        return baseDao.get(BdcZdpjjlAll.class, queryConditions, "order by xnpjsl,pjsx");
    }


    @Override
    public String getLoopBdcZdpjjlAllYhId(List<PfUserVo> userVoList) {
        if (CollectionUtils.isNotEmpty(userVoList)) {
            String orderBy = " order by to_number(nvl(pjsx,0))";
            List<BdcZdpjjlAll> allBdcZdpjjlList = baseDao.get(BdcZdpjjlAll.class, null, orderBy);//按照派件顺序排列的可执行人员(不考虑考勤状态)
            Integer pjsx = -1;//不能转发
            if (CollectionUtils.isNotEmpty(allBdcZdpjjlList)) {
                for (BdcZdpjjlAll bdcZdpjjl : allBdcZdpjjlList) {
                    for (PfUserVo pfUserVo : userVoList) {
                        if (StringUtils.equals(bdcZdpjjl.getYhid(), pfUserVo.getUserId())) {
                            if (pjsx != -1) {
                                if (StringUtils.equals(bdcZdpjjl.getKqzt(),"1")) {//是可转发人员
                                    log.info("1--自动全局派件---循环派工返回转发人员---user:"+ JSON.toJSONString(bdcZdpjjl));
                                    return bdcZdpjjl.getYhid();
                                }
                            }
                            if (bdcZdpjjl.getXnpjsl() == 1) {//获取虚拟派件为1的派件顺序
                                pjsx =bdcZdpjjl.getPjsx();//下一个可转发
                            }
                        }
                    }
                }
            }
            List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
            QueryCondition queryCondition = new QueryCondition("kqzt", QueryCondition.EQ, "1");
            queryConditions.add(queryCondition);
            List<BdcZdpjjlAll> bdcZdpjjlList = baseDao.get(BdcZdpjjlAll.class, queryConditions, orderBy);//按照派件顺序排列的可转发可执行人员
            if (CollectionUtils.isNotEmpty(bdcZdpjjlList)) {
                for (BdcZdpjjlAll bdcZdpjjl : bdcZdpjjlList) {
                    for (PfUserVo pfUserVo : userVoList) {
                        if (StringUtils.equals(bdcZdpjjl.getYhid(), pfUserVo.getUserId())) {
                            log.info("2--自动全局派件---循环派工返回转发人员---user:"+ JSON.toJSONString(bdcZdpjjl));
                            return bdcZdpjjl.getYhid();//1.第一次转发，2.可转发但没有转发值
                        }
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String getLoopBdcZdpjjlYhId(String wdid, String jdid, List<PfUserVo> userVoList) {
        if (StringUtils.isNotBlank(wdid) && StringUtils.isNotBlank(jdid) && CollectionUtils.isNotEmpty(userVoList)) {
            List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
            QueryCondition queryCondition = new QueryCondition("gzlid", QueryCondition.EQ, wdid);
            QueryCondition queryCondition1 = new QueryCondition("jdid", QueryCondition.EQ, jdid);
            queryConditions.add(queryCondition);
            queryConditions.add(queryCondition1);
            String orderBy = " order by to_number(nvl(pjsx,0))";
            List<BdcZdpjjl> allBdcZdpjjlList = baseDao.get(BdcZdpjjl.class, queryConditions, orderBy);//按照派件顺序排列的可执行人员(不考虑考勤状态)
            Integer pjsx = -1;//不能转发
            if (CollectionUtils.isNotEmpty(allBdcZdpjjlList)) {
                for (BdcZdpjjl bdcZdpjjl : allBdcZdpjjlList) {
                    for (PfUserVo pfUserVo : userVoList) {
                        if (StringUtils.equals(bdcZdpjjl.getYhid(), pfUserVo.getUserId())) {
                            if (pjsx != -1) {
                                if (StringUtils.equals(bdcZdpjjl.getKqzt(),"1")) {//是可转发人员
                                    log.info("1--自动派件---循环派工返回转发人员---user:"+ JSON.toJSONString(bdcZdpjjl));
                                    return bdcZdpjjl.getYhid();
                                }
                            }
                            if (bdcZdpjjl.getXnpjsl() == 1) {//获取虚拟派件为1的派件顺序
                                pjsx =bdcZdpjjl.getPjsx();//下一个可转发
                            }
                        }
                    }
                }
            }

            QueryCondition queryCondition2 = new QueryCondition("kqzt", QueryCondition.EQ, "1");
            queryConditions.add(queryCondition2);
            List<BdcZdpjjl> bdcZdpjjlList = baseDao.get(BdcZdpjjl.class, queryConditions, orderBy);//按照派件顺序排列的可执行人员
            if (CollectionUtils.isNotEmpty(bdcZdpjjlList)) {
                for (BdcZdpjjl bdcZdpjjl : bdcZdpjjlList) {
                    for (PfUserVo pfUserVo : userVoList) {
                        if (StringUtils.equals(bdcZdpjjl.getYhid(), pfUserVo.getUserId())) {
                            log.info("2--自动派件---循环派工返回转发人员---user:"+ JSON.toJSONString(bdcZdpjjl));
                            return bdcZdpjjl.getYhid();
                        }
                    }
                }
            }
        }
        return null;

    }

}
