package com.gtis.portal.service.server;

import com.gtis.portal.entity.PfWorkFlowEvent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:songhaowen@gtmap.cn">ray</a>
 * @version 1.0, 2017/11/15
 * @description 工作流事件配置
 */
public interface PfWorkFlowEventConfigurationService {
    /**
     * 获取工作流事件配置
     * @param pfWorkFlowDefinitionId
     * @param pfWorkFlowName
     * @return
     */
    public Page<PfWorkFlowEvent> listPfWorkFlowEventPage(String pfWorkFlowDefinitionId, String pfWorkFlowName, @PageableDefault(size = 10) Pageable page);

    /**
     * 获取工作流事件配置
     * @param param
     * @return
     */
    public List<PfWorkFlowEvent> listPfWorkFlowEvent(Map<String, Object> param);

    /**
     * 添加工作流事件配置
     * @param pfWorkFlowEvent
     */
    public void addPfWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent);

    /**
     * 批量保存工作流事件
     * @param pfWorkFlowEventList
     */
    public void savePfWorkFlowEventList(List<PfWorkFlowEvent> pfWorkFlowEventList);

    /**
     * 修改工作流事件配置
     * @param pfWorkFlowEvent
     */
    public void updatePfWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent);

    /**
     * 修改工作流事件配置
     * @param id
     */
    public void deletePfWorkFlowEventById(String[] id);

    /**
     * 获取工作流事件
     * @param id
     * @return
     */
    public PfWorkFlowEvent getPfWorkFlowEvent(String id);

    /**
     * 导入并删除工作流事件
     * @param pfWorkFlowEvent
     */
    public Map<String,Object> importPfWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent);

    /**
     * 根据xml创建工作事件
     * @param pfWorkFlowEvent
     * @param xml
     * @return
     */
    public List<PfWorkFlowEvent> cratePfWorkFlowEventByXml(PfWorkFlowEvent pfWorkFlowEvent, String xml);


    /**
     * 执行配置的工作流事件
     * @param wiid
     * @param taskid
     * @param userid
     * @param eventName 事件名称
     * @param workFlowDefinitionId 工作流定义id3
     * @param proid 项目id
     * @return
     */
    public boolean doWfEvent(String wiid, String taskid, String userid, String eventName, String workFlowDefinitionId, String proid,String turnXml) throws Exception;

    /**
     * 清空工作流事件
     * @param pfWorkFlowEvent
     */
    public Map<String,Object> cleanWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent);  /**
     * 清空平台的工作流事件
     * @param workflowDefinitionId
     */
    public void cleanPfWorkFlowDefinitionEvent(String  workflowDefinitionId);
    /**
     * 批量导入工作流事件
     */
    public Map<String,Object> batchImportPfWorkFlowEvent();
}
