package com.gtis.portal.service;

import com.gtis.portal.entity.PfLog;
import com.gtis.portal.entity.PfMessageAccept;
import com.gtis.portal.entity.PfMessageSend;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: jibo
 * Date: 14-5-9
 * Time: 上午6:02
 * To change this template use File | Settings | File Templates.
 */
public interface PfMessageService {
    /**
     * 查询发送信息列表
     *
     * @param userId
     * @param title
     * @param beginDate
     * @param endDate
     * @param page
     * @return
     */
    public Page<PfMessageSend> queryMessageSendList(String userId, String title, Date beginDate, Date endDate, Pageable page);


    /**
     * 查询接收消息列表
     *
     * @param userId
     * @param title
     * @param beginDate
     * @param endDate
     * @param page
     * @return
     */
    public Page<PfMessageAccept> queryMessageAcceptList(String userId,String slbh,String userName,String title, String messagesendId, Date beginDate, Date endDate,
                                                        Pageable page);

    /**
     * 查询接收消息列表
     *
     */
    public List<PfMessageAccept> queryPfMessageAcceptByMessageId(String messageId);
    /**
     * 查询发送消息
     *
     * @param messageId
     * @return
     */
    public PfMessageSend getMessageSend(String messageId);

    /**
     * 查询接收消息
     *
     * @param messageId
     * @return
     */
    public PfMessageAccept getMessageAccept(String messageId);

    /**
     * 发送消息
     *
     * @param pfMessageSend
     */
    public void addSendMessage(PfMessageSend pfMessageSend);
    /**
     * 发送消息(接口）
     *
     * @param pfMessageSend
     */
    public void addSendMessageInterface(PfMessageSend pfMessageSend);

    /**
     * 修改发送消息
     * @param pfMessageSend
     */
    public void updateSendMessage(PfMessageSend pfMessageSend);

    /**
     * 添加发送消息和发送消息
     *
     * @param pfMessageSend
     */
    public void addSendMessageAndAcceptMessage(PfMessageSend pfMessageSend, String users);

    /**
     * 添加发送消息和发送消息(接口）
     *
     * @param pfMessageSend
     */
    public void addSendMessageAndAcceptMessageInterface(PfMessageSend pfMessageSend, String users);

    /**
     * 记录消息日志
     * @param pfMessageSend
     */
    public void addPfLogBySendMessage(PfMessageSend pfMessageSend,String ip);

    /**
     * 记录消息日志(接口）
     * @param pfMessageSend
     */
    public void addPfLogBySendMessageInterface(PfMessageSend pfMessageSend,String ip,String userId);

    /**
     * 接收消息
     *
     * @param pfMessageAccept
     */
    public void addAcceptMessage(PfMessageAccept pfMessageAccept);
    /**
     * 更新接收消息
     *
     * @param messageacceptId
     */
    public void updateAcceptMessageById(String messageacceptId);

    /**
     *
     *添加消息
     * @param
     */
    public boolean addAcceptMessageByUser(String users, PfMessageSend pfMessageSend);

    /**
     * 添加日志
     * @param pfLog
     */
    public void addPfLog(PfLog pfLog);

    /**
     * 删除接收消息
     *
     * @param pfMessageAccept
     */
    public void deleteAcceptMessage(PfMessageAccept pfMessageAccept);

    /**
     * 删除发送消息
     *
     * @param pfMessageSend
     */
    public void deleteSendMessage(PfMessageSend pfMessageSend);

    /**
     * 删除附件
     *
     * @param messagesendId
     */
    public boolean deleteFile(String messagesendId);
    /**
     * 新建消息
     *
     * @param
     */
    public PfMessageAccept createNewPfMessageAccept(String userId, PfMessageSend pfMessageSend);

    /**
     * 消息数量
     * @param
     */
    public Long countPfMessageAccept(String userId,Integer status, String messageTitle);

    /**
     * 创建附件
     * @param parentId
     * @param folderNodeName
     * @return
     */
    public Integer createFileFolderByMessage(Integer parentId, String folderNodeName);

    /**
     *
     * @param projectId
     * @return
     */
    public Integer getProjectFileId(String projectId);
}
