package com.gtis.portal.service.server.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.server.OverTimeRemindDao;
import com.gtis.portal.entity.BdcCqtxjl;
import com.gtis.portal.service.server.OverTimeRemindService;
import com.gtis.portal.util.QueryCondition;
import com.gtis.portal.util.WorkFlowXml;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

import static com.gtis.portal.entity.QBdcCqtxjl.bdcCqtxjl;


/**
 * @author <a href="mailto:liangxichang@gtmap.cn">lxc</a>
 * @version 1.0 , 2019/11/7
 * @description
 **/
@Service
public class OverTimeRemindServiceImpl implements OverTimeRemindService {
    @Autowired
    OverTimeRemindDao overTimeRemindDao;
    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;

    @Override
    public Page<BdcCqtxjl> queryBdcCqtxjlList(String wdid, String jdmc, QPageRequest pageable) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank(wdid))
            expression = bdcCqtxjl.gzlid.eq(wdid);

        if (StringUtils.isNotBlank(jdmc)) {
            if (expression == null)
                expression = bdcCqtxjl.jdmc.eq(jdmc);
            else
                expression = expression.and(bdcCqtxjl.jdmc.eq(jdmc));
        }

        return overTimeRemindDao.findAll(expression, pageable);
    }

    @Override
    public BdcCqtxjl getBdcCqtxjlByWdidAndJdid(String gzlid, String jdid) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = null;
        QueryCondition queryCondition1 = null;
        if (StringUtils.isNotEmpty(gzlid)) {
            queryCondition = new QueryCondition("gzlid", QueryCondition.EQ, gzlid);
        }
        if (StringUtils.isNotEmpty(gzlid)) {
            queryCondition1 = new QueryCondition("jdid", QueryCondition.EQ, jdid);
        }

        queryConditions.add(queryCondition);
        queryConditions.add(queryCondition1);

        List<BdcCqtxjl> bdcCqtxjlList = baseDao.get(BdcCqtxjl.class, queryConditions);
        if (CollectionUtils.isNotEmpty(bdcCqtxjlList)) {
            return bdcCqtxjlList.get(0);
        }
        return null;
    }

    @Override
    public void save(BdcCqtxjl bdcCqtxjl) {
        if (StringUtils.isBlank(bdcCqtxjl.getTxjlid())) {
            bdcCqtxjl.setTxjlid(UUIDGenerator.generate());
        }
        if (StringUtils.isNotBlank(bdcCqtxjl.getGzlid())) {
            bdcCqtxjl.setGzlmc(sysWorkFlowDefineService.getWorkFlowDefine(bdcCqtxjl.getGzlid()).getWorkflowName());
        }
        if (StringUtils.isNotBlank(bdcCqtxjl.getJdid())) {
            List<ActivityModel> activityModelList = new ArrayList<ActivityModel>();
            if (StringUtils.isNotBlank(bdcCqtxjl.getGzlid())) {

                String xml = sysWorkFlowDefineService.getWorkFlowDefineXml(bdcCqtxjl.getGzlid());
                if (StringUtils.isNotBlank(xml)) {
                    WorkFlowXml modelXml = new WorkFlowXml(xml);
                    activityModelList = modelXml.getActivityList();
                }
            }
            if (CollectionUtils.isNotEmpty(activityModelList)) {
                for (ActivityModel activityModel : activityModelList) {
                    if (activityModel != null && StringUtils.equals(activityModel.getDefineId(), bdcCqtxjl.getJdid())) {
                        bdcCqtxjl.setJdmc(activityModel.getActivityDefineName());
                    }
                }
            }
        }
        baseDao.save(bdcCqtxjl);

    }

    @Override
    public void delBdcCqtxjl(String id) {
        baseDao.delete(BdcCqtxjl.class, id);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public BdcCqtxjl getBdcCqtxjl (String gzlid){
        return baseDao.getById(BdcCqtxjl.class, gzlid);
    }

}
