package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.utils.DateUtils;
import com.google.common.collect.Maps;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.TaskBeforeTurnValidationService;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.HashMap;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/10/18
 * @description
 */
@Service
public class YesterdayTaskUnhandledValidationServiceImpl implements TaskBeforeTurnValidationService {
    @Autowired
    private SysTaskService sysTaskService;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Override
    public boolean validateTask(String taskId,String userId) throws PortalException {
        PfTaskVo pfTaskVo = sysTaskService.getTask(taskId);
        //取出工作流定义id
        PfActivityVo pfActivityVo = null;
        if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
            pfActivityVo = sysTaskService.getActivity(pfTaskVo.getActivityId());
            if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId())) {
                PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                if (StringUtils.equals(pfWorkFlowInstanceVo.getPriority(), "2") || StringUtils.equals(pfWorkFlowInstanceVo.getPriority(), "3"))
                    return true;
            }

        }
        //判断当前任务是否是今天的任务
        if(DateUtils.isSameDay(Calendar.getInstance().getTime(),pfTaskVo.getBeginTime())){
            HashMap param = Maps.newHashMap();
            param.put("userId", SessionUtil.getCurrentUserId());
            param.put("FINISH_TIME",DateUtils.formatTime(DateUtils.addDays(Calendar.getInstance().getTime(),-1),DateUtils.DATE_FORMAT));
            int taskCount = Integer.parseInt(sysWorkFlowInstanceService.getTaskCount(param));
            if(taskCount>0)
                throw new PortalException(ExceptionCode.YESTERDAY_TASK_UNHANDLED);
        }
        return true;
    }
}
