package com.gtis.portal.service.impl;

import com.google.common.collect.Maps;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.entity.PfTaskVo;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.PfTaskService;
import com.gtis.portal.service.TaskBeforeTurnValidationService;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;

/**
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2016/10/18
 * @description验证任务是否占用
 */
@Service
public class TaskUsedServiceImpl implements TaskBeforeTurnValidationService {
    @Autowired
    private PfTaskService pfTaskService;


    @Override
    public boolean validateTask(String taskId,String userId) throws PortalException {
        try {
            PfTaskVo pfTaskVo = pfTaskService.queryPfTaskByTaskId(taskId);
            if (pfTaskVo != null && pfTaskVo.getTaskStatus()!=null && pfTaskVo.getTaskStatus()==1  && StringUtils.isNotBlank(pfTaskVo.getOptUserId()) && !StringUtils.equals(userId,pfTaskVo.getOptUserId())) {
                throw  new RuntimeException("该任务"+pfTaskVo.getOptUser()+"正在查看！");
            }
        }catch (PortalException e){
            System.out.println(e);
        }

        return true;
    }
}
