package com.gtis.portal.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.MessageAcceptDao;
import com.gtis.portal.dao.MessageSendDao;
import com.gtis.portal.entity.*;
import com.gtis.portal.service.PfMessageService;
import com.gtis.portal.util.Constants;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.*;

import static com.gtis.portal.entity.QPfMessageSend.pfMessageSend;
import static com.gtis.portal.entity.QPfMessageAccept.pfMessageAccept;

/**
 * Created with IntelliJ IDEA.
 * User: jibo
 * Date: 14-5-8
 * Time: 上午7:35
 * To change this template use File | Settings | File Templates.
 */
@Service
public class PfMessageServiceImpl implements PfMessageService {
    @Autowired
    MessageSendDao messageSendDao;
    @Autowired
    MessageAcceptDao messageAcceptDao;
    @Autowired
    NodeService nodeService;
    @Resource(name = "baseDaoImpl")
    BaseDao baseDao;
    @Autowired
    SysUserService sysUserService;
    @PersistenceContext(unitName = "entityManagerFactory")
    EntityManager em;

    @Override
    public Page<PfMessageSend> queryMessageSendList(String userId, String title, Date beginDate, Date endDate, @PageableDefault(size = 10) Pageable page) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank(userId)) {
            expression = pfMessageSend.messagesendUser.userId.eq(userId);
        }
        if (StringUtils.isNotBlank(title)) {
            expression = expression == null ? pfMessageSend.messagesendTitle.like("%" + title + "%") : expression.and(pfMessageSend.messagesendTitle.like("%" + title + "%"));
        }
        return messageSendDao.findAll(expression, page);
    }

    @Override
    public Page<PfMessageAccept> queryMessageAcceptList(String userId, String slbh,String userName, String title, String sendMessageId, Date beginDate, Date endDate, Pageable page) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank(userId)) {
            expression = pfMessageAccept.messageacceptUser.userId.eq(userId);
        }
        if (StringUtils.isNotBlank(sendMessageId)) {
            expression = (expression == null) ? pfMessageAccept.messageSend.messagesendId.eq(sendMessageId) : expression.and(pfMessageAccept.messageSend.messagesendId.eq(sendMessageId));
        }
        if (StringUtils.isNotBlank(title)) {
            expression = expression == null ? pfMessageAccept.messageSend.messagesendTitle.like("%" + title + "%") : expression.and(pfMessageAccept.messageSend.messagesendTitle.like("%" + title + "%"));
        }
        if (StringUtils.isNotBlank(userName)) {
            expression = expression == null ? pfMessageAccept.messageacceptUser.userName.like("%" + userName + "%") : expression.and(pfMessageAccept.messageacceptUser.userName.like("%" + userName + "%"));
        }
        if (StringUtils.isNotBlank(slbh)) {
            expression = expression == null ? pfMessageAccept.messageSend.messagesendContent.like("%" + slbh + "%") : expression.and(pfMessageAccept.messageSend.messagesendContent.like("%" + slbh + "%"));
        }
        return messageAcceptDao.findAll(expression, page);
    }

    @Override
    public PfMessageSend getMessageSend(String messageId) {
        return messageSendDao.findOne(messageId);
    }

    @Override
    public PfMessageAccept getMessageAccept(String messageId) {
        return messageAcceptDao.findOne(messageId);
    }

    @Override
    public List<PfMessageAccept> queryPfMessageAcceptByMessageId(String messageId) {
        QPfMessageAccept qPfMessageAccept = QPfMessageAccept.pfMessageAccept;
        JPQLQuery query = new JPAQuery(em);
        List<PfMessageAccept> pfMessageAcceptList = query.from(qPfMessageAccept).where(qPfMessageAccept.messageSend.messagesendId.eq(messageId))
                .orderBy(qPfMessageAccept.messageacceptDate.desc()).list(qPfMessageAccept);
        return pfMessageAcceptList;
    }

    @Override
    public void addSendMessage(PfMessageSend pfMessageSend) {
        PfUser pfUser = new PfUser();
        pfUser.setUserId(SessionUtil.getCurrentUserId());
        pfMessageSend.setMessagesendUser(pfUser);
        pfMessageSend.setMessagesendDate(new Date());
        messageSendDao.saveAndFlush(pfMessageSend);
    }

    @Override
    public void addSendMessageInterface(PfMessageSend pfMessageSend) {
        messageSendDao.saveAndFlush(pfMessageSend);
    }

    @Override
    public void updateSendMessage(PfMessageSend pfMessageSend) {
        PfUser pfUser = new PfUser();
        pfUser.setUserId(SessionUtil.getCurrentUserId());
        pfMessageSend.setMessagesendUser(pfUser);
        pfMessageSend.setMessagesendDate(new Date());
        baseDao.update(pfMessageSend);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    @Override
    public void addSendMessageAndAcceptMessage(PfMessageSend pfMessageSend, String users) {
        addSendMessage(pfMessageSend);
        addAcceptMessageByUser(users, pfMessageSend);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    @Override
    public void addSendMessageAndAcceptMessageInterface(PfMessageSend pfMessageSend, String users) {
        addSendMessageInterface(pfMessageSend);
        addAcceptMessageByUser(users, pfMessageSend);
    }

    @Override
    public void addPfLogBySendMessage(PfMessageSend pfMessageSend, String ip) {
        if (pfMessageSend != null) {
            PfLog pfLog = new PfLog();
            pfLog.setId(UUIDGenerator.generate18());
            pfLog.setUserId(SessionUtil.getCurrentUserId());
            pfLog.setAction(Constants.MESSAGE_ACTION);
            pfLog.setContent(pfMessageSend.getMessagesendContent());
            pfLog.setIp(ip);
            pfLog.setCreateTime(new Date());
            addPfLog(pfLog);
        }

    }
    @Override
    public void addPfLogBySendMessageInterface(PfMessageSend pfMessageSend, String ip,String userId) {
        if (pfMessageSend != null) {
            PfLog pfLog = new PfLog();
            pfLog.setId(UUIDGenerator.generate18());
            pfLog.setUserId(userId);
            pfLog.setAction(Constants.MESSAGE_ACTION);
            pfLog.setContent(pfMessageSend.getMessagesendContent());
            pfLog.setIp(ip);
            pfLog.setCreateTime(new Date());
            addPfLog(pfLog);
        }

    }


    @Override
    public void addAcceptMessage(PfMessageAccept pfMessageAccept) {
        baseDao.save(pfMessageAccept);
    }

    @Override
    public void updateAcceptMessageById(String messageacceptId) {
        PfMessageAccept pfMessageAccept = messageAcceptDao.findOne(messageacceptId);
        if (pfMessageAccept != null && pfMessageAccept.getMessageacceptStatus() == 0) {
            pfMessageAccept.setMessageacceptStatus(Constants.MESSAGE_STATUS_READ);
            pfMessageAccept.setMessageacceptDate(new Date());
            baseDao.update(pfMessageAccept);
        }
    }

    @Override
    public boolean addAcceptMessageByUser(String users, PfMessageSend pfMessageSend) {
        boolean result = false;
        if (StringUtils.isBlank(users)) {
            return result;
        }
        List<PfMessageAccept> pfMessageAcceptList = new ArrayList<PfMessageAccept>();
        List<PfUserVo> userList = null;
        if (users.equals("1")) {
            userList = sysUserService.getAllUsers();
        }
        if (CollectionUtils.isEmpty(userList)) {
            StringTokenizer st = new StringTokenizer(users, ",");
            while (st.hasMoreTokens()) {
                pfMessageAcceptList.add(createNewPfMessageAccept(st.nextToken(), pfMessageSend));
            }
        } else {
            for (PfUserVo pfUserVo : userList) {
                pfMessageAcceptList.add(createNewPfMessageAccept(pfUserVo.getUserId(), pfMessageSend));
            }
        }
        if (CollectionUtils.isNotEmpty(pfMessageAcceptList)) {
            for (PfMessageAccept pfMessageAccept : pfMessageAcceptList) {
                baseDao.save(pfMessageAccept);
            }
        }
        result = true;
        return result;
    }

    @Override
    public void addPfLog(PfLog pfLog) {
        baseDao.save(pfLog);
    }

    @Override
    public void deleteAcceptMessage(PfMessageAccept pfMessageAccept) {
        baseDao.delete(PfMessageAccept.class, pfMessageAccept.getMessageacceptId());
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void deleteSendMessage(PfMessageSend pfMessageSend) {
        baseDao.delete(PfMessageSend.class, pfMessageSend.getMessagesendId());
        deleteFileByMessage(pfMessageSend.getMessagesendId(), pfMessageSend.getMessagesendTitle());
    }

    @Override
    public boolean deleteFile(String messagesendId) {
        boolean result = false;
        try {
            Space space = nodeService.getWorkSpace(Constants.MESSAGE_FILE, true);
            Node node = nodeService.getNode(space.getId(), messagesendId, true);
            nodeService.remove(node.getId());
        } catch (Exception e) {
            LoggerFactory.getLogger(PfMessageServiceImpl.class).info("删除附件异常", e);
        }
        result = true;
        return result;
    }

    @Override
    public PfMessageAccept createNewPfMessageAccept(String userId, PfMessageSend pfMessageSend) {
        PfUser pfUser = new PfUser();
        pfUser.setUserId(userId);
        PfMessageAccept pfMessageAccept = new PfMessageAccept();
        pfMessageAccept.setMessageacceptId(UUIDGenerator.generate());
        pfMessageAccept.setMessageacceptStatus(Constants.MESSAGE_STATUS_UNREAD);
        pfMessageAccept.setMessageacceptUser(pfUser);
        pfMessageAccept.setMessageSend(pfMessageSend);
        return pfMessageAccept;
    }

    @Override
    public Long countPfMessageAccept(String userId, Integer status, String messageTitle) {
        QPfMessageAccept qPfMessageAccept = QPfMessageAccept.pfMessageAccept;
        JPQLQuery query = new JPAQuery(em);
        Long count;
        if (StringUtils.isNotBlank(messageTitle)) {
            count = query.from(qPfMessageAccept).where(qPfMessageAccept.messageacceptStatus.eq(0))
                    .where(qPfMessageAccept.messageacceptUser.userId.eq(userId)).where(qPfMessageAccept.messageSend.messagesendTitle.eq(messageTitle)).count();
        } else {
            count = query.from(qPfMessageAccept).where(qPfMessageAccept.messageacceptStatus.eq(0))
                    .where(qPfMessageAccept.messageacceptUser.userId.eq(userId)).count();
        }

        return count;
    }


    @Override
    public Integer createFileFolderByMessage(Integer parentId, String folderNodeName) {
        com.gtis.fileCenter.model.Node tempNode = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank(folderNodeName)) {
            try {
                tempNode = nodeService.getNode(parentId, folderNodeName, true);
            } catch (NodeNotFoundException e) {
                e.printStackTrace();
            }
            return tempNode != null ? tempNode.getId() : -1;
        } else {
            return -1;
        }
    }

    @Override
    public Integer getProjectFileId(String projectId) {
        Space space = nodeService.getWorkSpace(Constants.MESSAGE_FILE);
        Integer nodeId = createFileFolderByMessage(space.getId(), projectId);
        return nodeId;
    }

    public void deleteFileByMessage(String messageId, String title) {
        Integer nodeId = getProjectFileId(messageId);
        try {
            com.gtis.fileCenter.model.Node node = nodeService.getNode(nodeId, title, false);
            nodeService.remove(node.getId());
        } catch (NodeNotFoundException e) {
            LoggerFactory.getLogger(PfMessageServiceImpl.class).info("删除附件异常", e);
            e.printStackTrace();
        }
    }
}
