package com.gtis.portal.service.impl;

import com.alibaba.fastjson.JSON;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.gtis.config.AppConfig;
import com.gtis.portal.service.SmsService;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

import java.util.HashMap;

/**
 * @version 1.0, 2017/12/20.
 * @auto <a href="mailto:liangxichang@gtmap.cn">lxc</a>
 * @description
 */
@Service
public class AliyunSmsServiceImpl implements SmsService {

    Logger logger = Logger.getLogger(AliyunSmsServiceImpl.class);

    /**
     * 阿里云发送短信
     * @param hashMap 参数
     * @param model 模型
     * @param phone 电话
     * @return 发送结果
     */
    @Override
    public String sendSms(HashMap hashMap, String model, String phone){
        String result = null;
        System.setProperty("sun.net.client.defaultConnectTimeout", "1000");
        System.setProperty("sun.net.client.defaultReadTimeout", "1000");
//初始化ascClient需要的几个参数
        final String product = "Dysmsapi";//短信API产品名称（短信产品名固定，无需修改）
        final String domain = "dysmsapi.aliyuncs.com";//短信API产品域名（接口地址固定，无需修改）
//替换成你的AK
        final String accessKeyId = AppConfig.getProperty("aliyun.send.msg.accessId");//你的accessKeyId,参考本文档步骤2
        final String accessKeySecret = AppConfig.getProperty("aliyun.send.msg.accessKeySecret");//你的accessKeySecret，参考本文档步骤2
//初始化ascClient,暂时不支持多region（请勿修改）
        IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", accessKeyId,
                accessKeySecret);
        try {
            DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", product, domain);
        } catch (ClientException e) {
            logger.info(e);
        }
        IAcsClient acsClient = new DefaultAcsClient(profile);
        //组装请求对象
        SendSmsRequest request = new SendSmsRequest();
        //使用post提交
        request.setMethod(MethodType.POST);
        //必填:待发送手机号。支持以逗号分隔的形式进行批量调用，批量上限为1000个手机号码,批量调用相对于单条调用及时性稍有延迟,验证码类型的短信推荐使用单条调用的方式
        request.setPhoneNumbers(phone);
        //必填:短信签名-可在短信控制台中找到
        request.setSignName(AppConfig.getProperty("aliyun.send.msg.signName"));
        //必填:短信模板-可在短信控制台中找到
        request.setTemplateCode(AppConfig.getProperty("aliyun.send.msg.model"));
        //可选:模板中的变量替换JSON串,如模板内容为"亲爱的${name},您的验证码为${code}"时,此处的值为
        //友情提示:如果JSON中需要带换行符,请参照标准的JSON协议对换行符的要求,比如短信内容中包含\r\n的情况在JSON中需要表示成\\r\\n,否则会导致JSON在服务端解析失败
        request.setTemplateParam(JSON.toJSONString(hashMap));
        //可选-上行短信扩展码(扩展码字段控制在7位或以下，无特殊需求用户请忽略此字段)
        //request.setSmsUpExtendCode("90997");
        //可选:outId为提供给业务方扩展字段,最终在短信回执消息中将此值带回给调用者
//        request.setOutId("yourOutId");
//请求失败这里会抛ClientException异常
        SendSmsResponse sendSmsResponse = null;
        try {
            sendSmsResponse = acsClient.getAcsResponse(request);
            if(sendSmsResponse.getCode() != null && StringUtils.equals(sendSmsResponse.getCode(), "OK")) {
                result = "success";
            }else {
                //请求失败
                logger.error("阿里云短信发送失败，失败代码：" + sendSmsResponse.getCode());
                result=sendSmsResponse.getCode();
            }

        } catch (ClientException e) {
            result = "smsSendErr";
            logger.info(e);
        }
        return result;
    }
}
