/**
 * Created by songhaowen on 2017/11/29.
 */
$(function () {
    $rownum = 10;
    initWorkFlowEventList();
    //项目表搜索事件
    $("#search").click(function () {
        var xmmc = $("#search_xmmc").val();
        var url = portalUrl + "/workFlowEvent/initEventList";
        tableReload("grid-table", url, {dcxc: xmmc});
    });

    //关闭事件
    $("#proHide").click(function () {
        $("#addWorkFlowEvent").hide();
        $("#addWorkFlowEventForm")[0].reset();
        $(".chosen-select").trigger('chosen:updated');
        $('#messagesendId').val('');
    });
    //项目高级查询按钮点击事件
    $("#show").click(function () {
        $("#addWorkFlowEventPop").show();
        $(window).trigger('resize.chosen');
        $(".modal-dialog").css({"_margin-left": "25%"});
    });

    $('#add').click(function () {
        $('#addWorkFlowEvent').show();
    });

    $('#modify').click(function () {
        var defaultUrl = portalUrl + "/workFlowEvent/getWorkFlowEvent";
        var eventIds = getSelectedArray();
        if (eventIds == '' || eventIds == undefined || eventIds.length > 1) {
            tipInfo("请选择一条数据");
            return false;
        }
        var eventId = eventIds[0];
        $.ajax({
            url: defaultUrl,
            type: 'POST',
            dataType: 'json',
            data: {id: eventId},
            success: function (data) {
                if (data != null && data.pfWorkFlowEvent != null) {
                    $('#workFlowNameModify').val(data.pfWorkFlowEvent.workFlowName);
                    $('#workFlowEventUrlModify').val(data.pfWorkFlowEvent.workFlowEventUrl);
                    $('#workFlowEventAsynModify').val(data.pfWorkFlowEvent.workFlowEventAsyn);
                    $('#workFlowEventNameModify').val(data.pfWorkFlowEvent.workFlowEventName);
                    $('#workFlowEventOrderModify').val(data.pfWorkFlowEvent.workFlowEventOrder);
                    $('#workFlowEventMethodModify').val(data.pfWorkFlowEvent.workFlowEventMethod);
                    $('#eventId').val(data.pfWorkFlowEvent.id);
                    $("#targetActivityDefinitionNameModify").val(data.pfWorkFlowEvent.targetActivityDefinitionName);
                    loadWorkflowNameModify($('#workFlowDefinitionIdModify'), data.pfWorkFlowEvent.workFlowName, data.pfWorkFlowEvent.workFlowDefinitionId);
                    loadWorkflowActivityListModify($('#activityDefinitionIdModify'), data.pfWorkFlowEvent.workFlowDefinitionId, data.pfWorkFlowEvent.activityDefinitionId);
                    loadWorkflowActivityListModify($('#targetactivityDefinitionIdModify'), data.pfWorkFlowEvent.workFlowDefinitionId, data.pfWorkFlowEvent.targetActivityDefinitionId);
                    loadBusinessModify($('#businessModify'), data.businessName, data.businessId);
                    $('#modifyWorkFlowEvent').show();

                }
            },
            error: function (data) {
            }
        });
    });

    $('#delete').click(function () {
        var defaultUrl = portalUrl + "/workFlowEvent/deleteWorkFlowEvent";
        var eventId = getSelectedArray();
        if (eventId == '' || eventId == undefined) {
            tipInfo("请选择一条数据");
            return false;
        }
        $.ajax({
            url: defaultUrl,
            type: 'POST',
            dataType: 'json',
            data: {id: eventId.join()},
            success: function (data) {
                if (data) {
                    tipInfo("删除成功");
                    tableReload("grid-table", portalUrl + "/workFlowEvent/initEventList", {dcxc: ""});
                }
            },
            error: function (data) {
            }
        });
    });

    $('#addEventBtn').click(function () {
        $.blockUI({message: "请稍等……"});
        var defaultUrl = portalUrl + "/workFlowEvent/addWorkFlowEvent";
        $.ajax({
            url: defaultUrl,
            type: 'POST',
            dataType: 'json',
            data: $("#addWorkFlowEventForm").serialize(),
            success: function (data) {
                setTimeout($.unblockUI, 10);
                if (data) {
                    tipInfo("保存成功");
                    closeDialog('addWorkFlowEvent', 'addWorkFlowEventForm');
                    tableReload("grid-table", portalUrl + "/workFlowEvent/initEventList", {dcxc: ""});
                }
            },
            error: function (data) {
            }
        });
    });

    $('#modifyEventBtn').click(function () {
        $.blockUI({message: "请稍等……"});
        var defaultUrl = portalUrl + "/workFlowEvent/modifyWorkFlowEvent";
        $.ajax({
            url: defaultUrl,
            type: 'POST',
            dataType: 'json',
            data: $("#modifyWorkFlowEventForm").serialize(),
            success: function (data) {
                setTimeout($.unblockUI, 10);
                if (data) {
                    tipInfo("更新成功");
                    closeDialog('modifyWorkFlowEvent', 'modifyWorkFlowEventForm');
                    tableReload("grid-table", portalUrl + "/workFlowEvent/initEventList", {dcxc: ""});
                }
            },
            error: function (data) {
            }
        });
    });

    $('#import').click(function () {
        $('#importWorkFlowEvent').show();
    });

    $('#importEventBtn').click(function () {
        $.blockUI({message: "请稍等……"});
        var defaultUrl = portalUrl + "/workFlowEvent/importWorkFlowEvent";
        $.ajax({
            url: defaultUrl,
            type: 'POST',
            dataType: 'json',
            data: $("#importWorkFlowEventForm").serialize(),
            success: function (data) {
                setTimeout($.unblockUI, 10);
                if (data.result == '' || data.result == undefined) {
                    tipInfo("导入成功");
                    cleanPfCache();
                    tableReload("grid-table", portalUrl + "/workFlowEvent/initEventList", {dcxc: ""});
                } else {
                    tipInfo(data.result);
                }
                closeDialog('importWorkFlowEvent', 'importWorkFlowEventForm');
            },
            error: function (data) {
            }
        });
    });

    $('select[name=BUSINESS_ID]').change(function () {
        var businessId = $(this).val();
        var workFlowDefinitionId = $(this).parents('.row').find('select[name=workFlowDefinitionId]');
        loadWorkflowDefinitionList(workFlowDefinitionId, businessId);
    });

    $('select[name=workFlowDefinitionId]').change(function () {
        var wfDefintionId = $(this).val();
        var workflowname = $(this).find("option:selected").text();
        $('#workFlowName').val(workflowname);
        $('#workFlowNameModify').val(workflowname);
        $('#workFlowNameImport').val(workflowname);
        loadWorkflowActivityList($(this).parents('.row').find('select[name=activityDefinitionId]'), wfDefintionId);
        //加载目标节点数据
        loadWorkflowActivityList($(this).parents('.row').find('select[name=targetActivityDefinitionId]'), wfDefintionId);
    });
    $('select[name=targetActivityDefinitionId]').change(function () {
        var targetActivityDefinitionName = $(this).find("option:selected").text();
        $('#targetActivityDefinitionName').val(targetActivityDefinitionName);
        $('#targetActivityDefinitionNameModify').val(targetActivityDefinitionName);
    });
});

function loadWorkflowDefinitionList(elements, businessId) {
    var url = portalUrl + '/taskCenter/getWorkflowDefinitions';
    var param = {
        businessId: businessId
    };
    $.post(url, param, function (result) {
        result.unshift({workflowName: '', workflowDefinitionId: ''});
        var data = {
            workflowDeinfitionList: result
        }
        $(elements).each(function () {
            $(this).empty();
            if (data != null) {
                for (var i = 0; i < data.workflowDeinfitionList.length; i++) {
                    $(this).append(" <option value=" + data.workflowDeinfitionList[i].workflowDefinitionId + ">" + data.workflowDeinfitionList[i].workflowName + "</option>");
                }
            }
        });
    });
}

function loadWorkflowNameModify(elements, workFlowName, workFlowDefinitionId) {
    $(elements).each(function () {
        $(this).empty();
        $(this).append(" <option selected value=" + workFlowDefinitionId + ">" + workFlowName + "</option>");
    });
}

function loadBusinessModify(elements, businessName, businessId) {
    $(elements).each(function () {
        $(this).empty();
        $(this).append(" <option selected value=" + businessId + ">" + businessName + "</option>");
    });
}

function loadWorkflowActivityListModify(elements, wfDefintionId, activityDefinitionId) {
    var url = portalUrl + '/taskCenter/getWorkflowActivitys';
    var param = {
        wfDefintionId: wfDefintionId
    };
    $.post(url, param, function (result) {
        result.unshift({activityName: '', activityId: ''});
        var data = {
            workflowActivityList: result
        };
        $(elements).each(function () {
            $(this).empty();
            if (data != null) {
                for (var i = 0; i < data.workflowActivityList.length; i++) {
                    var selected = (activityDefinitionId == data.workflowActivityList[i].activityId) ? "selected" : "";
                    $(this).append(" <option " + selected + " value=" + data.workflowActivityList[i].activityId + ">" + data.workflowActivityList[i].activityName + "</option>");
                }
            }
        });
    });
}


function loadWorkflowActivityList(elements, wfDefintionId) {
    var url = portalUrl + '/taskCenter/getWorkflowActivitys';
    var param = {
        wfDefintionId: wfDefintionId
    };
    $.post(url, param, function (result) {
        result.unshift({activityName: '', activityId: ''});
        var data = {
            workflowActivityList: result
        };
        $(elements).each(function () {
            $(this).empty();
            if (data != null) {
                for (var i = 0; i < data.workflowActivityList.length; i++) {
                    $(this).append(" <option value=" + data.workflowActivityList[i].activityId + ">" + data.workflowActivityList[i].activityName + "</option>");
                }
            }
        });
    });
}

function setActivityName(grid_selector) {
    var jqData = $(grid_selector).jqGrid("getRowData");
    $.each(jqData, function (index, data) {
        loadWorkflowActivityName(data.workFlowDefinitionId, data.activityDefinitionId, data.id, grid_selector);
    })
}

function loadWorkflowActivityName(wfDefintionId, workFlowActivityId, id, grid_selector) {
    var name = '';
    var url = portalUrl + '/taskCenter/getWorkflowActivitys';
    var param = {
        wfDefintionId: wfDefintionId
    };
    $.post(url, param, function (result) {
        result.unshift({activityName: '', activityId: ''});
        var data = {
            workflowActivityList: result
        };
        if (data != null) {
            for (var i = 0; i < data.workflowActivityList.length; i++) {
                var activity = data.workflowActivityList[i];
                if (activity.activityId == workFlowActivityId) {
                    name = activity.activityName;
                    $(grid_selector).setCell(id, "activityDefinitionName", name);
                    break;
                }
            }
        }
    });
    return name;
}

function getSelectedId() {
    var eventId = '';
    var chk_value = $('#grid-table').jqGrid('getGridParam', 'selarrrow');
    for (var i = 0; i < chk_value.length; i++) {
        var rowData = $('#grid-table').jqGrid('getRowData', chk_value[i]);
        if (eventId == '') {
            eventId = rowData.id;
            break;
        }
    }
    return eventId;
}

function getSelectedArray() {
    var eventId = new Array();
    var chk_value = $('#grid-table').jqGrid('getGridParam', 'selarrrow');
    for (var i = 0; i < chk_value.length; i++) {
        var rowData = $('#grid-table').jqGrid('getRowData', chk_value[i]);
        eventId.push(rowData.id);
    }
    return eventId;
}


function closeDialog(id, form) {
    $("#" + id).hide();
    $("#" + form)[0].reset();
    $('#messagesendId').val('');
    $('#messagesendIdUpdate').val('');
    $('#messagesendContentUpdate').val('');
    $('#messagesendContent').val('');
}


function initWorkFlowEventList() {
    var grid_selector = "#grid-table";
    var pager_selector = "#grid-pager";
    jQuery(grid_selector).jqGrid({
        url: portalUrl + "/workFlowEvent/initEventList",
        datatype: "json",
        height: 'auto',
        jsonReader: {id: 'id'},
        colNames: ['执行顺序', '流程名称', '节点', '目标节点', '工作流事件', '工作流事件方法', '是否异步', '请求方式','id', 'activityDefinitionId', 'workFlowDefinitionId'],
        colModel: [
            {name: 'workFlowEventOrder', index: 'workFlowEventOrder', width: '10%', sortable: false, hidden: false},
            {
                name: 'workFlowName', index: 'workFlowName', width: '30%', sortable: false,
                formatter: function (cellvalue, options, rowObject) {
                    if (cellvalue != "") {
                        cellvalue = '<span class="label label-success">' + rowObject.workFlowName + '</span>';
                    }
                    return cellvalue;
                }
            },
            {
                name: 'activityDefinitionName',
                index: 'activityDefinitionName',
                width: '15%',
                sortable: false,
                hidden: false
            }, {
                name: 'targetActivityDefinitionName',
                index: 'targetActivityDefinitionName',
                width: '15%',
                sortable: false,
                hidden: false
            },
            {
                name: 'workFlowEventName', index: 'workFlowEventName', width: '10%', sortable: false, hidden: false,
                formatter: function (cellvalue, options, rowObject) {
                    if (cellvalue != "") {
                        var value = '';
                        if (rowObject.workFlowEventName == 'WorkFlow_BeforeTurn') {
                            value = '转发前';
                        }
                        if (rowObject.workFlowEventName == 'WorkFlow_Turn') {
                            value = '转发';
                        }
                        if (rowObject.workFlowEventName == 'WorkFlow_BeforeBack') {
                            value = '退回前';
                        }
                        if (rowObject.workFlowEventName == 'WorkFlow_Back') {
                            value = '退回';
                        }
                        if (rowObject.workFlowEventName == 'WorkFlow_End') {
                            value = '办结';
                        }
                        if (rowObject.workFlowEventName == 'WorkFlow_BeforeDel') {
                            value = '删除前';
                        }
                        if (rowObject.workFlowEventName == 'WorkFlow_Del') {
                            value = '删除';
                        }
                        if (rowObject.workFlowEventName == 'WorkFlow_Post') {
                            value = '挂起后';
                        }
                        if (rowObject.workFlowEventName == 'WorkFlow_UnPost') {
                            value = '解挂后';
                        }
                        cellvalue = '<span class="label label-success">' + value + '</span>';
                    }
                    return cellvalue;
                }
            },
            {name: 'workFlowEventUrl', index: 'workFlowEventUrl', width: '45%', sortable: false, hidden: false},
            {
                name: 'workFlowEventAsyn', index: 'workFlowEventAsyn', width: '15%', sortable: false, hidden: false,
                formatter: function (cellvalue, options, rowObject) {
                    if (cellvalue != "") {
                        var value = rowObject.workFlowEventAsyn == '1' ? '是' : '否';
                        cellvalue = '<span class="label label-success">' + value + '</span>';
                    }
                    return cellvalue;
                }
            },
            {name: 'workFlowEventMethod', index: 'workFlowEventMethod', width: '15%', sortable: false, hidden: false},
            {name: 'id', index: 'id', sortable: false, hidden: true},
            {name: 'activityDefinitionId', index: 'activityDefinitionId', sortable: false, hidden: true},
            {name: 'workFlowDefinitionId', index: 'workFlowDefinitionId', sortable: false, hidden: true}
        ],
        viewrecords: true,
        rowNum: $rownum,
        rowList: [10, 20, 30],
        pager: pager_selector,
        pagerpos: "left",
        multiselect: true,
        altRows: false,
        loadComplete: function () {
            var table = this;
            setActivityName(grid_selector);
            setTimeout(function () {
                updatePagerIcons(table);
                enableTooltips(table);
                //resize
                $(grid_selector).jqGrid('setGridWidth', $(".page-content").width());
            }, 0);
        },
        autowidth: true
    });

    $('#cleanEventBtn').click(function () {
        $.blockUI({message: "请稍等……"});
        var defaultUrl = portalUrl + "/workFlowEvent/cleanWorkFlowEvent";
        $.ajax({
            url: defaultUrl,
            type: 'POST',
            dataType: 'json',
            data: $("#importWorkFlowEventForm").serialize(),
            success: function (data) {
                setTimeout($.unblockUI, 10);
                if (data.result == '' || data.result == undefined) {
                    tipInfo("清空成功");
                    cleanPfCache();
                } else {
                    tipInfo(data.result);
                }
            },
            error: function (data) {
                setTimeout($.unblockUI, 10);
            }
        });
    });

    $('#batchImport').click(function () {
        $.blockUI({message: "请稍等……"});
        var defaultUrl = portalUrl + "/workFlowEvent/batchImportPfWorkFlowEvent";
        $.ajax({
            url: defaultUrl,
            type: 'POST',
            dataType: 'json',
            success: function (data) {
                setTimeout($.unblockUI, 10);
                if (data.result == '' || data.result == undefined) {

                    tipInfo("导入成功");

                    tableReload("grid-table", portalUrl + "/workFlowEvent/initEventList", {dcxc: ""});
                } else {
                    tipInfo(data.result);
                }
            },
            error: function (data) {
            }
        });
    });
}

function cleanPfCache() {
    var pfCacheUrl = platform_url + "/cache!clean.action?name=all";
    $.ajax({
        url: pfCacheUrl,
        type: 'GET',
        success: function (data) {
        },
        error: function (data) {
        }
    });
}
