var ke;
var f;
$(function () {
    $rownum = 10;
    initNewsList();
    //搜索事件
    $("#search").click(function () {
        var fbnr = $("#search_fbnr").val();
        var beginDate = $("#begindate").val();
        var endDate = $("#enddate").val();
        var url = portalUrl + "/news/newsListPage";
        tableReload("grid-table", url, {dcxc: fbnr, beginDate: beginDate, endDate: endDate});
    });
    //新增事件
    $('#add,#enSureBtn').click(function () {
        var defaultUrl = portalUrl + "/news/createNews";
        if (ke != null && ke != undefined) {
            ke.sync('#newcontent');
        }
        $.ajax({
            url: defaultUrl,
            type: 'POST',
            dataType: 'json',
            data: $("#addNewsForm").serialize(),
            success: function (data) {
                var newId = data.newId;
                var token = data.token;
                var nodeId = data.nodeId;
                var result = data.result;
                if (newId != '' && newId != undefined) {
                    $('#newid').val(newId);
                    createKindEditor('#newcontent', nodeId, token);
                    $('#addNews').show();
                } else if (result) {
                    closeDialog('addNews', 'addNewsForm');
                    tableReload("grid-table", portalUrl + "/news/newsListPage", {dcxc: '', beginDate: '', endDate: ''});
                }
            },
            error: function (data) {
            }
        });
    });
    //更新数据操作
    $('#updateNewsBtn').click(function () {
        var defaultUrl = portalUrl + "/news/updateNews";
        if (ke != null && ke != undefined) {
            ke.sync('#newcontentUpdate');
        }
        $.ajax({
            url: defaultUrl,
            type: 'POST',
            dataType: 'json',
            data: $("#newsUpdateForm").serialize(),
            success: function (data) {
                if (data) {
                    alert('修改成功')
                }
                closeDialog('newsUpdate', 'newsUpdateForm');
                tableReload("grid-table", portalUrl + "/news/newsListPage", {dcxc: '', beginDate: '', endDate: ''});
            },
            error: function (data) {
            }
        });
    })
});
//转换日期格式(时间戳转换为datetime格式)
function changeDateFormat(obj) {
    var dateVal = obj + "";
    if (obj != null) {
        var date = new Date(parseInt(dateVal.replace("/Date(", "").replace(")/", ""), 10));
        var month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
        var currentDate = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();

        var hours = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
        var minutes = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
        var seconds = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();

        return date.getFullYear() + "-" + month + "-" + currentDate + " " + hours + ":" + minutes + ":" + seconds;
    }
}
function closeDialog(id, form) {
    $("#" + id).hide();
    $("#" + form)[0].reset();
    $('#newid').val('');
    $('#newcontent').val('');
    ke.remove();
}
//修改页面的数据初始化
function showNewsUpdate(newId) {
    $.ajax({
        url: portalUrl + "/news/getModify",
        type: 'POST',
        dataType: 'json',
        data: {newId: newId},
        success: function (data) {
            var token = data.token;
            var nodeId = data.nodeId;
            $('#newtitleUpdate').val(data.pfNews.newtitle);
            $('#newpublisherUpdate').val(data.pfNews.newpublisher);
            $('#newdateUpdate').val(changeDateFormat(data.pfNews.newdate));
            $('#ispublishUpdate').val(data.pfNews.ispublish);
            $('#newidUpdate').val(data.pfNews.newid); $('#newcontentUpdate').val(data.pfNews.newcontent);
            createKindEditor('#newcontentUpdate', nodeId, token);
            $('#newsUpdate').show();
        },
        error: function (data) {
        }
    })
}

//删除记录
function deleteNews() {
    var chk_value = $('#grid-table').jqGrid('getGridParam', 'selarrrow');
    if (chk_value == null || chk_value.length == 0) {
        alert("请选择一条记录！");
        return;
    }
    for (var i = 0; i < chk_value.length; i++) {
        var rowData = $('#grid-table').jqGrid('getRowData', chk_value[i]);
        deleteNew(rowData.newid);
    }
}

//删除记录
function deleteNew(newid) {
    var deleteNewsUrl = portalUrl + "/news/deleteNews";
    $.ajax({
        url: deleteNewsUrl,
        type: 'POST',
        dataType: 'json',
        data: {newid: newid},
        success: function (result) {
            if (result) {
                tableReload("grid-table", portalUrl + "/news/newsListPage", {dcxc: '', beginDate: '', endDate: ''});
                alert("删除成功");
            }
        },
        error: function (result) {
            alert('删除失败');
        }
    });
}

//初始化加载list列表的数据
function initNewsList() {
    var grid_selector = "#grid-table";
    var pager_selector = "#grid-pager";
    jQuery(grid_selector).jqGrid({
        url: portalUrl + "/news/newsListPage",
        datatype: "json",
        height: 'auto',
        jsonReader: {id: 'newid'},
        colNames: ['发布人', '标题', '发布内容', '发布时间', '是否发布', 'id'],
        colModel: [
            {
                name: 'newpublisher', index: 'newpublisher', width: '5%', sortable: false,
                formatter: function (cellvalue, options, rowObject) {
                    if (cellvalue != "" && cellvalue != undefined) {
                        cellvalue = '<span class="label label-success">' + rowObject.newpublisher + '</span>';
                    } else {
                        cellvalue = '';
                    }

                    return cellvalue;
                }
            },
            {
                name: 'newtitle',
                index: 'newtitle',
                width: '20%',
                sortable: false,
                formatter: function (cellvalue, options, rowObject) {

                    if (cellvalue != "" && cellvalue != undefined) {
                        cellvalue = '<a href="javascript:void(0)" onclick="showNewsUpdate(\'' + rowObject.newid + '\')">' + rowObject.newtitle + '</a>';
                    } else {
                        cellvalue = '';
                    }
                    return cellvalue;
                }
            },
            {
                name: 'newcontent', index: 'newcontent', width: '70%', sortable: false,
                formatter: function (cellvalue, options, rowObject) {
                    if (cellvalue != "" && cellvalue != undefined) {
                        cellvalue = '<div class="contentText">' + cellvalue + '</div>';
                    } else {
                        cellvalue = '';
                    }
                    return cellvalue;
                }
            }, {
                name: 'newdate',
                index: 'newdate',
                width: '10%',
                sortable: false,
                formatter: function (cellvalue, options, rowObject) {
                    if (cellvalue == undefined) {
                        return '';
                    }
                    var value = cellvalue;
                    var data = new Date(value).Format("yyyy-MM-dd hh:mm:ss");
                    return data;
                }
            },
            {
                name: 'ispublish', index: 'ispublish', width: '5%', sortable: false,
                formatter: function (cellvalue, options, rowObject) {
                    if (cellvalue != "" && cellvalue != undefined) {
                        if (cellvalue == "1")
                            cellvalue = '<div class="contentText">是</div>';
                        else
                            cellvalue = '<div class="contentText">否</div>';
                    } else {
                        cellvalue = '';
                    }
                    return cellvalue;
                }
            },
            {name: 'newid', index: 'newid', width: '30%', sortable: false, hidden: true}
        ],
        viewrecords: true,
        rowNum: $rownum,
        rowList: [10, 20, 30],
        pager: pager_selector,
        pagerpos: "left",
        multiselect: true,
        altRows: false,
        loadComplete: function () {
            var table = this;
            setTimeout(function () {
                updatePagerIcons(table);
                enableTooltips(table);
                //resize
                $(grid_selector).jqGrid('setGridWidth', $(".page-content").width());
            }, 0);
        },
        autowidth: true
    });
}
