/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.server.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.server.WorkFlowCommissionDao;
import com.gtis.portal.entity.QWorkFlowCommission;
import com.gtis.portal.entity.WorkFlowCommission;
import com.gtis.portal.service.server.WorkFlowCommissionService;
import com.gtis.portal.util.QueryCondition;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkFlowCommissionServiceImpl
implements WorkFlowCommissionService {
    @Autowired
    WorkFlowCommissionDao workFlowCommissionDao;
    @Resource(name="serverBaseDaoImpl")
    BaseDao baseDao;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysUserService sysUserService;

    public Page<WorkFlowCommission> queryWorkFlowCommissionList(String workFlowId, String principalId, String agentId, Pageable page) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank((String)workFlowId)) {
            expression = QWorkFlowCommission.workFlowCommission.workFlowId.eq((Object)workFlowId);
        }
        if (StringUtils.isNotBlank((String)principalId)) {
            expression = expression == null ? QWorkFlowCommission.workFlowCommission.principalId.eq((Object)principalId) : expression.and((Predicate)QWorkFlowCommission.workFlowCommission.principalId.eq((Object)principalId));
        }
        if (StringUtils.isNotBlank((String)agentId)) {
            expression = expression == null ? QWorkFlowCommission.workFlowCommission.agentId.eq((Object)agentId) : expression.and((Predicate)QWorkFlowCommission.workFlowCommission.agentId.eq((Object)agentId));
        }
        return this.workFlowCommissionDao.findAll((Predicate)expression, page);
    }

    public WorkFlowCommission getWorkFlowCommissionByWdidAndYhid(String workFlowId, String principalId, String agentId) {
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("workFlowId", "=", (Object)workFlowId);
        QueryCondition queryCondition1 = new QueryCondition("principalId", "=", (Object)principalId);
        QueryCondition queryCondition2 = new QueryCondition("agentId", "=", (Object)agentId);
        queryConditions.add(queryCondition);
        queryConditions.add(queryCondition1);
        queryConditions.add(queryCondition2);
        List bdcZdpjjlList = this.baseDao.get(WorkFlowCommission.class, queryConditions);
        if (CollectionUtils.isNotEmpty((Collection)bdcZdpjjlList)) {
            return (WorkFlowCommission)bdcZdpjjlList.get(0);
        }
        return null;
    }

    public void save(WorkFlowCommission workFlowCommission) {
        PfUserVo pfAgentUserVo;
        PfUserVo pfPrincipalUserVo;
        if (StringUtils.isBlank((String)workFlowCommission.getWorkFlowCommissionId())) {
            workFlowCommission.setWorkFlowCommissionId(UUIDGenerator.generate());
        }
        WorkFlowCommission getWorkFlowCommission = this.getWorkFlowCommission(workFlowCommission.getWorkFlowCommissionId());
        if (StringUtils.isNotBlank((String)workFlowCommission.getWorkFlowId())) {
            workFlowCommission.setWorkFlowName(this.sysWorkFlowDefineService.getWorkFlowDefine(workFlowCommission.getWorkFlowId()).getWorkflowName());
        }
        if (StringUtils.isNotBlank((String)workFlowCommission.getPrincipalId()) && (pfPrincipalUserVo = this.sysUserService.getUserVo(workFlowCommission.getPrincipalId())) != null) {
            workFlowCommission.setPrincipalName(pfPrincipalUserVo.getUserName());
        }
        if (StringUtils.isNotBlank((String)workFlowCommission.getAgentId()) && (pfAgentUserVo = this.sysUserService.getUserVo(workFlowCommission.getAgentId())) != null) {
            workFlowCommission.setAgentName(pfAgentUserVo.getUserName());
        }
        if (getWorkFlowCommission != null) {
            this.updateWorkFlowCommission(workFlowCommission);
        } else {
            this.addWorkFlowCommission(workFlowCommission);
        }
    }

    public WorkFlowCommission getWorkFlowCommission(String workFlowCommissionId) {
        return (WorkFlowCommission)this.baseDao.getById(WorkFlowCommission.class, (Object)workFlowCommissionId);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void delWorkFlowCommission(String id) {
        this.baseDao.delete(WorkFlowCommission.class, (Object)id);
    }

    public List<WorkFlowCommission> getWorkFlowCommissionByAgentId(String agentId) {
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("agentId", "=", (Object)agentId);
        queryConditions.add(queryCondition);
        return this.baseDao.get(WorkFlowCommission.class, queryConditions);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void updateWorkFlowCommission(WorkFlowCommission workFlowCommission) {
        this.baseDao.update((Object)workFlowCommission);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void addWorkFlowCommission(WorkFlowCommission workFlowCommission) {
        this.baseDao.save((Object)workFlowCommission);
    }
}

