/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl.quartz;

import com.google.common.collect.Maps;
import com.gtis.common.Page;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SplitDataService;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.portal.util.ReadXmlProps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class AutoPostTaskService {
    @Autowired
    SplitDataService splitDataService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysCalendarService sysCalendarService;
    protected final Logger logger = Logger.getLogger(this.getClass());

    @Scheduled(cron="${autoPostTask.quartz.config}")
    public void autoPostTask() {
        String autoPostTaskEnable = AppConfig.getProperty((String)"autoPostTask.enable");
        String userid = AppConfig.getProperty((String)"autoPostTask.userid");
        String reason = AppConfig.getProperty((String)"autoPostTask.reason");
        List overTimeConfigList = ReadXmlProps.getOverTimeConfigList();
        if (StringUtils.equals((String)autoPostTaskEnable, (String)"true") && CollectionUtils.isNotEmpty((Collection)overTimeConfigList)) {
            if (StringUtils.isBlank((String)userid)) {
                userid = "0";
            }
            if (StringUtils.isBlank((String)reason)) {
                reason = "\u81ea\u52a8\u6302\u8d77";
            }
            try {
                HashMap mapParam2 = Maps.newHashMap();
                mapParam2.put("TASK_STATE", "1");
                mapParam2.put("STATE", "1");
                String noComputeActivityNames = AppConfig.getProperty((String)"overTime.noCompute.activityNames");
                if (StringUtils.isNotBlank((String)noComputeActivityNames)) {
                    String[] activityNameArray = noComputeActivityNames.split(",");
                    String activityNames = null;
                    for (String activityName : activityNameArray) {
                        activityNames = StringUtils.isBlank(activityNames) ? "'" + activityName + "'" : activityNames + ",'" + activityName + "'";
                    }
                    mapParam2.put("NOT_IN_ACTIVITY_NAMES", activityNames);
                }
                List overTimeList = null;
                int overTimeListSize = this.splitDataService.getCount("getTaskList", (Object)mapParam2);
                Page overTimeListPage = this.splitDataService.query("getTaskList", (Object)mapParam2, 0, overTimeListSize);
                if (overTimeListPage != null && overTimeListPage.getItems() != null && overTimeListPage.getItems() != null) {
                    overTimeList = overTimeListPage.getItems();
                }
                if (CollectionUtils.isNotEmpty(overTimeList)) {
                    for (HashMap taskListMap : overTimeList) {
                        for (Map overTimeConfigMap : overTimeConfigList) {
                            if (taskListMap.get("WORKFLOW_NAME") == null || overTimeConfigMap.get("wfName") == null || overTimeConfigMap.get("activityName") == null || taskListMap.get("ACTIVITY_NAME") == null || !StringUtils.equals((String)taskListMap.get("WORKFLOW_NAME").toString(), (String)overTimeConfigMap.get("wfName").toString()) || !StringUtils.equals((String)taskListMap.get("ACTIVITY_NAME").toString(), (String)overTimeConfigMap.get("activityName").toString()) || taskListMap.get("TASK_OVER_TIME") == null || overTimeConfigMap.get("overtimeDay") == null) continue;
                            String day = (new Date().getTime() - ((Date)taskListMap.get("TASK_OVER_TIME")).getTime()) / 86400000L + "";
                            List holidayList = this.sysCalendarService.getHolidayList((Date)taskListMap.get("TASK_OVER_TIME"), new Date());
                            int workDay = 0;
                            if (StringUtils.isNotBlank((String)day)) {
                                workDay = Integer.parseInt(day);
                            }
                            if (CollectionUtils.isNotEmpty((Collection)holidayList)) {
                                workDay -= holidayList.size();
                            }
                            if (workDay < Integer.parseInt(overTimeConfigMap.get("overtimeDay").toString())) continue;
                            this.workFlowCoreService.lockWorkFlowInstance(taskListMap.get("WORKFLOW_INSTANCE_ID").toString(), taskListMap.get("ASSIGNMENT_ID").toString(), reason, userid);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("\u81ea\u52a8\u6302\u8d77\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage()));
            }
        }
    }
}

