/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.service.portal.TaskPerformerFilterService;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.portal.entity.BdcXm;
import com.gtis.portal.service.TaskAfterTurnGeneralService;
import com.gtis.portal.service.server.AutoTurnAllTaskService;
import com.gtis.portal.service.server.AutoTurnTaskService;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.support.spring.PerformanceMonitorInterceptor;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TaskPerformerMinWorkloadFilterServiceImpl
implements TaskPerformerFilterService {
    private static final Logger log = LoggerFactory.getLogger(PerformanceMonitorInterceptor.class);
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    AutoTurnTaskService autoTurnTaskService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Resource(name="taskPerformerMinWorkloadFilterService")
    TaskPerformerFilterService taskPerformerFilterService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysTaskService sysTaskService;
    @Resource(name="taskAfterTurnGeneralServiceImpl")
    TaskAfterTurnGeneralService taskAfterTurnGeneralServiceImpl;
    @Autowired
    AutoTurnAllTaskService autoTurnAllTaskService;

    public List<PfUserVo> getTaskPerformers(String wiid, String targetActivityDefinitionId, PfTaskVo sourceTask, List<PfUserVo> sourceUsers, String wdid) {
        PfUserVo pfUserVo;
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo;
        String onlyYhsq = AppConfig.getProperty((String)"yhsq.only.autoTurnTask.enble");
        if (StringUtils.equals((String)onlyYhsq, (String)"true") && StringUtils.isNotBlank((String)wiid)) {
            List bdcXmList = this.bdcXmService.getBdcXmList(wiid);
            boolean isyhsq = false;
            if (CollectionUtils.isNotEmpty((Collection)bdcXmList)) {
                for (BdcXm bdcXm : bdcXmList) {
                    if (bdcXm == null || !StringUtils.isNotBlank((String)bdcXm.getYhsqywh())) continue;
                    isyhsq = true;
                    break;
                }
            } else {
                isyhsq = true;
            }
            if (!isyhsq) {
                return null;
            }
        }
        boolean ignore = false;
        String sqlxs = AppConfig.getProperty((String)"autoTurnAllTask.sqlx.ignore");
        if (StringUtils.isNotBlank((String)sqlxs)) {
            List bdcXmList;
            String[] sqlx = sqlxs.split(",");
            if (StringUtils.isNotBlank((String)wiid) && CollectionUtils.isNotEmpty((Collection)(bdcXmList = this.bdcXmService.getBdcXmList(wiid))) && sqlx.length > 0) {
                for (int i = 0; i < bdcXmList.size(); ++i) {
                    for (int j = 0; j < sqlx.length; ++j) {
                        if (!((BdcXm)bdcXmList.get(i)).getSqlx().equals(sqlx[j])) continue;
                        ignore = true;
                    }
                }
            }
        }
        if ((pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(wiid)) != null && StringUtils.isBlank((String)wiid)) {
            wdid = pfWorkFlowInstanceVo.getWorkflowDefinitionId();
        }
        String userid = null;
        if ("true".equals(AppConfig.getProperty((String)"autoTurnAllTask.enble")) && !ignore) {
            userid = this.autoTurnAllTaskService.getBdczdpjAllYhid(sourceUsers);
        } else if ("true".equals(AppConfig.getProperty((String)"autoTurnTask.enble"))) {
            String autoTurnControlRegionCode = AppConfig.getProperty((String)"autoTurnTask.control.regionCode");
            if (StringUtils.isNotBlank((String)autoTurnControlRegionCode)) {
                ArrayList<PfUserVo> realSourceUsers = new ArrayList<PfUserVo>();
                for (PfUserVo sourceUser : sourceUsers) {
                    if (sourceUser == null || !StringUtils.isNotBlank((String)sourceUser.getUserId()) || !StringUtils.equals((String)autoTurnControlRegionCode, (String)this.sysUserService.getRegionCodeByUserId(sourceUser.getUserId()))) continue;
                    realSourceUsers.add(sourceUser);
                }
                sourceUsers = realSourceUsers;
            }
            userid = this.autoTurnTaskService.getZdpjYhid(wdid, targetActivityDefinitionId, sourceUsers);
        }
        if (StringUtils.isNotBlank((String)userid) && (pfUserVo = this.sysUserService.getUserVo(userid)) != null) {
            return Lists.newArrayList((Object[])new PfUserVo[]{pfUserVo});
        }
        return null;
    }

    public WorkFlowInfo createWorkFlowInstance(PfWorkFlowInstanceVo intanceVo, String userId) {
        WorkFlowInfo workFlowInfo = null;
        PfWorkFlowDefineVo pfWorkFlowDefineVo = null;
        if (intanceVo == null || StringUtils.isBlank((String)intanceVo.getWorkflowDefinitionId())) {
            return null;
        }
        pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(intanceVo.getWorkflowDefinitionId());
        WorkFlowXml workXml = WorkFlowXmlUtil.getDefineModel((PfWorkFlowDefineVo)pfWorkFlowDefineVo);
        List activityModelList = workXml.getActivityList();
        ActivityModel activityModel = null;
        if (CollectionUtils.isNotEmpty((Collection)activityModelList)) {
            activityModel = (ActivityModel)activityModelList.get(0);
        }
        String autoTurnTaskEnable = AppConfig.getProperty((String)"autoTurnTask.enble");
        String autoTurnAllTaskEnable = AppConfig.getProperty((String)"autoTurnAllTask.enble");
        if (activityModel != null && (StringUtils.equals((String)autoTurnTaskEnable, (String)"true") || StringUtils.equals((String)autoTurnAllTaskEnable, (String)"true"))) {
            List performerUsers = null;
            ArrayList pfUserVoList = Lists.newArrayList();
            for (PerformerModel performerModel : activityModel.getPerformerList()) {
                List pfUserVoList1;
                if (StringUtils.isNotBlank((String)performerModel.getUserId())) {
                    PfUserVo pfUserVo = new PfUserVo();
                    pfUserVo.setUserId(performerModel.getUserId());
                    pfUserVo.setUserName(this.sysUserService.getUserVo(performerModel.getUserId()).getUserName());
                    pfUserVoList.add(pfUserVo);
                }
                if (StringUtils.isNotBlank((String)performerModel.getRoleId()) && CollectionUtils.isNotEmpty((Collection)(pfUserVoList1 = this.sysUserService.getUserListByRole(performerModel.getRoleId())))) {
                    pfUserVoList.addAll(pfUserVoList1);
                }
                if (!StringUtils.isNotBlank((String)performerModel.getOrganId()) || !CollectionUtils.isNotEmpty((Collection)(pfUserVoList1 = this.sysUserService.getUserListByOragn(performerModel.getOrganId())))) continue;
                pfUserVoList.addAll(pfUserVoList1);
            }
            performerUsers = this.taskPerformerFilterService.getTaskPerformers(intanceVo.getWorkflowIntanceId(), activityModel.getDefineId(), null, (List)pfUserVoList, intanceVo.getWorkflowDefinitionId());
            if (CollectionUtils.isNotEmpty((Collection)performerUsers)) {
                try {
                    workFlowInfo = this.workFlowService.createWorkFlowInstance(intanceVo, ((PfUserVo)performerUsers.get(0)).getUserId());
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            } else {
                try {
                    workFlowInfo = this.workFlowService.createWorkFlowInstance(intanceVo, userId);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
            if (workFlowInfo != null) {
                this.taskAfterTurnGeneralServiceImpl.doWork(workFlowInfo);
            }
        }
        return workFlowInfo;
    }

    public WorkFlowInfo createWorkFlowInstanceAndZdpjAll(PfWorkFlowInstanceVo intanceVo, String userId) throws Exception {
        WorkFlowInfo workFlowInfo = null;
        PfWorkFlowDefineVo pfWorkFlowDefineVo = null;
        if (intanceVo == null || StringUtils.isBlank((String)intanceVo.getWorkflowDefinitionId())) {
            return null;
        }
        pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(intanceVo.getWorkflowDefinitionId());
        WorkFlowXml workXml = WorkFlowXmlUtil.getDefineModel((PfWorkFlowDefineVo)pfWorkFlowDefineVo);
        List activityModelList = workXml.getActivityList();
        ActivityModel activityModel = null;
        if (CollectionUtils.isNotEmpty((Collection)activityModelList)) {
            activityModel = (ActivityModel)activityModelList.get(0);
        }
        String autoTurnAllTaskEnable = AppConfig.getProperty((String)"autoTurnAllTask.enble");
        if (activityModel != null && StringUtils.equals((String)autoTurnAllTaskEnable, (String)"true")) {
            List performerUsers = null;
            ArrayList pfUserVoList = Lists.newArrayList();
            for (PerformerModel performerModel : activityModel.getPerformerList()) {
                List pfUserVoList1;
                if (StringUtils.isNotBlank((String)performerModel.getUserId())) {
                    PfUserVo pfUserVo = new PfUserVo();
                    pfUserVo.setUserId(performerModel.getUserId());
                    pfUserVo.setUserName(this.sysUserService.getUserVo(performerModel.getUserId()).getUserName());
                    pfUserVoList.add(pfUserVo);
                }
                if (StringUtils.isNotBlank((String)performerModel.getRoleId()) && CollectionUtils.isNotEmpty((Collection)(pfUserVoList1 = this.sysUserService.getUserListByRole(performerModel.getRoleId())))) {
                    pfUserVoList.addAll(pfUserVoList1);
                }
                if (!StringUtils.isNotBlank((String)performerModel.getOrganId()) || !CollectionUtils.isNotEmpty((Collection)(pfUserVoList1 = this.sysUserService.getUserListByOragn(performerModel.getOrganId())))) continue;
                pfUserVoList.addAll(pfUserVoList1);
            }
            performerUsers = this.getTaskPerformersForZdpjAll(intanceVo.getWorkflowIntanceId(), activityModel.getDefineId(), null, (List)pfUserVoList, intanceVo.getWorkflowDefinitionId());
            workFlowInfo = CollectionUtils.isNotEmpty((Collection)performerUsers) ? this.workFlowService.createWorkFlowInstance(intanceVo, ((PfUserVo)performerUsers.get(0)).getUserId()) : this.workFlowService.createWorkFlowInstance(intanceVo, userId);
            if (workFlowInfo != null) {
                this.taskAfterTurnGeneralServiceImpl.doWork(workFlowInfo);
            }
        }
        return workFlowInfo;
    }

    public List<PfUserVo> getTaskPerformersForZdpjAll(String wiid, String targetActivityDefinitionId, PfTaskVo sourceTask, List<PfUserVo> sourceUsers, String wdid) {
        PfUserVo pfUserVo;
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(wiid);
        if (pfWorkFlowInstanceVo != null && StringUtils.isBlank((String)wiid)) {
            wdid = pfWorkFlowInstanceVo.getWorkflowDefinitionId();
        }
        String userid = null;
        if ("true".equals(AppConfig.getProperty((String)"autoTurnAllTask.enble"))) {
            userid = this.autoTurnAllTaskService.getBdczdpjAllYhid(sourceUsers);
        }
        if (StringUtils.isNotBlank(userid) && (pfUserVo = this.sysUserService.getUserVo(userid)) != null) {
            return Lists.newArrayList((Object[])new PfUserVo[]{pfUserVo});
        }
        return null;
    }
}

