/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.portal.entity.PfRole;
import com.gtis.portal.entity.PfUserRoleRel;
import com.gtis.portal.entity.QPfUserRoleRel;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfRoleService;
import com.gtis.portal.service.PfUserRoleService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.util.RequestUtils;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfUserRoleServiceImpl
extends BaseServiceImpl<PfUserRoleRel, String>
implements PfUserRoleService {
    @Autowired
    PfRoleService roleService;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteUserRoleByRoleId(String id) {
        QPfUserRoleRel qPfUserRole = QPfUserRoleRel.pfUserRoleRel;
        new JPADeleteClause(this.em, (EntityPath)qPfUserRole).where(new Predicate[]{qPfUserRole.roleId.eq((Object)id)}).execute();
    }

    public List<PfUserRoleRel> findUserROleListById(String roleId) {
        QPfUserRoleRel qPfUserRole = QPfUserRoleRel.pfUserRoleRel;
        JPAQuery query = new JPAQuery(this.em);
        List pfUserRoleList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfUserRole})).where(new Predicate[]{qPfUserRole.roleId.eq((Object)roleId)})).list((Expression)qPfUserRole);
        return pfUserRoleList;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteUserRoleByUseridAndRoleId(String roleId, String userId) {
        QPfUserRoleRel qPfUserRole = QPfUserRoleRel.pfUserRoleRel;
        new JPADeleteClause(this.em, (EntityPath)qPfUserRole).where(new Predicate[]{qPfUserRole.userId.eq((Object)userId)}).where(new Predicate[]{qPfUserRole.roleId.eq((Object)roleId)}).execute();
    }

    public boolean findUserRole(PfUserRoleRel userRole) {
        JPAQuery query = new JPAQuery(this.em);
        QPfUserRoleRel qPfUserRole = QPfUserRoleRel.pfUserRoleRel;
        List pfUserRoleList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfUserRole})).where(new Predicate[]{qPfUserRole.roleId.eq((Object)userRole.getRoleId())})).where(new Predicate[]{qPfUserRole.userId.eq((Object)userRole.getUserId())})).list((Expression)qPfUserRole);
        return pfUserRoleList != null && pfUserRoleList.size() >= 1;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteUserRoleByUserid(String user_id) {
        QPfUserRoleRel qPfUserRole = QPfUserRoleRel.pfUserRoleRel;
        new JPADeleteClause(this.em, (EntityPath)qPfUserRole).where(new Predicate[]{qPfUserRole.userId.eq((Object)user_id)}).execute();
    }

    public List<Ztree> findRolebyUserId(String userId) {
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        List roleList = this.getRoleListByUserId(userId);
        if (roleList != null && roleList.size() > 0 && roleList != null && roleList.size() > 0) {
            for (int i = 0; i < roleList.size(); ++i) {
                Ztree tree = this.toZtreeByRole((PfRole)roleList.get(i));
                treeList.add(tree);
            }
        }
        return treeList;
    }

    private Ztree toZtreeByRole(PfRole role) {
        Ztree tree = new Ztree();
        tree.setId(role.getRoleId());
        tree.setName(role.getRoleName());
        tree.setPid("treeroot");
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/sup.png")));
        return tree;
    }

    public List<PfRole> getRoleListByUserId(String userId) {
        if (StringUtils.isNotBlank((String)userId)) {
            String jpql = "select distinct t1 from PfRole t1,PfUserRoleRel t  where t.roleId=t1.roleId and t.userId=?0 ";
            jpql = jpql + " order by t1.roleNo ";
            return this.baseDao.getByJpql(jpql, new Object[]{userId});
        }
        return null;
    }

    public boolean checkHasRole(String userId, String roleId) {
        String jpql;
        PfUserRoleRel obj;
        return StringUtils.isNotBlank((String)userId) && StringUtils.isNotBlank((String)roleId) && (obj = (PfUserRoleRel)this.baseDao.getUniqueResultByJpql(jpql = "select t from PfUserRoleRel t where t.userId=?0 and  t.roleId=?1 and rownum=1", new Object[]{userId, roleId})) != null && StringUtils.isNotBlank((String)obj.getUrrId());
    }

    @Transactional
    public void addRoleRel(String userId, List<ZtreeChanged> changeList) {
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)userId)) {
            for (int i = 0; i < changeList.size(); ++i) {
                boolean hasRole;
                ZtreeChanged change = changeList.get(i);
                if (!change.isLeaf() || (hasRole = this.checkHasRole(userId, change.getId()))) continue;
                PfUserRoleRel rel = new PfUserRoleRel();
                rel.setUrrId(UUIDGenerator.generate18());
                rel.setRoleId(change.getId());
                rel.setUserId(userId);
                this.insert((Object)rel);
            }
        }
    }

    @Transactional
    public void addRoleUserRel(String roleId, List<ZtreeChanged> changeList) {
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)roleId)) {
            for (int i = 0; i < changeList.size(); ++i) {
                ZtreeChanged change = changeList.get(i);
                if (!change.isLeaf()) continue;
                boolean hasRole = this.checkHasRole(change.getId(), roleId);
                if (change.isChecked()) {
                    if (hasRole) continue;
                    PfUserRoleRel rel = new PfUserRoleRel();
                    rel.setUrrId(UUIDGenerator.generate18());
                    rel.setRoleId(roleId);
                    rel.setUserId(change.getId());
                    this.insert((Object)rel);
                    continue;
                }
                this.deleteUserRoleByUseridAndRoleId(roleId, change.getId());
            }
        }
    }

    public LinkedHashMap<String, PfRole> getRoleMapByUserid(String userId) {
        List roleList = this.getRoleListByUserId(userId);
        return this.roleService.roleList2RoleMap(roleList);
    }
}

