/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.portal.entity.PfDistrict;
import com.gtis.portal.entity.QPfDistrict;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfDistrictService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfDistrictServiceImpl
extends BaseServiceImpl<PfDistrict, String>
implements PfDistrictService {
    public List<PfDistrict> getDistrictList(String regionCode) {
        List districtList = new ArrayList();
        QPfDistrict qPfDistrict = QPfDistrict.pfDistrict;
        JPAQuery query = new JPAQuery(this.em);
        if (StringUtils.isNotBlank((String)regionCode)) {
            String xzqdm = regionCode;
            if (StringUtils.length((String)regionCode) == 6) {
                xzqdm = StringUtils.removeEnd((String)regionCode, (String)"0000");
                xzqdm = StringUtils.removeEnd((String)regionCode, (String)"00");
            }
            districtList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfDistrict})).where(new Predicate[]{qPfDistrict.districtCode.like(xzqdm + "%")})).orderBy(new OrderSpecifier[]{qPfDistrict.districtCode.asc()})).list((Expression)qPfDistrict);
        } else {
            districtList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfDistrict})).orderBy(new OrderSpecifier[]{qPfDistrict.districtCode.asc()})).list((Expression)qPfDistrict);
        }
        return districtList;
    }

    public LinkedHashMap<String, Ztree> getDistrictMap(String regionCode) {
        List districtList = this.getDistrictList(regionCode);
        LinkedHashMap<String, Ztree> districtMap = new LinkedHashMap<String, Ztree>();
        for (PfDistrict districtVo : districtList) {
            Ztree tree = this.toZtree(districtVo);
            districtMap.put(tree.getId(), tree);
        }
        return districtMap;
    }

    public Ztree getAllDistrictTree(String regionCode) {
        LinkedHashMap districtMap = this.getDistrictMap(regionCode);
        Ztree root = null;
        for (Ztree tree : districtMap.values()) {
            if (tree.getPid() != null) {
                Ztree ztree = (Ztree)districtMap.get(tree.getPid());
                if (ztree == null) continue;
                ztree.addChild(tree);
                continue;
            }
            tree.setOpen(true);
            root = tree;
        }
        return root;
    }

    public Ztree toZtree(PfDistrict districtVo) {
        Ztree tree = new Ztree();
        tree.setId(districtVo.getDistrictId());
        tree.setName(districtVo.getDistrictName());
        tree.setPid(StringUtils.trimToNull((String)districtVo.getDistrictParentId()));
        tree.setKz1(districtVo.getDistrictCode());
        return tree;
    }

    public List<PfDistrict> getAllDistrictList(String regionCode) {
        return this.getAllDistrictList(regionCode, false);
    }

    public List<PfDistrict> getAllDistrictList(String regionCode, boolean removeZero) {
        List districtList = this.getDistrictList(regionCode);
        if (districtList != null && districtList.size() > 0) {
            PfDistrict districtVo;
            int i;
            LinkedHashMap<String, PfDistrict> districtMap = new LinkedHashMap<String, PfDistrict>();
            for (PfDistrict districtVo2 : districtList) {
                districtMap.put(districtVo2.getDistrictId(), districtVo2);
            }
            PfDistrict firstDistrict = (PfDistrict)districtList.get(0);
            firstDistrict.setBlankStr("");
            PfDistrict parentDistrict = firstDistrict;
            for (i = 1; i < districtList.size(); ++i) {
                districtVo = (PfDistrict)districtList.get(i);
                if (districtVo.getDistrictParentId().equals(firstDistrict.getDistrictCode())) {
                    districtVo.setBlankStr("\u3000\u3000|--" + firstDistrict.getBlankStr());
                    parentDistrict = districtVo;
                } else {
                    if (!districtVo.getDistrictParentId().equals(parentDistrict.getDistrictCode())) {
                        parentDistrict = (PfDistrict)((HashMap)districtMap).get(districtVo.getDistrictParentId());
                    }
                    districtVo.setBlankStr("\u3000\u3000" + parentDistrict.getBlankStr());
                }
                districtVo.setDistrictName(districtVo.getBlankStr() + districtVo.getDistrictName());
                districtList.set(i, districtVo);
            }
            if (removeZero) {
                for (i = 0; i < districtList.size(); ++i) {
                    districtVo = (PfDistrict)districtList.get(i);
                    if (StringUtils.length((String)districtVo.getDistrictCode()) != 6) continue;
                    districtVo.setDistrictCode(StringUtils.removeEnd((String)districtVo.getDistrictCode(), (String)"0000"));
                    districtVo.setDistrictCode(StringUtils.removeEnd((String)districtVo.getDistrictCode(), (String)"00"));
                }
            }
        }
        return districtList;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteDistrict(PfDistrict district) {
        JPAQuery query = new JPAQuery(this.em);
        QPfDistrict qPfDistrict = QPfDistrict.pfDistrict;
        List districtList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfDistrict})).where(new Predicate[]{qPfDistrict.districtParentId.eq((Object)district.getDistrictId())})).list((Expression)qPfDistrict);
        if (districtList == null || districtList.size() == 0) {
            new JPADeleteClause(this.em, (EntityPath)qPfDistrict).where(new Predicate[]{qPfDistrict.districtId.eq((Object)district.getDistrictId())}).execute();
        } else {
            for (PfDistrict districtVo : districtList) {
                this.deleteDistrict(districtVo);
            }
        }
    }
}

