/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.TaskBeforeTurnValidationService;
import com.gtis.web.SessionUtil;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NextTimeTaskUnhandledValidationServiceImpl
implements TaskBeforeTurnValidationService {
    @Autowired
    private SysTaskService sysTaskService;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    private String excludeActivityNames;

    public String getExcludeActivityNames() {
        return this.excludeActivityNames;
    }

    public void setExcludeActivityNames(String excludeActivityNames) {
        this.excludeActivityNames = excludeActivityNames;
    }

    public boolean validateTask(String taskId, String userId) throws PortalException {
        PfTaskVo pfTaskVo = this.sysTaskService.getTask(taskId);
        String wdid = "";
        PfActivityVo pfActivityVo = null;
        Date createDate = null;
        if (pfTaskVo != null && StringUtils.isNotBlank((CharSequence)pfTaskVo.getActivityId()) && (pfActivityVo = this.sysTaskService.getActivity(pfTaskVo.getActivityId())) != null && StringUtils.isNotBlank((CharSequence)pfActivityVo.getWorkflowInstanceId())) {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
            if (pfWorkFlowInstanceVo != null && StringUtils.isNotBlank((CharSequence)pfWorkFlowInstanceVo.getWorkflowDefinitionId())) {
                wdid = pfWorkFlowInstanceVo.getWorkflowDefinitionId();
            }
            if (pfWorkFlowInstanceVo != null) {
                createDate = pfWorkFlowInstanceVo.getCreateTime();
            }
            if (StringUtils.equals((CharSequence)pfWorkFlowInstanceVo.getPriority(), (CharSequence)"2") || StringUtils.equals((CharSequence)pfWorkFlowInstanceVo.getPriority(), (CharSequence)"3")) {
                return true;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)wdid)) {
            HashMap param = Maps.newHashMap();
            if (StringUtils.isBlank((CharSequence)userId)) {
                userId = SessionUtil.getCurrentUserId();
            }
            param.put("userId", userId);
            param.put("WORKFLOW_DEFINITION_ID", wdid);
            param.put("LESS_CREATE_TIME", createDate);
            param.put("PRIORITY", "1");
            param.put("STATE", "1");
            int taskCount = Integer.parseInt(this.sysWorkFlowInstanceService.getTaskCount(param));
            int turnEnabledCount = 1;
            if (StringUtils.isNotBlank((CharSequence)AppConfig.getProperty((String)"trun.enabled.count"))) {
                turnEnabledCount = Integer.parseInt(AppConfig.getProperty((String)"trun.enabled.count"));
            }
            if (taskCount >= turnEnabledCount && taskCount > 0 && (StringUtils.isBlank((CharSequence)this.excludeActivityNames) || pfActivityVo != null && StringUtils.indexOf((CharSequence)this.excludeActivityNames, (CharSequence)pfActivityVo.getActivityName()) < 0)) {
                throw new PortalException(ExceptionCode.NEXT_TIME_TASK_UNHANDLED);
            }
        }
        return true;
    }
}

