var _menuJsonObj;
var mainMenuIndex;
var secondMenuIndex;


<!--   自适应高度    -->
function resizeWidthFix() {
    var winWidth = $(window).width();
    $(".middles").css({width: winWidth - $("#conntentFloatTag").offset().left - 1 + "px"});
    //判断是否存在二级和三级目录
    if ($('.secondMenu').css('display') == 'none') {
        $(".otherContent").css('min-width', 1250);
    } else if ($('.thirdMenu').css('display') == 'none') {
        $(".otherContent").css('min-width', 1100);
    } else {
        $(".otherContent").css('min-width', 940);
    }
}


$(window).resize(function () {
    loadLeftMenu();
    resizeWidthFix();
});

function loadLeftMenu() {
    var leftMenuHieght;
    var winHeight = $(window).height();
    if (winHeight > 0) {
        leftMenuHieght = winHeight - 123;
    }
    $(".secondMenu").css({height: leftMenuHieght + "px"});
    $(".thirdMenu").css({height: leftMenuHieght + "px"});
    $(".searchMenu").css({height: leftMenuHieght + "px"});
    $("#secondMenuTree").css({
        height: leftMenuHieght + "px",
        'overflow-y': "auto",
        'overflow-x': "hidden",
        'margin-bottom': "0px"
    });
    if (showLeftMenuMethod == "expand")
        $("#thirdMenuTree").css({
            height: leftMenuHieght + "px",
            'overflow-y': "auto",
            'overflow-x': "hidden",
            'margin-bottom': "0px"
        });
    resizeMainFrame();
}

function resizeMainFrame() {
    var leftMenuHieght;
    var winHeight = $(window).height();
    if (winHeight > 0) {
        leftMenuHieght = winHeight - 123;
    }
    if ($('.secondMenu').css('display') == 'none' && $('.breadcrumbDiv').css('display') == 'none') {
        $("#mainFrame").css({height: (leftMenuHieght + 20) + "px"});
    } else {
        $("#mainFrame").css({height: (leftMenuHieght - 20) + "px"});
    }
    $("#secondMenuTree").css({
        height: leftMenuHieght + "px",
        'overflow-y': "auto",
        'overflow-x': "hidden",
        'margin-bottom': "0px"
    });
    if (showLeftMenuMethod == "expand")
        $("#thirdMenuTree").css({
            height: leftMenuHieght + "px",
            'overflow-y': "auto",
            'overflow-x': "hidden",
            'margin-bottom': "0px"
        });
}


$(document).ready(function () {

    showPublicConfirm();

    loadLeftMenu();

    $("#thirdMenu").click(function () {
        resizeWidthFix();
    });


    $("#thirdMenuHideBtn").click(function () {
        $(".thirdMenu").hide();
        resizeWidthFix();
    });
    resizeWidthFix();

    buildMenu();
//消息提醒
    loadMsgReminder();
    //加载部署地区的待办任务数量
    loadAllDeployRegionCount();
    //调用评价系统显示用户信息
    sendEvaluateShowUserUrl();
});

//判断为消息发布后的第一次登录，并且刷新等操作不提示
function showPublicConfirm() {

    var confirmUrl=portalUrl + "/news/getPublicNewsConfirm";

    $.ajax({
        url: confirmUrl,
        type: 'POST',
        async:false,
        dataType:"json",
        success:function (data) {
            if(data){
                showPublic();
            }
        }
    });

}
//判断最新的公告信息如果处于启用状态，那么弹出公告页面
function showPublic() {
    var defaultUrl = portalUrl + "/news/getRecentNews";//获取发布的更新
    $.ajax({
        url: defaultUrl,
        type: 'POST',
        dataType: 'json',
        success: function (data) {
            if (data != null) {
                $('#publicModal').modal({show: true});
                //给公告页面赋值
                $("#newPublisher").html(data.newpublisher);
                $("#newContent").html(data.newcontent);
                $("#newDate").html(changeDateFormat(data.newdate));
            }
        },
        error: function (data) {
        }
    });
}

//转换日期格式(时间戳转换为datetime格式)
function changeDateFormat(obj) {
    var dateVal = obj + "";
    if (obj != null) {
        var date = new Date(parseInt(dateVal.replace("/Date(", "").replace(")/", ""), 10));
        var month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
        var currentDate = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();

        var hours = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
        var minutes = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
        var seconds = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();

        return date.getFullYear() + "年" + month + "月" + currentDate + "日" + hours + "时" + minutes + "分" + seconds + "秒";
    }
}

/**
 * 根据平台的主菜单资源配置初始化portal页面的一、二、三级菜单
 */
function buildMenu() {
    $.get("getmenu?systemId=" + subsystemId, function (result) {
        _menuJsonObj = result;
        var rootMenuChildren = _menuJsonObj.children;
        if (rootMenuChildren != undefined && rootMenuChildren.length > 0) {
            var tag = true;
            for (var i = 0; i < rootMenuChildren.length; i++) {
                var rootMenu = $('<li/>');
                if (i < 4) {
                    $('<a href="#" main-menu-index="' + i + '"' + '>' + rootMenuChildren[i].text + '</a>').appendTo(rootMenu);
                    $('#navMenu li:last-child').before(rootMenu);
                } else {
                    $('<a href="#" main-menu-index="' + i + '"' + '>' + rootMenuChildren[i].text + '</a>').appendTo(rootMenu);
                    $('#navMenu ul').append(rootMenu);
                }

            }
            if (rootMenuChildren.length <= 4) {
                $('#navMenu li[class=lastMenu]').remove();
            }

        } else {
            window.document.location = "/portal/index";
        }

        $('#navMenu a[main-menu-index]').click(function () {
            $(".sidebar").hide();
            $('#navMenu').find('li[class="active"]').each(function () {
                $(this).removeClass('active');
            });
            $(this).parent().addClass('active');
            mainMenuIndex = $(this).attr('main-menu-index');
            updateBreadcrumb(_menuJsonObj.children[mainMenuIndex].text, null, null);
            var secondMenuChildren = _menuJsonObj.children[mainMenuIndex].children;
            $('#leftMenuTitle').empty();
            var mainMenuTitle = _menuJsonObj.children[mainMenuIndex].text;
            $('#leftMenuTitle').attr('title', mainMenuTitle);
            if (mainMenuTitle != null && mainMenuTitle.length > 4) {
                mainMenuTitle = mainMenuTitle.substr(0, 4);
            }
            //默认二、三级菜单都展开
            if ($("#leftMenuTitle").hasClass('menu2Tab_toggle')) {
                $("#leftMenuTitle").toggleClass('menu2Tab_toggle');
                $("#leftMenuTitle").toggleClass('menu2Tab');
            }

            $('#leftMenuTitle').append('<span class="arrow" id="arrow"><i class="icon_arrow"></i></span><img src="' + portalUrl + '/static/img/Nav_2.png"/>' + mainMenuTitle);
            $("#arrow").click(function () {

                var sidebarVisible = false;
                $("#leftMenuTitle").toggleClass('menu2Tab_toggle');
                $("#leftMenuTitle").toggleClass('menu2Tab');
                if ($("#leftMenuTitle").hasClass('menu2Tab_toggle')) {
                    $(".sidebar").show();
                    sidebarVisible = true;
                } else if ($("#leftMenuTitle").hasClass('menu2Tab')) {
                    $(".sidebar").hide();
                    sidebarVisible = false;
                }
                if ($('#secondMenuTree:has(li)').length > 0)
                    $(".secondMenu").toggle();
                if ($('#thirdMenuTree:has(li)').length > 0) {
                    if (sidebarVisible) {
                        $(".thirdMenu").hide();
                    } else {
                        $(".thirdMenu").show();
                    }
                }

                resizeWidthFix();
            });


            $('#secondMenuTree').empty();
            if (secondMenuChildren.length > 0) {
                if (showLeftMenuMethod == "blinds")
                //百叶窗
                    thirdMenuTreeByBlinds(secondMenuChildren);
                else
                //伸缩
                    thirdMenuTreeByExpand(secondMenuChildren);
            } else {
                $('.menu2Tab').hide();
                $('.breadcrumbDiv').hide();
                $('.secondMenu').hide();
                $(".thirdMenu").hide();
                resizeWidthFix();
                openMenuResource(_menuJsonObj.children[mainMenuIndex].link, _menuJsonObj.children[mainMenuIndex].model)
            }
            resizeMainFrame();
        });

        $('#navMenu li a:first').trigger('click');

    });
}

// 伸缩显示第三菜单
function thirdMenuTreeByExpand(secondMenuChildren) {
    $('.menu2Tab').show();
    $('.breadcrumbDiv').show();
    $('.secondMenu').show();

    for (var i = 0; i < secondMenuChildren.length; i++) {
        var secondMenu = $('<li/>');
        $('<a href="#" second-menu-index="' + i + '"' + '>' + secondMenuChildren[i].text + '</a>').appendTo(secondMenu);
        $('#secondMenuTree').append(secondMenu);
    }
    $('#secondMenuTree li a[second-menu-index]').click(function () {
        updateBreadcrumb(_menuJsonObj.children[mainMenuIndex].text, $(this).text(), null);
        $(this).parent().parent().find('[class="active"]').each(function () {
            $(this).removeClass('active');
        });
        $(this).parent().addClass('active');
        secondMenuIndex = $(this).attr('second-menu-index');
        var secondMenuObj = _menuJsonObj.children[mainMenuIndex].children[secondMenuIndex];
        var thirdMenuChildren = secondMenuObj.children;

        $('#thirdMenuTree').empty();
        if (thirdMenuChildren.length > 0) {
            $(".thirdMenu").show();
            resizeWidthFix();
            for (var i = 0; i < thirdMenuChildren.length; i++) {
                var thirdMenu = $('<li/>');
                if (i == 0) {
                    $(thirdMenu).attr('class', 'active');
                }
                $('<a href="#" third-menu-index="' + i + '" third-menu-link="' + thirdMenuChildren[i].link + '" third-menu-model="' + thirdMenuChildren[i].model + '">' +
                    thirdMenuChildren[i].text + '</a>').appendTo(thirdMenu);
                $('#thirdMenuTree').append(thirdMenu);
            }
            $('#thirdMenuTree li a[third-menu-index]').click(function () {
                updateBreadcrumb(_menuJsonObj.children[mainMenuIndex].text, _menuJsonObj.children[mainMenuIndex].children[secondMenuIndex].text, $(this).text());
                $(this).parent().parent().find('[class="active"]').each(function () {
                    $(this).removeClass('active');
                });
                $(this).parent().addClass('active');
                openMenuResource($(this).attr('third-menu-link'), $(this).attr('third-menu-model'));
            });
            $('#thirdMenuTree>li>a:first').trigger('click');
        } else {
            $(".thirdMenu").hide();
            resizeWidthFix();
            openMenuResource(secondMenuObj.link, secondMenuObj.model);
        }
    });


    //默认二级菜单的第一个菜单显示
    $('#secondMenuTree>li>a:first').trigger('click');

    //根据配置信息确定是否默认展开左侧菜单
    if (!leftMenuVisible)
        $("#arrow").trigger('click');
}

// 百叶窗显示第三菜单
function thirdMenuTreeByBlinds(secondMenuChildren) {
    $('.menu2Tab').show();
    $('.breadcrumbDiv').show();
    $('.secondMenu').show();

    for (var i = 0; i < secondMenuChildren.length; i++) {
        var secondMenu = $('<li/>');
        var secondMenuObj = _menuJsonObj.children[mainMenuIndex].children[i];
        var thirdMenuChildren = secondMenuObj.children;
        if (thirdMenuChildren.length == 0)
            $('<a href="#" second-menu-index="' + i + '"' + '>' + secondMenuChildren[i].text + '</a>').appendTo(secondMenu);
        else {
            secondMenu.addClass('Blind');
            $('<a second-menu-index="' + i + '"' + '>' + secondMenuChildren[i].text + '<i class="icon_leftmenu01"></i></a>').appendTo(secondMenu);
        }

        $('#secondMenuTree').append(secondMenu);
    }
    $('#secondMenuTree li a[second-menu-index]').click(function () {
        updateBreadcrumb(_menuJsonObj.children[mainMenuIndex].text, $(this).text(), null);
        $('#secondMenuTree li div').remove();
        $(this).parent().parent().children().each(function () {
            $(this).removeClass('active');
            $(this).children().removeClass('flip-current');
        });
        $(this).parent().parent().find('[class="active"]').each(function () {
            $(this).removeClass('active');
        });
        $(this).parent().addClass('active');
        $(this).addClass('flip-current');
        secondMenuIndex = $(this).attr('second-menu-index');
        var secondMenuObj = _menuJsonObj.children[mainMenuIndex].children[secondMenuIndex];
        var thirdMenuChildren = secondMenuObj.children;

        if (thirdMenuChildren.length > 0) {
            var thirdDiv = '<div class="panel" id="thirdMenuTreeDiv"><ul  id="thirdMenuTree"/></div>';
            $(this).parent().append(thirdDiv);
            $("#thirdMenuTreeDiv").attr('class', 'panel-current');
            resizeWidthFix();
            for (var i = 0; i < thirdMenuChildren.length; i++) {
                var thirdMenu = $('<li/>');
                if (i == 0) {
                    $(thirdMenu).attr('class', 'active');
                }
                $('<a href="#" third-menu-index="' + i + '" third-menu-link="' + thirdMenuChildren[i].link + '" third-menu-model="' + thirdMenuChildren[i].model + '">' +
                    thirdMenuChildren[i].text + '</a>').appendTo(thirdMenu);
                $("#thirdMenuTree").append(thirdMenu);
            }
            $('#thirdMenuTree li a[third-menu-index]').click(function () {
                updateBreadcrumb(_menuJsonObj.children[mainMenuIndex].text, _menuJsonObj.children[mainMenuIndex].children[secondMenuIndex].text, $(this).text());
                $(this).parent().parent().find('[class="active"]').each(function () {
                    $(this).removeClass('active');
                });
                $(this).parent().addClass('active');
                openMenuResource($(this).attr('third-menu-link'), $(this).attr('third-menu-model'));
            });
            $('#thirdMenuTree>li>a:first').trigger('click');
        } else {
            resizeWidthFix();
            openMenuResource(secondMenuObj.link, secondMenuObj.model);
        }
    });


    //默认二级菜单的第一个菜单显示
    $('#secondMenuTree>li>a:first').trigger('click');

    //根据配置信息确定是否默认展开左侧菜单
    if (!leftMenuVisible)
        $("#arrow").trigger('click');
}

function openMenuResource(linkstr, model) {
    if (linkstr != null) {
        $.get("menu/open?link=" + linkstr, function (result) {
            var resourceUrl = buildLinkUrl(result.resourceUrl);
            if (resourceUrl == null) {
                window.document.location = "/portal/index";
            } else if (resourceUrl.indexOf("MapGtis") == -1) {
                if (resourceUrl.indexOf('?') > -1) {
                    resourceUrl += '&rid=' + linkstr;
                } else {
                    resourceUrl += '?rid=' + linkstr;
                }
            }
            resourceUrl += '&userid=' + userid;
            if (!model || model == 0)
                $('#mainFrame').attr("src", resourceUrl);
            else if (model == 2)
                window.document.location = resourceUrl;
            else if (model == 3)
                $('#mainFrame').load(resourceUrl);

        });
    }
}

function buildLinkUrl(resourceUrl) {
    if (resourceUrl != null && resourceUrl.substr(0, 1) != "/" && resourceUrl.substr(0, 1) != "h" && resourceUrl.substr(0, 7) != "MapGtis") {
        return platform_url + '/' + resourceUrl;
    } else {
        return resourceUrl;
    }
}

/**
 * 更新面包屑
 * @param mainMenu
 * @param secondMenu
 * @param thirdMenu
 */
function updateBreadcrumb(mainMenu, secondMenu, thirdMenu) {
    $('#breadcrumb').empty();
    $('#breadcrumb').append('<li><i class="icon-home"></i>&nbsp;<span>当前位置：</span></li>');
    if (thirdMenu != null && thirdMenu != '') {
        var mainMenuElement = $('<li/>');
        $(mainMenuElement).text(mainMenu);
        $('#breadcrumb').append(mainMenuElement);
        $('#breadcrumb').append('<span class="divider">></span></li>');
        var secondMenuElement = $('<li/>');
        $(secondMenuElement).text(secondMenu);
        $('#breadcrumb').append(secondMenuElement);
        $('#breadcrumb').append('<span class="divider">></span></li>');
        var thirdMenuElement = $('<li/>');
        $(thirdMenuElement).text(thirdMenu);
        $(thirdMenuElement).attr('class', 'active');
        $('#breadcrumb').append(thirdMenuElement);
    } else if (secondMenu != null && secondMenu != '') {
        var mainMenuElement = $('<li/>');
        $(mainMenuElement).text(mainMenu);
        $('#breadcrumb').append(mainMenuElement);
        $('#breadcrumb').append('<span class="divider">></span></li>');
        var secondMenuElement = $('<li/>');
        $(secondMenuElement).text(secondMenu);
        $(secondMenuElement).attr('class', 'active');
        $('#breadcrumb').append(secondMenuElement);
    } else {
        var mainMenuElement = $('<li/>');
        $(mainMenuElement).text(mainMenu);
        $(mainMenuElement).attr('class', 'active');
        $('#breadcrumb').append(mainMenuElement);
    }
}

/**
 * 显示新建任务窗体
 * @param wdid
 * @param createUrl
 * @param width
 * @param height
 * @param rid
 */
function showCreateWindow(wdid, createUrl, width, height, rid) {
    if (createUrl === null || createUrl === '') {
        var task = {
            wdid: wdid
        };
        postCreateTask(task, wdid, rid);
    } else {
        var strurl = "";
        if (createUrl.indexOf("?") > 0)
            strurl = createUrl + "&wdid=" + wdid;
        else
            strurl = createUrl + "?wdid=" + wdid + "&gjdjlx=" + gjdjlx;

        var returnValue = showWindow(convertURL(strurl), null, width, height);
        if (returnValue != null && returnValue != '') {
            if (returnValue.indexOf("refresh,") < 0) {
                returnValue = "refresh" + "," + returnValue;
            }
            openTaskWin(returnValue, rid);
        }
    }
}


/**
 * ajax提交新建任务窗体内容
 */
function postCreateTask() {
    var queryString = $('#createTaskForm').formSerialize();
    $.post('taskCenter/createTask', queryString, function (result) {
        if (result.success) {
            $('#taskModal').modal('hide');
            openTaskWin("refresh" + "," + result.taskId);
        } else {
            alert(result);
        }

    });
}

function postCreateTask(task, wdid, rid) {
    $.post('taskCenter/createTask', task, function (result) {
        if (result.success) {

            var url = bdcdjUrl + "/wfProject/creatProjectEvent?wdid=" + wdid + "&userid=" + result.userid + "&proid=" + result.proid + "&wfid=" + result.wfid;

            $.get(url, function (result1) {
                refreshTaskList();
                openTaskWin("refresh" + "," + result.taskId, rid);

            });
        } else {
            alert(result);
        }

    });
}

/**
 * 打开某个待办任务
 * @param returnstr
 */
function openTaskWin(returnstr, rid) {
    if (!returnstr) return;
    if (typeof (returnstr) == "object") return;
    var str = returnstr.split(",");
    if (str[0] == 'refresh') {
        if (str[1] != "") {
            var url = portalUrl + "/taskHandle?taskid=" + str[1] + "&rid=" + rid;
            var w_width = screen.availWidth - 10;
            var w_height = screen.availHeight - 32;
            window.open(url, "_task", "left=1,top=0,height=" + w_height + ",width=" + w_width + ",resizable=yes,scrollbars=yes");
        }
    }
}


function showWindow(url, title, width, height) {
    var ua = navigator.userAgent;
    if (ua.lastIndexOf("MSIE 6.0") != -1) {
        if (ua.lastIndexOf("Windows NT 5.1") != -1) {
            height = (height * 1.0 + 102);
        } else if (ua.lastIndexOf("Windows NT 5.0") != -1) {
            height = (height * 1.0 + 49);
        }
    }
    if (width == 0 && height == 0) {
        width = window.screen.availWidth;
        height = window.screen.availHeight;
    }
    try {
        return window.showModalDialog(url, title, "dialogHeight=" + height + "px;dialogWidth=" + width + "px;minimize:yes;maximize:yes;");
    } catch (ex) {
        var winOption = "height=" + height + ",width=" + width + ",top=55,left=200,toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes";
        return window.open(url, window, winOption);
    }
}

/**
 * 在url末尾增加时间戳
 * @param url
 * @returns {*}
 */
function convertURL(url) {
    var timstamp = (new Date()).valueOf();
    if (url.indexOf("?") >= 0) {
        url = url + "&t=" + timstamp;
    } else {
        url = url + "?t=" + timstamp;
    }
    return url;
}

/**
 * 打开某个菜单
 * @param mainMenu
 * @param secondMenu
 * @param thirdMenu
 */
function openMenu(mainMenu, secondMenu, thirdMenu) {
    $('#navMenu li a:contains("' + mainMenu + '")').trigger('click');
    $('#secondMenuTree li a:contains("' + secondMenu + '")').trigger('click');
    $('#thirdMenuTree li a:contains("' + thirdMenu + '")').trigger('click');
}

/**
 * 登出
 */
function logout() {
    var url = platform_url + '/logout.action';
    $.post(url, function () {
    });
    window.close();
}


function refreshTaskList() {
    document.getElementById("mainFrame").contentWindow.refreshTaskList();
}

function showModel(url, title, width, height, fullscreen) {
    showBstrapModel('indexModal', 'indexModalDiv', 'indexModalTitle', url, title, width, height, fullscreen);
}

function hideModel() {
    hideBstrapModel('indexModal', 'indexModalDiv', 'indexModalTitle');
}


//动态显示模态框
function showDynamicModel(id, url, modeltitle, width, height, fullscreen) {
    var title = id + "Title";
    var div = id + "Div";
    var model = $('#' + id);
    var modelDiv = '<div class="Pop-upBox bootbox modal fade bootbox-prompt in newPro" style="display: none;" id=' + id + ' >' +
        '<div class="modal-dialog newPro-modal">' +
        '<div class="modal-content">' +
        '<div class="modal-header panelBg ">' +
        '<i class="icon-remove icon-white icon-right" onclick="hideDynamicModel(\'' + id + '\')"></i>' +
        '<h4 class="modal-title" style="margin: 0; " id="' + title + '"></h4>' +
        '</div>' +
        '<div class="bootbox-body">' +
        ' <iframe id="' + div + '" name="' + div + '" src="" width="99.8%" height="550px" style="border:none;"  frameborder="0" scrolling="yes"></iframe>' +
        '</div>' +
        '</div>' +
        '</div>' +
        '</div>';
    if (model.length == 0)
        $('body').append(modelDiv);
    showBstrapModel(id, div, title, url, modeltitle);
}

function hideDynamicModel(id) {
    var title = id + "Title";
    var div = id + "Div";
    hideBstrapModel(id, div, title);

}

//消息提醒
function loadMsgReminder() {
    $.get(portalUrl + "/reminder", function (result) {
        if (result != null && result.length > 0) {
            var amount = $('.Remind>span').text();
            $('.remindList2').empty();
            var count = 0;
            //初始化闪烁控件---传入需要控制dome元素Jquery选择器
            bellAnimate = animateEffect(".icon-bell");
            for (var i = 0; i < result.length; i++) {
                count = count + result[i].count;
                var item = '<dd><a onclick="closeBellAnimate()" target="_blank" href="' + result[i].moreUrl + '"><span class="label label-important"><i class="icon-exclamation-sign  icon-white"></i></span>' +
                    result[i].name + '<span class="badge badge-important pull-right">' + result[i].count + '</span></a></dd>';
                $('.remindList2').append(item);
            }
            if (count > amount) {
                //开始闪烁
                bellAnimate.start();
                // bellAnimate.end();
            }
            $('.Remind>span').text(count);
        } else {
            $('.Remind>span').text(0);
        }

    });
    window.setTimeout("loadMsgReminder()", 1000 * 60 * 5);
}


function animateEffect(selector) {
    if (!selector) {
        return "参数错误";
    }
    var $dome = $(selector);
    var count = 0;
    var timer = null;
    var operateObj = {
        start: function () {
            if (!timer) {
                timer = window.setInterval(function () {
                    (++count) % 2 == 1 ? $dome.hide() : $dome.show();
                }, 800);
            }
        },
        end: function () {
            window.clearInterval(timer);
            $dome.show();
            timer = null;
        }
    };
    return operateObj;
}

var bellAnimate;

function closeBellAnimate() {
    //停止闪烁
    bellAnimate.end();
}


function resourceRefresh() {
    var contentFrame = document.getElementById("mainFrame");
    contentFrame.src = contentFrame.src;
}

$(function () {
    if (checLoginIp == "true") {
        try {
            (function longPolling() {

                $.ajax({
                    url: casUrl + "/info/online",
                    data: {"timed": new Date().getTime()},
                    dataType: "text",
                    timeout: 10000,
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        if (textStatus == "timeout") { // 请求超时
                            longPolling(); // 递归调用

                            // 其他错误，如网络错误等
                        } else {
                            longPolling();
                        }
                    },
                    success: function (data, textStatus) {
                        var loginIp;
                        if (data.indexOf(loginname + ",") > -1)
                            loginIp = data.substr((data.indexOf(loginname + ",") + loginname.length) + 2, data.length).substr(data.substr((data.indexOf(loginname + ",") + loginname.length) + 2, data.length).indexOf(",") + 1, (data.substr((data.indexOf(loginname + ",") + loginname.length) + 2, data.length).indexOf(";") - (data.substr((data.indexOf(loginname + ",") + loginname.length) + 2, data.length).indexOf(",") + 1)));
                        if (data != null && (data.indexOf(loginname + ",") < 0 || loginIp == clientIp)) {
                            if (textStatus == "success") { // 请求成功
                                longPolling();
                            }
                        } else
                            alert("该账户已在其他地方登录，登录ip为" + loginIp + "，如有问题，请及时修改密码！");

                    }
                });
            })();
        } catch (e) {

        }
    }

});

var isOnLoad = true;

function iframeLoad() {
    try {
        isOnLoad = false;// 加载完成
        if (!isOnLoad && showWatermark == "true") {
            var x = document.createElement('div');
            var path = portalUrl + "/showWatermark";
            x.innerHTML = 'x<style>html,body{background-image:url(' + path + ')}.page-content{background-image:url(' + path + ')}tr,td,th{background:none!important;}</style>';
            var head = document.getElementById('mainFrame').contentWindow.document.getElementsByTagName('head')[0];
            head.appendChild(x.lastChild);

        }
    } catch (e) {

    }
}

//加载时读取当前地区的代办任务数量
function loadReginCount() {
    if (showRegionEnable == 'true') {
        var urls = new Array();
        var xzqdms = new Array();
        var countUrl;
        $("#deployRegionUl li").each(function () {
            countUrl = $(this.children).attr("countUrl");
            var xzqdm = $(this.children).attr("xzqdm");
            urls.push(countUrl);
            xzqdms.push(xzqdm);
            var getCountUrl = portalUrl + "/getDeployRegionTaskCount";
            if (countUrl != null && countUrl != "") {
                $.ajax({
                    url: getCountUrl,
                    dataType: "json",
                    async: true,
                    data: {urls: countUrl, xzqdms: xzqdm},
                    error: function (XMLHttpRequest, textStatus, errorThrown) {

                    },
                    success: function (data, textStatus) {
                        $('#deployRegionCount' + xzqdm).text(data[xzqdm]);
                    }
                });
            }
        });
    }
}

//加载下来的所有的地区数目
function loadAllDeployRegionCount() {
    var url = $("#regionCountUrl").val();
    var xzqdm = $("#regionXzqdm").val();
    var getCountUrl = portalUrl + "/getDeployRegionTaskCount";
    if (url != null && url != "") {
        $.ajax({
            url: getCountUrl,
            dataType: "json",
            timeout: 10000,
            async: true,
            data: {urls: url, xzqdms: xzqdm},
            error: function (XMLHttpRequest, textStatus, errorThrown) {

            },
            success: function (data, textStatus) {
                $('#deployRegionCount').text(data[xzqdm]);
            }
        });
    }
}

//改变部署地区
function changeDeployRegion(url, xzqdm) {
    window.location.href = url + "?xzqdm=" + xzqdm;
}

//调用评价系统显示用户信息接口
function sendEvaluateShowUserUrl() {
    if (evaluateShowUserUrl != null && evaluateShowUserUrl != "") {
        $.ajax({
            url: evaluateShowUserUrl,
            dataType: "json",
            timeout: 10000,
            async: true,
            data: {userid: userid},
            error: function (XMLHttpRequest, textStatus, errorThrown) {

            },
            success: function (data, textStatus) {

            }
        });
    }
}