<@s.html title="工作流时限配置" import="ace,public">
    <script type="text/javascript">
        var url;

        //搜索
        function search(){
            url = "${base!}/workFlowTimeLimit/getWorkFlowTimeLimitPagesJson?" + $("#form1").serialize();
            tableReload("grid-table", url, "");

        }

        function tableReload(table,Url,data){
            var jqgrid = $("#"+table);
            jqgrid.setGridParam({url:Url, datatype:'json',page:1,postData:data});
            jqgrid.trigger("reloadGrid");//重新加载JqGrid


        }
        //新增
        function add(){

            $("#addWorkFlowTimeLimit").show();
            $('.chosen-select').chosen({allow_single_deselect:true, no_results_text:"无匹配数据", width:"100%"});
            $(window).trigger('resize.chosen');
            $("#title").html("新增");
            $("#workflow_time_id").val("");
            $("#gzlid option:first").prop("selected", 'selected');
            $("#gzlid").trigger("chosen:updated");
            $("#jdid option:first").prop("selected", 'selected');
            $("#jdid").trigger("chosen:updated");

        }
        //修改
        function edit(){
            var ids = $('#grid-table').jqGrid('getGridParam', 'selarrrow');
            if (ids.length == 0) {
                tipInfo("请选择一条数据!");
                return;
            }
            if (ids.length > 1) {
                tipInfo("只能同时修改一条数据!");
                return;
            }
            $("#workflow_time_id").val(ids);
            $("#addWorkFlowTimeLimit").show();
            $('.chosen-select').chosen({allow_single_deselect:true, no_results_text:"无匹配数据", width:"100%"});
            $(window).trigger('resize.chosen');
            $("#title").html("编辑");
            $.ajax({
                url: "${base!}/workFlowTimeLimit/getBdcGzlsxjl?id=" + ids,
                type: 'get',
                success: function (data) {
                    if (data && data != '') {
                        $("#jdid").html('');
                        $("#gzlid").find("option[value='" + data.workflow_id + "']").prop("selected", 'selected');
                        $("#gzlid").trigger("chosen:updated");
                        $("#gzlid").change();
                        $("#jdid").find("option[value='" + data.activity_id + "']").prop("selected", 'selected');
                        $("#jdid").trigger("chosen:updated");
                        $("#jdid").change();
                        $("#lcbjsx").val(data.workflow_time_limit);
                        $("#jdbjsx").val(data.activity_time_limit);
                        $("#dwdm").val(data.dwdm);
                        $("#sqlxdm").val(data.sqlxdm);
                    }
                },
                error: function (data) {
                }
            });
        }
        //删除
        function delDialog(ids, url, gridId){
            if (ids.length == 0) {
                tipInfo("请选择一条数据!");
                return;
            }
            showConfirmDialog("删除", "是否删除？", "delAuto", "'"+ids+"','"+url+"','"+gridId+"'", "", "");
        }
        $(function () {

            //下拉框  含搜索的
            $('.chosen-select').chosen({allow_single_deselect: true, no_results_text: "无匹配数据", width: "100%"});
            //resize the chosen on window resize
            $(window).on('resize.chosen', function () {
                $.each($('.chosen-select'), function (index, obj) {
                    $(obj).next().css("width", 0);
                    var w = $(obj).parent().width();
                    $(obj).next().css("width", w);
                })
                $.each($('.chosen-single-select'), function (index, obj) {
                    $(obj).next().css("width", 0);
                    var e = $(obj).parent().width();
                    $(obj).next().css("width", e);
                })
            }).trigger('resize.chosen');
            //table下拉列表事件
            $("#gzlid").change(function () {
                getFields($(this).val(),"");
            })
            $("#jdid").change(function () {
                var gzlid=$("#gzlid").val();
                getFields(gzlid,$(this).val());
            })
            $("#save").click(function () {
                var gzlid=$("#gzlid").val();
                var jdid=$("#jdid").val();
                var lcbjsx=$("#lcbjsx").val();
                var jdbjsx=$("#jdbjsx").val();
                var dwdm=$("#dwdm").val();
                var sqlxdm=$("#sqlxdm").val();
                if(gzlid==null || gzlid==''){
                    tipInfo("请选择工作流!");
                    return;
                }
                if(jdid==null || jdid==''){
                    tipInfo("请选择节点!");
                    return;
                }
                if(lcbjsx==null || lcbjsx==''){
                    tipInfo("请填写工作流办件时限!");
                    return;
                }
                if(jdbjsx==null || jdbjsx==''){
                    tipInfo("请填写节点办件时限!");
                    return;
                }
                if(isNaN(lcbjsx)){
                    tipInfo("工作流办件时限请填写数字!");
                    return;
                }
                if(isNaN(jdbjsx)){
                    tipInfo("节点办件时限请填写数字!");
                    return;
                }
                if(dwdm==null || dwdm==''){
                    tipInfo("请填写单位代码!");
                    return;
                }
                if(sqlxdm==null || sqlxdm==''){
                    tipInfo("请填写申请类型代码!");
                    return;
                }
                if(parseInt(lcbjsx)  < parseInt(jdbjsx)){
                    tipInfo("工作流办件时限不应小于节点办件时限,请重新填写!");
                    return;
                }
                $.ajax({
                    url: "${base!}/workFlowTimeLimit/save?" +  $("#tableForm").serialize(),
                    type: 'get',
                    success: function (data) {
                        if (data && data != 'true') {
                            tipInfo(decodeURIComponent(data));
                        } else {
                            tipInfo("保存成功!");
                            search();
                        }
                    },
                    error: function (data) {
                    }
                });
            })
            /*表单校验 end*/
            $(".hideButton").click(function () {
                $("#tableForm").find(".form-control").tooltip("destroy").removeAttr("aria-invalid").removeAttr("title").removeAttr("style");
                $('#tableForm')[0].reset();
                $(".Pop").hide();
            });
            //删除
            $("#del").click(function () {
                var ids = $('#grid-table').jqGrid('getGridParam', 'selarrrow');
                delDialog(ids, "${base!}/workFlowTimeLimit/del", "grid-table");
            })
        });
        //根据table获取字段
        function getFields(gzlid,jdid) {
            $.ajax({
                type: "GET",
                url: "${base!}/autoTurnTask/getJdAndYhList",
                data: {
                    gzlid: gzlid,
                    jdid: jdid
                },
                dataType: "json",
                async:false,
                success: function (result) {
                    //清空
                    if(result!=null && result.jdList!=null && ($("#jdid").val()==null || jdid=='')){
                        $("#jdid").html("");
                        $("#jdid").append('<option value="" >请选择节点（此项必填）</option>');
                        if (result.jdList != null && result.jdList != '') {
                            $.each(result.jdList, function (index, data) {
                                $("#jdid").append('<option value="' + data.activityDefinitionId + '" >' + data.activityName + '</option>');
                            })
                        }
                        $("#jdid").trigger("chosen:updated");
                    }
                    if(result!=null && result.yhList!=null){
                        $("#yhid").html("");
                        $("#yhid").append('<option value="" >请选择用户（此项必填）</option>');
                        if (result.yhList != null && result.yhList != '') {
                            $.each(result.yhList, function (index, data) {
                                $("#yhid").append('<option value="' + data.userId + '" >' + data.userName + '</option>');
                            })
                        }
                        $("#yhid").trigger("chosen:updated");
                    }
                },
                error: function (data) {
                }
            });
        }

        function del() {
            var ids = $('#grid-table').jqGrid('getGridParam', 'selarrrow');
            delDialog(ids, "${base!}/workFlowTimeLimit/del", "grid-table");
        }
        function delAuto(ids,url,gridId) {
            $.getJSON(url + "?ids=" + ids, {}, function (jsonData) {
                setTimeout($.unblockUI, 10);
                alert(jsonData.result);
                search();
            })
        }
        function batSaveBtn() {
            $("#batEditJdsx").show();
            $('.chosen-select').chosen({allow_single_deselect:true, no_results_text:"无匹配数据", width:"100%"});
            $(window).trigger('resize.chosen');
            $("#batEditTitle").html("批量修改");
        }
        function batSave() {
            var batJdbjsx=$("#batJdbjsx").val();
            var ids = $('#grid-table').jqGrid('getGridParam', 'selarrrow');
            if(confirm("确定需要批量修改？")){
                $.ajax({
                    url: "${base!}/workFlowTimeLimit/batSaveJdsx",
                    type: 'post',
                    data:{activity_time_limit:batJdbjsx,ids:ids.join(","),wdid:$("select[name='wdid']").val(),jdmc:$("select[name='jdmc']").val()},
                    success: function (data) {
                        if (data && data != 'true') {
                            tipInfo(decodeURIComponent(data));
                        } else {
                            $("#batEditJdsx").hide();
                            tipInfo("保存成功!");
                            search();
                        }
                    },
                    error: function (data) {
                    }
                });
            }

        }
    </script>

    <div class="main-container">
        <div class="space-10"></div>
        <div class="page-content">
            <#--查询表单-->
            <@g.queryForm id="form1" method="post">
            <#--查询条件每一行，目前只支持两个条件一行-->
                <@g.queryRow>
                    <@g.queryItem label="工作流名称" name="wdid" itemType="combo"  showFieldName="workflowName" valueFieldName="workflowDefinitionId" source="pfWorkFlowDefineVoList" defaultValue=""/>
                    <@g.queryItem label="节点名称" name="jdmc" itemType="combo" showFieldName="name" valueFieldName="value" source="[{'name':'全部','value':''},{'name':'受理','value':'受理'},{'name':'初审','value':'初审'},{'name':'复审','value':'复审'},{'name':'缮证','value':'缮证'},{'name':'发证','value':'发证'}]" defaultValue=""/>
                </@g.queryRow>
            <#--表单查询-->
                <@g.queryBar text="搜索" handler="search"/>
            </@g.queryForm>
            <#--列表按钮-->
            <@g.toolBars>
                <@g.toolBar text="新增" handler="add"/>
                <@g.toolBar text="修改" handler="edit"/>
                <@g.toolBar text="删除" handler="del"/>
<#--                <@g.toolBar text="批量修改" handler="batSaveBtn" />-->
            </@g.toolBars>
            <#--列表-->
            <@g.list tableId="grid-table" pageId="grid-pager" keyField="workflow_time_id" dataUrl="${base!}/workFlowTimeLimit/getWorkFlowTimeLimitPagesJson" rowNum="10" multiselect="true">
            <#--列表字段-->
                <@g.field fieldName="workflow_name" header="工作流名称" width="30%" />
                <@g.field fieldName="activity_name" header="节点名称" width="20%" />
                <@g.field fieldName="workflow_time_limit" header="工作流办件时限" width="10%"/>
                <@g.field fieldName="activity_time_limit" header="节点办件时限" width="10%"/>

                <@g.field fieldName="dwdm" header="单位代码" width="10%"/>
                <@g.field fieldName="sqlxdm" header="申请类型代码" width="10%" renderer=""/>
                <@g.field fieldName="workflow_time_id" header="id" width="0%" hidden="true" />
                <@g.field fieldName="workflow_id" header="工作流id" width="0%" hidden="true" />
                <@g.field fieldName="activity_id" header="节点id" width="0%" hidden="true" />
            </@g.list>
            <table id="grid-table"></table>
            <div id="grid-pager"></div>
        </div>
        <div class="Pop-upBox bootbox modal fade bootbox-prompt in Pop" style="display:none" id="addWorkFlowTimeLimit">
            <div class="modal-dialog new-modal">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title"><i class="ace-icon fa fa-pencil-square-o icon-only bigger-110"
                                                   id="title"></i></h4>
                        <button type="button" class="hideButton"><i class="ace-icon glyphicon glyphicon-remove"></i>
                        </button>
                    </div>
                    <div class="PBTools">
                        <ul>
                            <li>
                                <a href="#" id="save">
                                    <i class="ace-icon fa fa-download"></i>
                                    <span>保存</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="bootbox-body">
                        <form id="tableForm" novalidate="novalidate">
                            <div class="UItable">
                                <input type="hidden" id="workflow_time_id" name="workflow_time_id">
                                <table cellpadding="0" cellspacing="0" border="0" class="tableA">
                                    <tbody>
                                    <tr>
                                        <td width="150px">
                                            <label>工作流名称:</label>
                                        </td>
                                        <td>
                                            <select name="workflow_id" id="gzlid" class="chosen-select" data-placeholder=" " required>
                                                <option value="">请选择工作流名称（此项必填）</option>
                                                <#list pfWorkFlowDefineVoList as wdVo>
                                                    <option value="${wdVo.workflowDefinitionId!}">${wdVo.workflowName!}</option>
                                                </#list>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label>节点:</label>
                                        </td>
                                        <td>
                                            <select name="activity_id" id="jdid" class="chosen-select" data-placeholder=" " required>
                                                <option value="">请选择节点（此项必填）</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label>工作流办件时限:</label>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" id="lcbjsx"
                                                   name="workflow_time_limit" required/>
<#--                                            <select name="yhid" id="yhid" class="chosen-select" data-placeholder=" " required>-->
<#--                                                <option value="">请选择时限（此项必填）</option>-->
<#--                                            </select>-->
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label>节点办件时限:</label>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" id="jdbjsx"
                                                   name="activity_time_limit" required>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label>单位代码:</label>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" id="dwdm"
                                                   name="dwdm" required>
                                            <#--                                            <select name="yhid" id="yhid" class="chosen-select" data-placeholder=" " required>-->
                                            <#--                                                <option value="">请选择时限（此项必填）</option>-->
                                            <#--                                            </select>-->
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label>申请类型代码:</label>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" id="sqlxdm"
                                                   name="sqlxdm" required>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="Pop-upBox bootbox modal fade bootbox-prompt in Pop" style="display:none" id="batEditJdsx">
            <div class="modal-dialog new-modal">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title"><i class="ace-icon fa fa-pencil-square-o icon-only bigger-110"
                                                   id="batEditTitle"></i></h4>
                        <button type="button" class="hideButton"><i class="ace-icon glyphicon glyphicon-remove"></i>
                        </button>
                    </div>
                    <div class="PBTools">
                        <ul>
                            <li>
                                <a href="#" id="batSave" onclick="batSave()">
                                    <i class="ace-icon fa fa-download"></i>
                                    <span>保存</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="bootbox-body">
                        <form id="batForm" novalidate="novalidate">
                            <div class="UItable">
                                <table cellpadding="0" cellspacing="0" border="0" class="tableA">
                                    <tbody>
                                    <tr>
                                        <td width="150px">
                                            <label>节点时限:</label>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" id="batJdbjsx"
                                                   name="activity_time_limit" required>
                                        </td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</@s.html>