<#macro html title="" import="" css="" js="">
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=9; IE=8; IE=EDGE">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8"/>
    <title>${title}</title>
    <#if import??>
        <#list import?split(",") as lib>
            <#switch lib>

                <#case "ace">
                    <@script name="static/thirdControl/jquery/jquery.min.js"></@script>
                    <@style name="static/thirdControl/ace/css/jquery-ui.min.css"></@style>
                    <@script name="static/thirdControl/jquery/jquery.cookie.js"></@script>
                    <@script name="static/js/jquery.watermark.min.js"></@script>
                    <@style name="static/thirdControl/ace/bootstrap/css/bootstrap.min.css"></@style>
                    <@style name="static/thirdControl/ace/bootstrap/css/bootstrap-combined.min.css"></@style>
                    <@style name="static/thirdControl/jqgrid/css/ui.jqgrid.css"></@style>
                    <@script name="static/thirdControl/jqgrid/js/jquery.jqGrid.src.js"></@script>
                    <@script name="static/thirdControl/jqgrid/js/i18n/grid.locale-cn.js"></@script>
                    <@script name="static/thirdControl/ace/bootstrap/js/html5shiv.min.js"></@script>
                    <@style name="static/thirdControl/ace/font-awesome/css/font-awesome.min.css"></@style>
                    <@style name="static/thirdControl/ace/css/ace-fonts.css"></@style>
                    <@style name="static/thirdControl/ace/css/chosen.css"></@style>
                    <@style name="static/thirdControl/ace/css/ace.min.css"></@style>
                    <@style name="static/thirdControl/ace/css/ace-rtl.min.css"></@style>
                    <@style name="static/thirdControl/ace/css/ace-skins.min.css"></@style>
                    <@style name="static/thirdControl/ace/css/ace-part2.min.css"></@style>
                    <@style name="static/thirdControl/ace/css/ace-ie.min.css"></@style>
                    <@script name="static/thirdControl/ace/js/ace-extra.min.js"></@script>
                    <@script name="static/thirdControl/ace/js/jquery.easy-pie-chart.min.js"></@script>
                    <@style name="static/thirdControl/ace/css/index.css"></@style>
                    <@script name="static/thirdControl/ace/js/jquery-ui.min.js"></@script>
                    <@style name="static/thirdControl/ace/css/ace.onpage-help.css"></@style>
                    <@script name="static/thirdControl/ace/js/ace/ace.onpage-help.js"></@script>
                    <@script name="static/thirdControl/ace/js/ace/fuelux.wizard.min.js"></@script>
                    <@script name="static/thirdControl/ace/js/jquery.blockUI.js"></@script>
                    <@script name="static/thirdControl/ace/js/bootbox.min.js"></@script>

                    <@script name="static/thirdControl/ace/js/chosen.jquery.min.js"></@script>
                    <@script name="static/thirdControl/ace/js/jquery.validate.min.js"></@script>
                    <@style name="static/thirdControl/ace/js/date-time/datepicker.css"></@style>
                    <@script name="static/thirdControl/ace/js/date-time/bootstrap-datepicker.min.js"></@script>
                    <@script name="static/thirdControl/ace/js/date-time/locales/bootstrap-datepicker.zh-CN.js"></@script>
                    <@script name="static/thirdControl/ace/bootstrap/js/bootstrap.min.js"></@script>


                    <@script name="static/thirdControl/ace/js/fuelux/data/fuelux.tree-sample-demo-data.js"></@script>
                    <@script name="static/thirdControl/ace/js/fuelux/fuelux.tree.min.js"></@script>
                    <#break />

                <#case "select">
                    <@style name="static/css/other.css"></@style>
                    <@script name="static/thirdControl/ace/bootstrap/js/bootstrap-select.min.js"></@script>
                    <#break />
                <#case "init">
                    <@style name="static/css/other.css"></@style>
                    <#break />
                <#case "public">
                    <@portalScript name="static/js/public.js"></@portalScript>
                    <#break />
                <#case "jquery">
                    <@script name="static/thirdControl/jquery/jquery.min.js"></@script>
                    <#break />
                <#case "highcharts">
                    <@script name="static/thirdControl/highcharts/adapters/highcharts.js"></@script>
                    <@script name="static/thirdControl/highcharts/adapters/highcharts-3d.js"></@script>
                    <@script name="static/thirdControl/highcharts/adapters/exporting.js"></@script>
                    <#break />
                <#case "jqueryVersion">
                    <script type="text/javascript">
                        var _$ = jQuery.noConflict(true);
                    </script>
                    <#break />
                <#case "multiselect">
                    <@script name="static/thirdControl/bootstrap/js/bootstrap-select.js"></@script>
                    <@style name="static/thirdControl/bootstrap/css/bootstrap-select.css"></@style>
                    <#break />
                <#case "kindEditor">
                    <@pfscript name="global/kindeditor/kindeditor-min.js"></@pfscript>
                    <@pfscript name="global/kindeditor/lang/zh_CN.js"></@pfscript>
                    <#break />
                <#case "ext">
                    <@pfstyle name="global/ext/resources/css/ext-all.css"></@pfstyle>
                    <@pfscript name="global/ext/ext-base.js"></@pfscript>
                    <@pfscript name="global/ext/ext-all.js"></@pfscript>
                    <@pfscript name="global/ext/ext-lang-zh_CN.js"></@pfscript>
                    <#break />
                <#case "fc">
                    <@fcscript name="/js/fc-min.js"></@fcscript>
                    <@fcstyle name="/css/fc-all.css"></@fcstyle>
                    <#break />
                <#default>
            </#switch>
        </#list>
    </#if>
${css!}
</head>
<body>
    <#if import??>
        <#list import?split(",") as lib>
            <#switch lib>
                <#case "ace">
                    <@script name="static/thirdControl/ace/js/ace-elements.min.js"></@script>
                    <@script name="static/thirdControl/ace/js/ace.min.js"></@script>
                    <#break />
                <#case "authorize">
                    <@include name="../wf/common/rightsManagement.ftl"/>
                    <@include name="../wf/common//fieldColorManagement.ftl"/>
                    <@include name="../wf/common//xtYhManagement.ftl"/>
                    <#break />
                <#default>
            </#switch>
        </#list>
    </#if>
    <#nested />
    <@script name="static/bootstrap/js/bootstrap-dropdown.js"></@script>
${js!}
</body>
</html>
</#macro>

<#macro script name>
<script src="<@rootPath/>/${name}" type="text/javascript"></script>
</#macro>

<#macro pfscript name>
<script src="<@pfRootPath/>/${name}" type="text/javascript"></script>
</#macro>

<#macro fcscript name>
<script src="<@fcRootPath/>/${name}" type="text/javascript"></script>
</#macro>

<#macro frscript name>
<script src="<@frRootPath/>/${name}" type="text/javascript"></script>
</#macro>
<#macro portalScript name>
<script src="<@portalPath/>/${name}" type="text/javascript"></script>
</#macro>

<#macro style name>
<link href="<@rootPath/>/${name}" type="text/css" media="screen" rel="stylesheet"/>
</#macro>

<#macro pfstyle name>
<link href="<@pfRootPath/>/${name}" type="text/css" media="screen" rel="stylesheet"/>
</#macro>

<#macro fcstyle name>
<link href="<@fcRootPath/>/${name}" type="text/css" media="screen" rel="stylesheet"/>
</#macro>

<#macro frstyle name>
<link href="<@frRootPath/>/${name}" type="text/css" media="screen" rel="stylesheet"/>
</#macro>


<#macro rootPath>${bdcdjUrl!}</#macro>
<#macro portalPath>${base!}</#macro>
<#macro pfRootPath>${path_platform!}</#macro>
<#macro fcRootPath>${fileCenterUrl!}</#macro>
<#macro frRootPath>${reportUrl!}</#macro>

<#macro include name>"
    <#include "${name}"/>
</#macro>