/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfDistrict;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfDistrictService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/district"})
public class DistrictController
extends BaseController {
    @Autowired
    private PfDistrictService districtService;

    @RequestMapping(value={""})
    public String manage(Model model) {
        return "/config/district/manager";
    }

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object districtjson(Model model) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if (userInfo.isAdmin()) {
            regionCode = null;
        }
        Ztree ztree = this.districtService.getAllDistrictTree(regionCode);
        return ztree;
    }

    @RequestMapping(value={"districtList"})
    @ResponseBody
    public Object getDistrictList(Model model) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if (userInfo.isAdmin()) {
            regionCode = null;
        }
        List districtList = this.districtService.getAllDistrictList(regionCode);
        return districtList;
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public PfDistrict getDistrict(@RequestParam(value="districtId", required=false) String districtId) {
        PfDistrict district = (PfDistrict)this.districtService.findById((Object)districtId);
        return district == null ? new PfDistrict() : district;
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="district") PfDistrict district, Model model) {
        PfDistrict districttmp;
        if (StringUtils.isBlank((String)district.getDistrictId())) {
            district.setDistrictId(UUIDGenerator.generate18());
        }
        if ((districttmp = (PfDistrict)this.districtService.findById((Object)district.getDistrictId())) != null) {
            this.districtService.update((Object)district);
        } else {
            this.districtService.insert((Object)district);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("district", district);
        return result;
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public Object del(@ModelAttribute(value="district") PfDistrict district) {
        if (RequestUtils.checkIsAdmin()) {
            if (district != null) {
                this.districtService.deleteDistrict(district);
                return this.handlerSuccessJson();
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlerErrorJson();
    }
}

