/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.FileService;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.util.FileUtil;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/fileCenter"})
public class FileCenterController
extends BaseController {
    @Resource(name="nodeOtherService")
    NodeService nodeService;
    @Resource(name="fileOtherService")
    FileService fileService;
    @Resource(name="nodeService")
    NodeService nodeOtherService;
    @Resource(name="fileService")
    FileService fileOtherService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysWorkFlowInstanceRelService workFlowInstanceRelService;

    @RequestMapping(value={"select"})
    public String treeSelect(Model model, String fromProid, String toProid) {
        model.addAttribute("fromProid", (Object)fromProid);
        model.addAttribute("toProid", (Object)toProid);
        return "/fileCenter/file-tree-select";
    }

    @RequestMapping(value={"selectProid"})
    public String selectProid(Model model, String fromProid, String proid) {
        model.addAttribute("fromProid", (Object)fromProid);
        model.addAttribute("toProid", (Object)proid);
        return "/fileCenter/file-tree-select";
    }

    @RequestMapping(value={"selectOther"})
    public String selectOther(Model model, String fromProid, String toProid) {
        model.addAttribute("fromProid", (Object)fromProid);
        model.addAttribute("toProid", (Object)toProid);
        return "/fileCenter/file-tree-other-select";
    }

    @RequestMapping(value={"leftjson"})
    @ResponseBody
    public Object leftjson(Model model, String fromProid) throws Exception {
        Space space;
        Node node;
        if (StringUtils.isNotBlank((String)fromProid) && (node = this.nodeService.getNode((space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true)).getId(), fromProid, true)) != null) {
            String name = node.getName();
            PfWorkFlowInstanceVo workFlowInstanceVo = this.workFlowIntanceService.getWorkflowInstance(fromProid);
            name = workFlowInstanceVo != null ? workFlowInstanceVo.getWorkflowIntanceName() : "\u6839\u76ee\u5f55";
            Ztree root = new Ztree();
            root.setId(String.valueOf(node.getId()));
            root.setName(name);
            root.setChkDisabled(true);
            root.setParent(true);
            root.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/img/folder.gif")));
            List nodeList = this.nodeService.getAllChildNodes(node.getId());
            if (nodeList != null && nodeList.size() > 0) {
                LinkedHashMap<String, Ztree> nodeTreeMap = new LinkedHashMap<String, Ztree>();
                for (Node childNode : nodeList) {
                    nodeTreeMap.put(String.valueOf(childNode.getId()), this.nodeToZtree(childNode, true));
                }
                for (Ztree tree : nodeTreeMap.values()) {
                    if (tree.getPid() == null) continue;
                    Ztree ztree = (Ztree)nodeTreeMap.get(tree.getPid());
                    if (ztree != null) {
                        ztree.addChild(tree);
                        continue;
                    }
                    root.addChild(tree);
                }
            }
            return root;
        }
        return null;
    }

    @RequestMapping(value={"rightjson"})
    @ResponseBody
    public Object rightjson(Model model, String toProid) throws Exception {
        Space space;
        Node node;
        if (StringUtils.isNotBlank((String)toProid) && (node = this.nodeService.getNode((space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true)).getId(), toProid, true)) != null) {
            String name = node.getName();
            PfWorkFlowInstanceVo workFlowInstanceVo = this.workFlowIntanceService.getWorkflowInstance(toProid);
            name = workFlowInstanceVo != null ? workFlowInstanceVo.getWorkflowIntanceName() : "\u6839\u76ee\u5f55";
            Ztree root = new Ztree();
            root.setId(String.valueOf(node.getId()));
            root.setName(name);
            root.setChkDisabled(true);
            root.setParent(true);
            root.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/img/folder.gif")));
            List nodeList = this.nodeService.getAllChildNodes(node.getId());
            if (nodeList != null && nodeList.size() > 0) {
                LinkedHashMap<String, Ztree> nodeTreeMap = new LinkedHashMap<String, Ztree>();
                for (Node childNode : nodeList) {
                    nodeTreeMap.put(String.valueOf(childNode.getId()), this.nodeToZtree(childNode, false));
                }
                for (Ztree tree : nodeTreeMap.values()) {
                    if (tree.getPid() == null) continue;
                    Ztree ztree = (Ztree)nodeTreeMap.get(tree.getPid());
                    if (ztree != null) {
                        ztree.addChild(tree);
                        continue;
                    }
                    root.addChild(tree);
                }
            }
            return root;
        }
        return null;
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object saveJson(Model model, String fromProid, String toProid, String nodes) throws Exception {
        if (StringUtils.isNotBlank((String)fromProid) && StringUtils.isNotBlank((String)toProid) && StringUtils.isNotBlank((String)nodes)) {
            try {
                List nodeList = (List)JSON.parseObject((String)nodes, List.class);
                LinkedHashMap treeMap = this.fileNodeToTreeMap(nodeList);
                Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
                Node leftNode = this.nodeService.getNode(space.getId(), fromProid, true);
                if (leftNode != null) {
                    HashMap leftMap = this.fileNodeToMap(leftNode.getId(), this.nodeService);
                    HashMap<String, Node> newMap = new HashMap<String, Node>();
                    Node rightNode = this.nodeService.getNode(space.getId(), toProid, true);
                    if (rightNode != null) {
                        HashMap rightMap = this.fileNodeToMap(rightNode.getId(), this.nodeService);
                        rightMap.put(rightNode.getId(), rightNode);
                        for (Map.Entry entry : treeMap.entrySet()) {
                            Ztree pTree;
                            Node newNode;
                            Ztree tree = (Ztree)entry.getValue();
                            String tid = tree.getKz1();
                            String pTid = tree.getKz2();
                            Node leftChild = (Node)leftMap.get(Integer.parseInt(tree.getId()));
                            if (leftChild == null || !StringUtils.isNotBlank((String)leftChild.getName())) continue;
                            Integer pid = Integer.parseInt(tree.getPid());
                            if (rightMap.containsKey(pid)) {
                                Node rightChild = (Node)rightMap.get(pid);
                                if (rightChild == null) continue;
                                if (leftChild instanceof com.gtis.fileCenter.model.impl.File) {
                                    Integer[] ids = new Integer[]{leftChild.getId()};
                                    this.nodeService.copy(ids, rightChild.getId(), true);
                                    continue;
                                }
                                newNode = this.nodeService.getNode(rightChild.getId(), leftChild.getName(), true);
                                newMap.put(tid, newNode);
                                continue;
                            }
                            if (!leftMap.containsKey(pid) || (pTree = (Ztree)treeMap.get(pTid)) == null || (newNode = (Node)newMap.get(pTree.getKz1())) == null) continue;
                            if (leftChild instanceof com.gtis.fileCenter.model.impl.File) {
                                Integer[] ids = new Integer[]{leftChild.getId()};
                                this.nodeService.copy(ids, newNode.getId(), true);
                                continue;
                            }
                            Node newNodeChild = this.nodeService.getNode(newNode.getId(), leftChild.getName(), true);
                            newMap.put(tid, newNodeChild);
                        }
                        this.workFlowInstanceRelService.deleteWorkFlowRel(fromProid, toProid);
                        this.workFlowInstanceRelService.deleteWorkFlowRel(toProid, fromProid);
                        this.workFlowInstanceRelService.insertWorkFlowRel(fromProid, toProid);
                    }
                }
                return this.handlerSuccessJson();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.handlerErrorJson("\u64cd\u4f5c\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"rightOtherJson"})
    @ResponseBody
    public Object rightOtherJson(Model model, String toProid) throws Exception {
        Space space;
        Node node;
        if (StringUtils.isNotBlank((String)toProid) && (node = this.nodeOtherService.getNode((space = this.nodeOtherService.getWorkSpace("WORK_FLOW_STUFF", true)).getId(), toProid, true)) != null) {
            String name = "\u76ee\u6807\u8def\u5f84";
            Ztree root = new Ztree();
            root.setId(String.valueOf(node.getId()));
            root.setName(name);
            root.setChkDisabled(true);
            root.setParent(true);
            root.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/img/folder.gif")));
            List nodeList = this.nodeOtherService.getAllChildNodes(node.getId());
            if (nodeList != null && nodeList.size() > 0) {
                LinkedHashMap<String, Ztree> nodeTreeMap = new LinkedHashMap<String, Ztree>();
                for (Node childNode : nodeList) {
                    nodeTreeMap.put(String.valueOf(childNode.getId()), this.nodeToZtree(childNode, false));
                }
                for (Ztree tree : nodeTreeMap.values()) {
                    if (tree.getPid() == null) continue;
                    Ztree ztree = (Ztree)nodeTreeMap.get(tree.getPid());
                    if (ztree != null) {
                        ztree.addChild(tree);
                        continue;
                    }
                    root.addChild(tree);
                }
            }
            return root;
        }
        return null;
    }

    @RequestMapping(value={"saveOtherJson"})
    @ResponseBody
    public Object saveOtherJson(Model model, String fromProid, String toProid, String nodes, String parentNodes) throws Exception {
        if (StringUtils.isNotBlank((String)fromProid) && StringUtils.isNotBlank((String)toProid) && StringUtils.isNotBlank((String)nodes) && StringUtils.isNotBlank((String)parentNodes)) {
            try {
                List nodeList = (List)JSON.parseObject((String)nodes, List.class);
                LinkedHashMap treeMap = this.fileNodeToTreeMap(nodeList);
                List parentNodeList = (List)JSON.parseObject((String)parentNodes, List.class);
                LinkedHashMap parentTreeMap = this.fileNodeToTreeMap(parentNodeList);
                Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
                Node leftNode = this.nodeService.getNode(space.getId(), fromProid, true);
                if (leftNode != null) {
                    HashMap leftMap = this.fileNodeToMap(leftNode.getId(), this.nodeService);
                    HashMap<String, Node> newMap = new HashMap<String, Node>();
                    Space rightSpace = this.nodeOtherService.getWorkSpace("WORK_FLOW_STUFF", true);
                    Node rightNode = this.nodeOtherService.getNode(rightSpace.getId(), toProid, true);
                    if (rightNode != null) {
                        HashMap rightMap = this.fileNodeToMap(rightNode.getId(), this.nodeOtherService);
                        rightMap.put(rightNode.getId(), rightNode);
                        String dirPath = FileUtil.getTempPath((String)"filerel");
                        FileUtil.createDirectory((String)dirPath, (boolean)false);
                        for (Map.Entry entry : treeMap.entrySet()) {
                            Ztree tree = (Ztree)entry.getValue();
                            Integer pid = Integer.parseInt(tree.getPid());
                            String tid = tree.getKz1();
                            String pTid = tree.getKz2();
                            Ztree parentTree = (Ztree)parentTreeMap.get(pTid);
                            boolean isLeft = parentTree.isDrag();
                            Node leftChild = (Node)leftMap.get(Integer.parseInt(tree.getId()));
                            if (leftChild == null || !StringUtils.isNotBlank((String)leftChild.getName())) continue;
                            if (isLeft) {
                                Node rightChild;
                                Ztree pTree = (Ztree)treeMap.get(pTid);
                                if (pTree == null || (rightChild = (Node)newMap.get(pTree.getKz1())) == null) continue;
                                if (leftChild instanceof com.gtis.fileCenter.model.impl.File) {
                                    String filePath = dirPath + "/" + leftChild.getId() + leftChild.getName() + "." + ((com.gtis.fileCenter.model.impl.File)leftChild).getExtension();
                                    File tmpFile = new File(filePath);
                                    if (!tmpFile.exists()) {
                                        this.fileService.downloadToFile(leftChild.getId(), filePath);
                                    }
                                    Node node = this.fileOtherService.uploadFile(new File(filePath), rightChild.getId(), leftChild.getName(), null, true, true);
                                    continue;
                                }
                                Node newNode = this.nodeOtherService.getNode(rightChild.getId(), leftChild.getName(), true);
                                newMap.put(tid, newNode);
                                continue;
                            }
                            Node rightChild = (Node)rightMap.get(pid);
                            if (rightChild == null) continue;
                            if (leftChild instanceof com.gtis.fileCenter.model.impl.File) {
                                String filePath = dirPath + "/" + leftChild.getId() + leftChild.getName() + "." + ((com.gtis.fileCenter.model.impl.File)leftChild).getExtension();
                                File tmpFile = new File(filePath);
                                if (!tmpFile.exists()) {
                                    this.fileService.downloadToFile(leftChild.getId(), filePath);
                                }
                                Node node = this.fileOtherService.uploadFile(new File(filePath), rightChild.getId(), leftChild.getName(), null, true, true);
                                continue;
                            }
                            Node newNode = this.nodeOtherService.getNode(rightChild.getId(), leftChild.getName(), true);
                            newMap.put(tid, newNode);
                        }
                        FileUtil.deleteDirectory((String)dirPath);
                    }
                }
                return this.handlerSuccessJson();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.handlerErrorJson("\u64cd\u4f5c\u5931\u8d25\uff01");
    }

    private Ztree nodeToZtree(Node node, boolean isdrag) {
        Ztree tree = new Ztree();
        tree.setId(String.valueOf(node.getId()));
        tree.setName(node.getName());
        tree.setPid(String.valueOf(node.getParentId()));
        if (!(node instanceof com.gtis.fileCenter.model.impl.File)) {
            tree.setParent(true);
            tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/img/folder.gif")));
        }
        tree.setDrag(isdrag);
        return tree;
    }

    private HashMap fileNodeToMap(Integer nodeId, NodeService nService) {
        HashMap nodeMap = new HashMap();
        List leftNodeList = nService.getAllChildNodes(nodeId);
        if (leftNodeList != null && leftNodeList.size() > 0) {
            for (int i = 0; i < leftNodeList.size(); ++i) {
                nodeMap.put(((Node)leftNodeList.get(i)).getId(), leftNodeList.get(i));
            }
        }
        return nodeMap;
    }

    private HashMap fileNodeOneChildToMap(Integer nodeId, NodeService nService) {
        HashMap nodeMap = new HashMap();
        List leftNodeList = nService.getChildNodes(nodeId);
        if (leftNodeList != null && leftNodeList.size() > 0) {
            for (int i = 0; i < leftNodeList.size(); ++i) {
                nodeMap.put(((Node)leftNodeList.get(i)).getId(), leftNodeList.get(i));
            }
        }
        return nodeMap;
    }

    private HashMap fileNodeOneChildToNameMap(Integer nodeId, NodeService nService) {
        HashMap nodeMap = new HashMap();
        List leftNodeList = nService.getChildNodes(nodeId);
        if (leftNodeList != null && leftNodeList.size() > 0) {
            for (int i = 0; i < leftNodeList.size(); ++i) {
                nodeMap.put(((Node)leftNodeList.get(i)).getName(), leftNodeList.get(i));
            }
        }
        return nodeMap;
    }

    private LinkedHashMap<String, Ztree> fileNodeToTreeMap(List<JSONObject> nodeList) {
        LinkedHashMap<String, Ztree> treeMap = new LinkedHashMap<String, Ztree>();
        for (int i = 0; i < nodeList.size(); ++i) {
            Ztree tree = this.ztreeNodeToZtree(nodeList.get(i));
            String tId = MapUtils.getString((Map)((Map)nodeList.get(i)), (Object)"tId");
            String parentTId = MapUtils.getString((Map)((Map)nodeList.get(i)), (Object)"parentTId");
            tree.setKz1(tId);
            tree.setKz2(parentTId);
            treeMap.put(tId, tree);
        }
        return treeMap;
    }

    private Ztree ztreeNodeToZtree(JSONObject jsonObject) {
        Ztree tree = new Ztree();
        tree.setId(MapUtils.getString((Map)jsonObject, (Object)"id"));
        tree.setName(MapUtils.getString((Map)jsonObject, (Object)"name"));
        tree.setPid(MapUtils.getString((Map)jsonObject, (Object)"pid"));
        tree.setDrag(MapUtils.getBooleanValue((Map)jsonObject, (Object)"drag"));
        return tree;
    }

    @RequestMapping(value={"fileView"})
    public String fileView(Model model, String proid, Integer nodeId, String hasChildNode, HttpServletResponse response) throws Exception {
        try {
            Node node = null;
            if (nodeId != null) {
                model.addAttribute("nodeId", (Object)nodeId);
                node = this.nodeService.getNode(nodeId);
            } else if (StringUtils.isNotBlank((String)proid)) {
                model.addAttribute("proid", (Object)proid);
                Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
                node = this.nodeService.getNode(space.getId(), proid, false);
            }
            if (node != null) {
                String token = this.nodeService.getToken(node);
                String url = AppConfig.getFileCenterUrl() + "/file/get.do?fid=" + node.getId() + "&token=" + token;
                url = RequestUtils.initOptProperties((String)url);
                model.addAttribute("url", (Object)url);
                model.addAttribute("downloadUrl", (Object)url);
                model.addAttribute("fid", (Object)node.getId());
                model.addAttribute("token", (Object)token);
                model.addAttribute("proid", (Object)proid);
                model.addAttribute("node", (Object)node);
                model.addAttribute("fileCenterUrl", (Object)RequestUtils.initOptProperties((String)AppConfig.getFileCenterUrl()));
                String viewXmlUrl = AppConfig.getFileCenterUrl() + "/node/preview.do?nid=" + node.getId() + "&token=" + token;
                viewXmlUrl = AppConfig.getProperty((String)"portal.url") + "/fileCenter/previewXml?nodeId=" + node.getId() + "&token=" + token + "&hasChildNode=" + hasChildNode;
                viewXmlUrl = RequestUtils.initOptProperties((String)viewXmlUrl);
                if (StringUtils.startsWith((String)viewXmlUrl, (String)"http://")) {
                    viewXmlUrl = StringUtils.replace((String)viewXmlUrl, (String)"http://", (String)"epre://");
                }
                model.addAttribute("viewXmlUrl", (Object)viewXmlUrl);
                response.sendRedirect(viewXmlUrl);
                return null;
            }
            return "fileCenter/file-view";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "fileCenter/file-view-error";
        }
    }

    @RequestMapping(value={"previewXml"})
    @ResponseBody
    public void previewXml(Model model, Integer nodeId, String token, String hasChildNode, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element files = doc.addElement("files");
        if (nodeId != null) {
            List nodes = new ArrayList();
            nodes = StringUtils.isNotBlank((String)hasChildNode) && StringUtils.equalsIgnoreCase((String)hasChildNode, (String)"true") ? this.nodeService.getAllChildNodes(nodeId) : this.nodeService.getChildNodes(nodeId);
            if (nodes != null) {
                for (Node node : nodes) {
                    if (!(node instanceof com.gtis.fileCenter.model.impl.File)) continue;
                    StringBuilder url = new StringBuilder(AppConfig.getFileCenterUrl() + "/file/get.do");
                    if (StringUtils.isNotEmpty((String)token)) {
                        url.append("?token=").append(token).append("&");
                    } else {
                        url.append(";jsessionid=").append(request.getSession().getId()).append("?");
                    }
                    url.append("fid=").append(node.getId()).append("&inline=true");
                    Element file = files.addElement("file").addAttribute("name", node.getViewName() == null ? node.getName() : node.getViewName()).addAttribute("url", RequestUtils.initOptProperties((String)url.toString()));
                    if (!node.getId().equals(nodeId)) continue;
                    file.addAttribute("iscurrent", "true");
                }
            }
        }
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(doc.asXML());
        response.getWriter().flush();
    }

    @RequestMapping(value={"autoRelFile"})
    @ResponseBody
    public Object autoRelFile(Model model, String fromProid, String toProid, boolean cover) throws Exception {
        if (StringUtils.isNotBlank((String)fromProid) && StringUtils.isNotBlank((String)toProid)) {
            try {
                Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
                Node leftNode = this.nodeService.getNode(space.getId(), fromProid, true);
                if (leftNode != null) {
                    HashMap leftMap = this.fileNodeOneChildToNameMap(leftNode.getId(), this.nodeService);
                    HashMap newMap = new HashMap();
                    Node rightNode = this.nodeService.getNode(space.getId(), toProid, true);
                    if (rightNode != null) {
                        HashMap rightMap = this.fileNodeOneChildToNameMap(rightNode.getId(), this.nodeService);
                        rightMap.put(rightNode.getId(), rightNode);
                        for (Map.Entry entry : leftMap.entrySet()) {
                            Node leftChild = (Node)entry.getValue();
                            if (!rightMap.containsKey(leftChild.getName())) continue;
                            Node rightChild = (Node)rightMap.get(leftChild.getName());
                            List tmpChildList = this.nodeService.getChildNodes(leftChild.getId());
                            if (tmpChildList == null || tmpChildList.size() <= 0) continue;
                            Integer[] curNodes = null;
                            curNodes = new Integer[tmpChildList.size()];
                            for (int i = 0; i < tmpChildList.size(); ++i) {
                                curNodes[i] = ((Node)tmpChildList.get(i)).getId();
                            }
                            this.nodeService.copy(curNodes, rightChild.getId(), cover);
                        }
                    }
                }
                return this.handlerSuccessJson();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.handlerErrorJson("\u64cd\u4f5c\u5931\u8d25\uff01");
    }
}

