/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.support.hibernate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.persistence.Column;
import org.apache.commons.lang.ObjectUtils;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;
import org.jboss.logging.Logger;
import org.springframework.util.ReflectionUtils;

public class JSONType
implements UserType,
DynamicParameterizedType,
Serializable {
    public static final String TYPE = "cn.gtmap.onemap.core.support.hibernate.JSONType";
    public static final String CLASS_NAME = "class";
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)JSONType.class.getName());
    private static final long serialVersionUID = 9015678551160115883L;
    private int sqlType = 12;
    private Class clazz = Object.class;
    private Type type = this.clazz;

    public int[] sqlTypes() {
        return new int[]{this.sqlType};
    }

    public Class returnedClass() {
        return this.clazz;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return ObjectUtils.equals((Object)x, (Object)y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Object object = rs.getObject(names[0]);
        if (rs.wasNull()) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Returning null as column {0}", (Object)names[0]);
            }
            return null;
        }
        return JSON.parseObject((String)((String)object), (Type)this.type, (Feature[])new Feature[0]);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Binding null to parameter: {0}", (Object)index);
            }
            st.setNull(index, this.sqlType);
        } else {
            st.setObject(index, (Object)JSON.toJSONString((Object)value), this.sqlType);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value instanceof JSONObject) {
            return ((JSONObject)value).clone();
        }
        if (value instanceof Cloneable) {
            return ObjectUtils.clone((Object)value);
        }
        if (value instanceof Serializable) {
            return SerializationHelper.clone((Serializable)((Serializable)value));
        }
        return value;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public void setParameterValues(Properties parameters) {
        try {
            this.clazz = ReflectHelper.classForName((String)parameters.getProperty("org.hibernate.type.ParameterType.entityClass"));
            Field field = ReflectionUtils.findField((Class)this.clazz, (String)parameters.getProperty("org.hibernate.type.ParameterType.propertyName"));
            this.type = field.getGenericType();
            this.parseSqlType(field.getAnnotations());
            return;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            DynamicParameterizedType.ParameterType reader = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
            if (reader != null) {
                this.clazz = reader.getReturnedClass();
                this.parseSqlType(reader.getAnnotationsMethod());
            } else {
                try {
                    this.clazz = ReflectHelper.classForName((String)((String)parameters.get(CLASS_NAME)));
                }
                catch (ClassNotFoundException exception) {
                    throw new HibernateException("class not found", (Throwable)exception);
                }
            }
            return;
        }
    }

    private void parseSqlType(Annotation[] anns) {
        for (Annotation an : anns) {
            if (!(an instanceof Column)) continue;
            int length = ((Column)an).length();
            if (length <= 4000) break;
            this.sqlType = 2005;
            break;
        }
    }
}

