/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.server.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.server.OverTimeRemindDao;
import com.gtis.portal.entity.BdcCqtxjl;
import com.gtis.portal.entity.QBdcCqtxjl;
import com.gtis.portal.service.server.OverTimeRemindService;
import com.gtis.portal.util.QueryCondition;
import com.gtis.portal.util.WorkFlowXml;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OverTimeRemindServiceImpl
implements OverTimeRemindService {
    @Autowired
    OverTimeRemindDao overTimeRemindDao;
    @Resource(name="serverBaseDaoImpl")
    BaseDao baseDao;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;

    public Page<BdcCqtxjl> queryBdcCqtxjlList(String wdid, String jdmc, QPageRequest pageable) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank((String)wdid)) {
            expression = QBdcCqtxjl.bdcCqtxjl.gzlid.eq((Object)wdid);
        }
        if (StringUtils.isNotBlank((String)jdmc)) {
            expression = expression == null ? QBdcCqtxjl.bdcCqtxjl.jdmc.eq((Object)jdmc) : expression.and((Predicate)QBdcCqtxjl.bdcCqtxjl.jdmc.eq((Object)jdmc));
        }
        return this.overTimeRemindDao.findAll((Predicate)expression, (Pageable)pageable);
    }

    public BdcCqtxjl getBdcCqtxjlByWdidAndJdid(String gzlid, String jdid) {
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = null;
        QueryCondition queryCondition1 = null;
        if (StringUtils.isNotEmpty((String)gzlid)) {
            queryCondition = new QueryCondition("gzlid", "=", (Object)gzlid);
        }
        if (StringUtils.isNotEmpty((String)gzlid)) {
            queryCondition1 = new QueryCondition("jdid", "=", (Object)jdid);
        }
        queryConditions.add(queryCondition);
        queryConditions.add(queryCondition1);
        List bdcCqtxjlList = this.baseDao.get(BdcCqtxjl.class, queryConditions);
        if (CollectionUtils.isNotEmpty((Collection)bdcCqtxjlList)) {
            return (BdcCqtxjl)bdcCqtxjlList.get(0);
        }
        return null;
    }

    public void save(BdcCqtxjl bdcCqtxjl) {
        if (StringUtils.isBlank((String)bdcCqtxjl.getTxjlid())) {
            bdcCqtxjl.setTxjlid(UUIDGenerator.generate());
        }
        if (StringUtils.isNotBlank((String)bdcCqtxjl.getGzlid())) {
            bdcCqtxjl.setGzlmc(this.sysWorkFlowDefineService.getWorkFlowDefine(bdcCqtxjl.getGzlid()).getWorkflowName());
        }
        if (StringUtils.isNotBlank((String)bdcCqtxjl.getJdid())) {
            String xml;
            List activityModelList = new ArrayList();
            if (StringUtils.isNotBlank((String)bdcCqtxjl.getGzlid()) && StringUtils.isNotBlank((String)(xml = this.sysWorkFlowDefineService.getWorkFlowDefineXml(bdcCqtxjl.getGzlid())))) {
                WorkFlowXml modelXml = new WorkFlowXml(xml);
                activityModelList = modelXml.getActivityList();
            }
            if (CollectionUtils.isNotEmpty(activityModelList)) {
                for (ActivityModel activityModel : activityModelList) {
                    if (activityModel == null || !StringUtils.equals((String)activityModel.getDefineId(), (String)bdcCqtxjl.getJdid())) continue;
                    bdcCqtxjl.setJdmc(activityModel.getActivityDefineName());
                }
            }
        }
        this.baseDao.save((Object)bdcCqtxjl);
    }

    public void delBdcCqtxjl(String id) {
        this.baseDao.delete(BdcCqtxjl.class, (Object)id);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public BdcCqtxjl getBdcCqtxjl(String gzlid) {
        return (BdcCqtxjl)this.baseDao.getById(BdcCqtxjl.class, (Object)gzlid);
    }
}

