/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.BdcXm;
import com.gtis.portal.service.TaskCenterService;
import com.gtis.portal.service.server.BdcXmService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class TaskCenterServiceImpl
implements TaskCenterService {
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    BdcXmService bdcXmService;

    @Cacheable(value={"taskCenterCache"}, key="#userInfo.id+'handleTaskOverListDisplay'")
    public boolean handleTaskOverListDisplay(UserInfo userInfo) {
        String taskOverListDisplay = AppConfig.getProperty((String)"taskOverList.display.role");
        boolean taskOverListDisplayed = false;
        if (StringUtils.isBlank((String)taskOverListDisplay) || userInfo.isAdmin()) {
            taskOverListDisplayed = true;
        } else {
            ArrayList roles = Lists.newArrayList((Object[])taskOverListDisplay.split(","));
            List roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (!roles.contains(pfRoleVo.getRoleId())) continue;
                    taskOverListDisplayed = true;
                    break;
                }
            }
        }
        return taskOverListDisplayed;
    }

    @Cacheable(value={"taskCenterCache"}, key="#userInfo.id+'handleProjectListDisplay'")
    public boolean handleProjectListDisplay(UserInfo userInfo) {
        String projectListDisplay = AppConfig.getProperty((String)"projectList.display.role");
        boolean projectListDisplayed = false;
        if (StringUtils.isBlank((String)projectListDisplay) || userInfo.isAdmin()) {
            projectListDisplayed = true;
        } else {
            ArrayList roles = Lists.newArrayList((Object[])projectListDisplay.split(","));
            List roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (!roles.contains(pfRoleVo.getRoleId())) continue;
                    projectListDisplayed = true;
                    break;
                }
            }
        }
        return projectListDisplayed;
    }

    @Cacheable(value={"taskCenterCache"}, key="#userInfo.id+'handleProjectListFilterUserid'")
    public boolean handleProjectListFilterUserid(UserInfo userInfo) {
        String projectListFilterUserid = AppConfig.getProperty((String)"projectList.filter.userid.role");
        boolean projectListFilter = false;
        if (StringUtils.isBlank((String)projectListFilterUserid) || userInfo.isAdmin()) {
            projectListFilter = false;
        } else {
            ArrayList roles = Lists.newArrayList((Object[])projectListFilterUserid.split(","));
            List roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (!roles.contains(pfRoleVo.getRoleId())) continue;
                    projectListFilter = true;
                    break;
                }
            }
        }
        return projectListFilter;
    }

    @Cacheable(value={"taskCenterCache"}, key="#userInfo.id+'handleOverTimeTaskListDisplay'")
    public boolean handleOverTimeTaskListDisplay(UserInfo userInfo) {
        String overTimeTaskListDisplay = AppConfig.getProperty((String)"overTimeList.display.role");
        boolean overTimeTaskListDisplayed = false;
        if (StringUtils.isBlank((String)overTimeTaskListDisplay) || userInfo.isAdmin()) {
            overTimeTaskListDisplayed = true;
        } else {
            ArrayList roles = Lists.newArrayList((Object[])overTimeTaskListDisplay.split(","));
            List roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (!roles.contains(pfRoleVo.getRoleId())) continue;
                    overTimeTaskListDisplayed = true;
                    break;
                }
            }
        }
        return overTimeTaskListDisplayed;
    }

    @Cacheable(value={"taskCenterCache"}, key="#userInfo.id+'handlePersonalProjectListDisplay'")
    public boolean handlePersonalProjectListDisplay(UserInfo userInfo) {
        String personalProjectListDisplay = AppConfig.getProperty((String)"personalProjectList.display.role");
        boolean personalProjectListDisplayed = false;
        if (StringUtils.isBlank((String)personalProjectListDisplay) || userInfo.isAdmin()) {
            personalProjectListDisplayed = true;
        } else {
            ArrayList roles = Lists.newArrayList((Object[])personalProjectListDisplay.split(","));
            List roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (!roles.contains(pfRoleVo.getRoleId())) continue;
                    personalProjectListDisplayed = true;
                    break;
                }
            }
        }
        return personalProjectListDisplayed;
    }

    @Cacheable(value={"taskCenterCache"}, key="#userInfo.id+'delTaskBtnDisplay'")
    public boolean delTaskBtnDisplay(UserInfo userInfo) {
        String delTaskBtnDisplayRole = AppConfig.getProperty((String)"task.list.del.role");
        boolean delTaskBtnListDisplayed = false;
        if (StringUtils.isBlank((String)delTaskBtnDisplayRole) || userInfo.isAdmin()) {
            delTaskBtnListDisplayed = true;
        } else {
            ArrayList roles = Lists.newArrayList((Object[])delTaskBtnDisplayRole.split(","));
            List roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (!roles.contains(pfRoleVo.getRoleId())) continue;
                    delTaskBtnListDisplayed = true;
                    break;
                }
            }
        }
        return delTaskBtnListDisplayed;
    }

    public boolean batchTurnTaskBtnDisplay(UserInfo userInfo) {
        String batchTurnBtnDisplayRole = AppConfig.getProperty((String)"taskList.batchTurn.display.role");
        boolean batchTurnBtnDListDisplayed = false;
        if (StringUtils.isBlank((String)batchTurnBtnDisplayRole)) {
            batchTurnBtnDListDisplayed = false;
        } else {
            ArrayList roles = Lists.newArrayList((Object[])batchTurnBtnDisplayRole.split(","));
            List roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (!roles.contains(pfRoleVo.getRoleId())) continue;
                    batchTurnBtnDListDisplayed = true;
                    break;
                }
            }
        }
        return batchTurnBtnDListDisplayed;
    }

    @Cacheable(value={"taskCenterCache"}, key="#userInfo.id+'handleTurnTaskListDisplay'")
    public boolean handleTurnTaskListDisplay(UserInfo userInfo) {
        String turnTaskListDisplay = AppConfig.getProperty((String)"turnTaskList.display.role");
        boolean turnTaskListDisplayed = false;
        if (StringUtils.isBlank((String)turnTaskListDisplay) || userInfo.isAdmin()) {
            turnTaskListDisplayed = true;
        } else {
            ArrayList roles = Lists.newArrayList((Object[])turnTaskListDisplay.split(","));
            List roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (!roles.contains(pfRoleVo.getRoleId())) continue;
                    turnTaskListDisplayed = true;
                    break;
                }
            }
        }
        return turnTaskListDisplayed;
    }

    @Cacheable(value={"taskCenterCache"}, key="#wiid+'overTimeState'")
    public Map getTaskOverTimeState(String wiid) {
        Map overTimeMap = Maps.newHashMap();
        String getOverTimeUrl = AppConfig.getProperty((String)"task.show.overTimeState.url");
        if (StringUtils.isNotBlank((String)getOverTimeUrl)) {
            try {
                HashMap param = Maps.newHashMap();
                param.put("wiid", wiid);
                Object obj = this.restTemplate.getForObject(getOverTimeUrl, String.class, (Map)param);
                if (obj != null) {
                    overTimeMap = (Map)JSONObject.parse((String)obj.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        overTimeMap.put("wiid", wiid);
        return overTimeMap;
    }

    @Cacheable(value={"taskCenterCache"}, key="#wiid+'xmly'")
    public Map getXmly(String wiid) {
        HashMap xmlyMap = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)wiid)) {
            try {
                List bdcXmList = this.bdcXmService.getBdcXmList(wiid);
                if (CollectionUtils.isNotEmpty((Collection)bdcXmList)) {
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((BdcXm)bdcXmList.get(0)).getYhsqywh())) {
                        xmlyMap.put("xmly", "\u94f6\u884c");
                    } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((BdcXm)bdcXmList.get(0)).getWwslbh())) {
                        xmlyMap.put("xmly", "\u4e00\u7a97\u53d7\u7406");
                    } else {
                        xmlyMap.put("xmly", "\u4e0d\u52a8\u4ea7");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        xmlyMap.put("wiid", wiid);
        return xmlyMap;
    }

    @Cacheable(value={"taskCenterCache"}, key="#userInfo.id+'handlePostTaskListDisplay'")
    public boolean handlePostTaskListDisplay(UserInfo userInfo) {
        String postTaskListDisplay = AppConfig.getProperty((String)"postTaskList.display.role");
        boolean postTaskListDisplayed = false;
        if (StringUtils.isBlank((String)postTaskListDisplay) || userInfo.isAdmin()) {
            postTaskListDisplayed = true;
        } else {
            ArrayList roles = Lists.newArrayList((Object[])postTaskListDisplay.split(","));
            List roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (!roles.contains(pfRoleVo.getRoleId())) continue;
                    postTaskListDisplayed = true;
                    break;
                }
            }
        }
        return postTaskListDisplayed;
    }

    @Cacheable(value={"taskCenterCache"}, key="#userInfo.id+'handleTaskDeleteOtherTask'")
    public boolean handleTaskDeleteOtherTask(UserInfo userInfo) {
        String deleteOtherTaskRoles = AppConfig.getProperty((String)"task.taskHandle.deleteOtherTask.role");
        boolean deleteOtherTaskEnable = false;
        ArrayList roles = Lists.newArrayList((Object[])deleteOtherTaskRoles.split(","));
        List roleVoList = userInfo.getLstRole();
        if (roleVoList != null) {
            for (PfRoleVo pfRoleVo : roleVoList) {
                if (!roles.contains(pfRoleVo.getRoleId())) continue;
                deleteOtherTaskEnable = true;
                break;
            }
        }
        return deleteOtherTaskEnable;
    }
}

