/*
 * Project:  onemap
 * Module:   server
 * File:     IndexConfigController.java
 * Modifier: xyang
 * Modified: 2013-05-23 08:48:17
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */
package com.gtis.portal.web.editor;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.PfResource;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;


@Controller
public class ResourceEditorController {
    @Autowired
    PfMenuService menuService;

    @Autowired
    PfResourceService resourceService;

    @RequestMapping("/editor/resource")
    public String enter(@RequestParam(value = "menuId", required = false) String menuId,Model model) {

        model.addAttribute("menuId", menuId);
        return "/editor/menu-resource";
    }

    @ModelAttribute("resource")
    public PfResource getResource(@RequestParam(value = "menuId", required = false) String menuId,@RequestParam(value = "rid", required = false) String rid) {
        PfResource resource=new PfResource();
        if (StringUtils.isNotBlank(rid))
            resource= resourceService.getResource(rid);
        else if (StringUtils.isNotBlank(menuId)){
            PfMenu menu=menuService.getMenu(menuId);
            if (StringUtils.isNotBlank(menu.getResourceId()))
                resource= resourceService.getResource(menu.getResourceId());
        }
         return resource;
    }

    @RequestMapping("/editor/resource/save")
    @ResponseBody
    public String save(@ModelAttribute("resource") PfResource resource, @RequestParam(value = "menuId", required = false) String menuId,Model model){
        if (StringUtils.isNotBlank(resource.getResourceId()))
            resourceService.updateResource(resource);
        else{
            String rid= UUIDGenerator.generate();
            resource.setResourceId(rid);
            resourceService.insertResource(resource);
            //保存菜单关系
            PfMenu menu=menuService.getMenu(menuId);
            menu.setResourceId(rid);
            menuService.updateMenu(menu);
        }
        return null;
    }


}