package com.gtis.portal.web.config;


import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.model.PageImpl;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.entity.BdcZdpjjlAll;
import com.gtis.portal.service.server.AutoTurnAllTaskService;
import com.gtis.portal.web.BaseController;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 自动转发配置
 *
 * @author <a href="mailto:shenfei@gtmap.cn">shenfei</a>
 * @version 1.0, 2019/6/21
 */
@Controller
@RequestMapping("/autoTurnAllTask")
public class AutoTurnAllTaskController extends BaseController {
    private static final Log log = LogFactory.getLog(AutoTurnAllTaskController.class);

    @Autowired
    AutoTurnAllTaskService autoTurnAllTaskService;
    @Autowired
    SysUserService sysUserService;

    @RequestMapping("")
    public String autoTurnAllTask(Model model) throws Exception {
        List<PfUserVo> pfUserVoList = sysUserService.getAllUsers();
        if (CollectionUtils.isNotEmpty(pfUserVoList)) {
            PfUserVo pfUserVo = new PfUserVo();
            pfUserVo.setUserName("全部");
            pfUserVo.setUserId("");
            pfUserVoList.add(0, pfUserVo);
        }
        model.addAttribute("pfUserVoList", pfUserVoList);
        return "config/auto-turn-alltask";
    }

    @ResponseBody
    @RequestMapping("/getAutoTurnAllTaskPagesJson")
    public Object getAutoTurnAllTaskPagesJson(Pageable pageable, String userid, String kqzt, @RequestParam(value = "number", required = false) String number, @RequestParam(value = "currentPage", required = false) String currentPage) {
        int pageNumber = pageable.getPageNumber();
        if (currentPage != null)
            pageNumber = Integer.parseInt(currentPage) - 1;
        QPageRequest pageable1 = new QPageRequest(pageNumber, 10);
        org.springframework.data.domain.Page<BdcZdpjjlAll> bdcZdpjjlallPage = autoTurnAllTaskService.queryBdcZdpjjlallList(userid, kqzt, pageable1);
        Page<BdcZdpjjlAll> bdcZdpjjlPage1 = null;
        if (bdcZdpjjlallPage != null) {
            bdcZdpjjlPage1 = new PageImpl(bdcZdpjjlallPage.getContent(), pageNumber + 1, Integer.parseInt(bdcZdpjjlallPage.getTotalElements() + ""), 10);
        }
        return bdcZdpjjlPage1;
    }

    @ResponseBody
    @RequestMapping("/getBdcZdpjjlAll")
    public Object getBdcZdpjjlAll(String id) {
        BdcZdpjjlAll bdcZdpjjlAll = null;
        if (StringUtils.isNotBlank(id))
            bdcZdpjjlAll = autoTurnAllTaskService.getBdcZdpjjl(id);
        if (bdcZdpjjlAll == null)
            bdcZdpjjlAll = new BdcZdpjjlAll();

        return bdcZdpjjlAll;
    }


    @ResponseBody
    @RequestMapping("/getYhList")
    public Object getYhList() {
        Map map = Maps.newHashMap();
        List<PfUserVo> pfUserVoList = sysUserService.getAllUsers();
        map.put("yhList", pfUserVoList);
        return map;
    }

    @ResponseBody
    @RequestMapping("/save")
    public Object save(BdcZdpjjlAll bdcZdpjjlAll) {
        String msg = "true";
        try {
            BdcZdpjjlAll bdcZdpjjl1 = autoTurnAllTaskService.getBdcZdpjjlByWdidAndJdidAndYhid(bdcZdpjjlAll.getYhid());
            if (bdcZdpjjl1 != null && !StringUtils.equals(bdcZdpjjl1.getPjjlid(), bdcZdpjjlAll.getPjjlid())) {
                msg = "数据库存在该类型数据！";
                return URLEncoder.encode(msg);
            }
            autoTurnAllTaskService.save(bdcZdpjjlAll);
        } catch (Exception e) {
            msg = "保存不成功！";
        }

        return URLEncoder.encode(msg);
    }

    @ResponseBody
    @RequestMapping(value = "del")
    public HashMap del(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (org.apache.commons.lang3.StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        autoTurnAllTaskService.delBdcZdpjjl(id);
                } else
                    autoTurnAllTaskService.delBdcZdpjjl(ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }


    @ResponseBody
    @RequestMapping("/batSaveKqzt")
    public Object batSaveKqzt(String userid, String kqzt, @RequestParam(value = "batKqzt", required = false) String batKqzt, @RequestParam(value = "ids", required = false) String ids) {
        String msg = "true";
        List<BdcZdpjjlAll> bdcZdpjjlList = Lists.newArrayList();
        if (StringUtils.isNotBlank(ids)) {
            String[] idStrs = ids.split(",");
            for (String id : idStrs) {
                BdcZdpjjlAll bdcZdpjjl = autoTurnAllTaskService.getBdcZdpjjl(id);
                if (bdcZdpjjl != null)
                    bdcZdpjjlList.add(bdcZdpjjl);
            }
        } else
            bdcZdpjjlList = autoTurnAllTaskService.queryBdcZdpjjlList(userid, kqzt);
        if (CollectionUtils.isNotEmpty(bdcZdpjjlList)) {
            for (BdcZdpjjlAll bdcZdpjjl : bdcZdpjjlList) {
                bdcZdpjjl.setKqzt(batKqzt);
                autoTurnAllTaskService.save(bdcZdpjjl);
            }
        }
        return msg;
    }
}
