package com.gtis.portal.web;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.entity.PfWorkFlowEvent;
import com.gtis.portal.service.server.PfWorkFlowEventConfigurationService;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;


/**
 * 工作流事件执行的方法
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/workFlowEvent")
public class WorkFlowEventController extends BaseController {
    @Autowired
    PfWorkFlowEventConfigurationService pfWorkFlowEventConfigurationService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    private final static int PAGE_SIZE = 10;

    @RequestMapping("/list")
    public String list(Model model) {
        List<PfBusinessVo> businessVoList = sysWorkFlowDefineService.getBusinessList();
        model.addAttribute("businessList", businessVoList != null ? businessVoList : Lists.newArrayList());
        return "workFlowEvent-list";
    }

    @ResponseBody
    @RequestMapping("/initEventList")
    public Object initWorkFlowEventList(String id, String workflowDefinitionId, String dcxc, Pageable page) {
        Page<PfWorkFlowEvent> pfWorkFlowEventPage = null;
        int size = (page == null) ? PAGE_SIZE : page.getPageSize();
        int pagenum = (page == null) ? 1 : page.getPageNumber();
        JSONObject json = new JSONObject();
        try {
            page = new PageRequest(pagenum, size, Sort.Direction.DESC, "id");
            String workFlowName = null;
            if (StringUtils.isNotBlank(dcxc)) {
                workFlowName = dcxc;
            }
            pfWorkFlowEventPage = pfWorkFlowEventConfigurationService.listPfWorkFlowEventPage(workflowDefinitionId, workFlowName, page);
            if (pfWorkFlowEventPage == null) {
                return null;
            }
            json.put("rows", pfWorkFlowEventPage.getContent());
            json.put("total", pfWorkFlowEventPage.getTotalPages());
            json.put("records", pfWorkFlowEventPage.getTotalElements());
            json.put("page", pfWorkFlowEventPage.getNumber() + 1);
            json.put("pageSize", pfWorkFlowEventPage.getSize());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    @ResponseBody
    @RequestMapping("/addWorkFlowEvent")
    public Object addWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        boolean result = Boolean.TRUE;
        try {
            if (pfWorkFlowEvent == null) {
                result = Boolean.FALSE;
                return result;
            }
            pfWorkFlowEventConfigurationService.addPfWorkFlowEvent(pfWorkFlowEvent);
        } catch (Exception e) {
            result = Boolean.FALSE;
        }
        return result;
    }

    @ResponseBody
    @RequestMapping("/modifyWorkFlowEvent")
    public Object modifyWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        boolean result = Boolean.TRUE;
        try {
            if (pfWorkFlowEvent == null) {
                result = Boolean.FALSE;
                return result;
            }
            pfWorkFlowEventConfigurationService.updatePfWorkFlowEvent(pfWorkFlowEvent);
        } catch (Exception e) {
            result = Boolean.FALSE;
        }
        return result;
    }


    @ResponseBody
    @RequestMapping("/deleteWorkFlowEvent")
    public Object deleteWorkFlowEvent(String id) {
        boolean result = Boolean.TRUE;
        try {
            if (StringUtils.isBlank(id)) {
                result = Boolean.FALSE;
                return result;
            }
            pfWorkFlowEventConfigurationService.deletePfWorkFlowEventById(id.split(","));
        } catch (Exception e) {
            result = Boolean.FALSE;
        }
        return result;
    }

    @ResponseBody
    @RequestMapping("/getWorkFlowEvent")
    public Object getWorkFlowEvent(String id) {
        Map maps= Maps.newHashMap();
        PfWorkFlowEvent pfWorkFlowEvent = null;
        String businessId = "";
        String businessName = "";
        try {
            if (StringUtils.isNotBlank(id)) {
                pfWorkFlowEvent = pfWorkFlowEventConfigurationService.getPfWorkFlowEvent(id);
                if(pfWorkFlowEvent!=null) {
                    PfWorkFlowDefineVo pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(pfWorkFlowEvent.getWorkFlowDefinitionId());
                    if (pfWorkFlowDefineVo != null) {
                        businessId = pfWorkFlowDefineVo.getBusinessId();
                        PfBusinessVo pfBusinessVo = sysWorkFlowDefineService.getBusiness(businessId);
                        if (pfBusinessVo != null)
                            businessName = pfBusinessVo.getBusinessName();
                    }
                }
            }
        } catch (Exception e) {

        }
        if(pfWorkFlowEvent==null)
            pfWorkFlowEvent=new PfWorkFlowEvent();

        maps.put("pfWorkFlowEvent",pfWorkFlowEvent);
        maps.put("businessId",businessId);
        maps.put("businessName",businessName);
        return maps;
    }

    @ResponseBody
    @RequestMapping("/importWorkFlowEvent")
    public Object importWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        return pfWorkFlowEventConfigurationService.importPfWorkFlowEvent(pfWorkFlowEvent);
    }

    @ResponseBody
    @RequestMapping("/cleanWorkFlowEvent")
    public Object cleanWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        return pfWorkFlowEventConfigurationService.cleanWorkFlowEvent(pfWorkFlowEvent);
    }

    @ResponseBody
    @RequestMapping("/batchImportPfWorkFlowEvent")
    public Object batchImportPfWorkFlowEvent() {
        return pfWorkFlowEventConfigurationService.batchImportPfWorkFlowEvent();
    }

}
