package com.gtis.portal.web;

import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.RiskModel;
import com.gtis.portal.model.Menu;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * 任务办理中心
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/taskOverHandle")
public class TaskOverHandleController {
    @Autowired
    SysWorkFlowDefineService workFlowDefineService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    SysAuthorService sysAuthorService;
    @Autowired
    SysActivityService sysActivityService;

    @RequestMapping("")
    public String taskHandle(Model model, @RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "rid", required = false) String rid) throws Exception {
        String fileTokenId = "";
        int fileCenterNodeId = 0;
        String defaultName = "";
        String busiType = "";
        String readOnly = "";
        String userid = SessionUtil.getCurrentUserId();
        boolean canDelOthers = false;
        int menuCount = 0;
        PfTaskVo taskVo;
        PfActivityVo activityVo;
        PfWorkFlowInstanceVo workFlowInstanceVo = null;
        PfWorkFlowDefineVo workFlowDefineVo;
        List<Menu> menuList = null;
        if (StringUtils.isBlank(rid))
            rid = "";
        model.addAttribute("rid", rid);
        if (StringUtils.isNotBlank(rid) && rid.startsWith("r:")) {
            rid = rid.replace("r:", "");
        }
        boolean showToolBar = AppConfig.getBooleanProperty("report.showtoolbar.enable", false);
        boolean disable = AppConfig.getBooleanProperty("taskOverList.handle.url.param.disable.enable", true);
        if (StringUtils.isNotBlank(taskid)) {
            taskVo = taskService.getHistoryTask(taskid);
            activityVo = taskService.getActivity(taskVo.getActivityId());
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
            workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());

            Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF, true);
            try {
                Node node = nodeService.getNode(space.getId(), activityVo.getWorkflowInstanceId(), false);
                if (node != null) {
                    fileTokenId = nodeService.getToken(node);
                    fileCenterNodeId = node.getId();
                }
            } catch (Exception ex) {

            }
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(workFlowDefineVo);
            ////////////////////////////////////////////////////////////
            //扩展属性中关于勘测定界管理模块的配置属性获取
            busiType = xmlDao.getExtendedAttribute("BusiType") + "";
            if (StringUtils.isBlank(busiType)) {
                busiType = xmlDao.getExtendedAttribute("busiType") + "";
            }

            WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
            //WorkFlowXml xmlModel=workFlowInstanceVo.getXmlModel();
            ActivityModel aModel = xmlModel.getActivity(activityVo.getActivityDefinitionId());
            defaultName = aModel.getExtendedAttribute("DefaultName");
            //取办理菜单
            String menuXml = aModel.getResources();
            String menuname = AppConfig.getProperty("show.report.showtoolbar.menuname");
            String hideMenuname = AppConfig.getProperty("hide.resource.menuname");
            if (StringUtils.isNotBlank(menuXml)) {
                menuXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + menuXml;
                Document document = DocumentHelper.parseText(menuXml);
                if (document != null) {
                    List resourceNodeList = document.selectNodes("//Resources/Resource");
                    if (resourceNodeList != null) {
                        menuList = new ArrayList<Menu>();
                        for (int i = 0; i < resourceNodeList.size(); i++) {
                            boolean showToolBarBol =showToolBar;
                            Element resourceEl = (Element) resourceNodeList.get(i);
                            Menu menu = new Menu();
                            menu.setId(resourceEl.attributeValue("Id"));
                            menu.setText(resourceEl.attributeValue("Name"));
                            if(StringUtils.indexOf(menuname,resourceEl.attributeValue("Name"))>-1)
                                showToolBarBol=true;
                            String firstLink = "/SysResource.action?disable="+disable+"&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + resourceEl.attributeValue("Id") + "&userid=" + userid + "&isProjectList=true&__showtoolbar__=" + showToolBarBol;
                            List childrenNodeList1 = document.getRootElement().selectNodes("//Resources/Resource[@Id='" + resourceEl.attributeValue("Id") + "']/Resource");
                            if (childrenNodeList1 != null && childrenNodeList1.size() > 0) {
                                Element childEl1 = (Element) childrenNodeList1.get(0);
                                firstLink = "/SysResource.action?disable="+disable+"&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl1.attributeValue("Id") + "&userid=" + userid + "&isProjectList=true&__showtoolbar__=" + showToolBarBol;
                            }
                            menu.setLink(firstLink);
                            List childrenNodeList = resourceEl.selectNodes("//Resources/Resource[@Id='" + resourceEl.attributeValue("Id") + "']/Resource");
                            if (childrenNodeList != null && childrenNodeList.size() > 0) {
                                List<Menu> childMenuList = new ArrayList<Menu>();
                                for (int j = 1; j < childrenNodeList.size(); j++) {
                                    Menu childMenu = new Menu();
                                    Element childEl = (Element) childrenNodeList.get(j);
                                    childMenu.setId(childEl.attributeValue("Id"));
                                    childMenu.setText(childEl.attributeValue("Name"));

                                    String firstChildLink = "/SysResource.action?disable="+disable+"&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl.attributeValue("Id") + "&isProjectList=true&__showtoolbar__=" + showToolBar;
                                    List childChildNodeList = resourceEl.selectNodes("//Resources/Resource[@Id='" + resourceEl.attributeValue("Id") + "']/Resource[@Id='" + childEl.attributeValue("Id") + "']/Resource");
                                    if (childChildNodeList != null && childChildNodeList.size() > 0) {
                                        Element childEl1 = (Element) childChildNodeList.get(0);
                                        firstChildLink = "/SysResource.action?disable="+disable+"&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl1.attributeValue("Id") + "&isProjectList=true&__showtoolbar__=" + showToolBar;
                                    }
                                    childMenu.setLink(firstChildLink);


                                    if (childChildNodeList != null && childChildNodeList.size() > 0) {
                                        List<Menu> childChildMenuList = new ArrayList<Menu>();
                                        for (int k = 1; k < childChildNodeList.size(); k++) {
                                            Menu childChildMenu = new Menu();
                                            Element childChildEl = (Element) childChildNodeList.get(k);
                                            childChildMenu.setId(childChildEl.attributeValue("Id"));
                                            childChildMenu.setText(childChildEl.attributeValue("Name"));
                                            childChildMenu.setLink("/SysResource.action?disable="+disable+"&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childChildEl.attributeValue("Id") + "&isProjectList=true&__showtoolbar__=" + showToolBar);
                                            childChildMenuList.add(childChildMenu);
                                        }
                                        childMenu.setChildren(childChildMenuList);
                                    }

                                    childMenuList.add(childMenu);
                                }
                                menu.setChildren(childMenuList);
                                menu.setExpanded(true);
                            }
                            if(StringUtils.isBlank(hideMenuname) || StringUtils.indexOf(hideMenuname,menu.getText())<0)
                                menuList.add(menu);
                        }
                    }
                }
            }
        }
        if (workFlowInstanceVo == null)
            workFlowInstanceVo = new PfWorkFlowInstanceVo();
        if (menuList == null)
            menuList = new ArrayList<Menu>();

        boolean hasGetBack = false;
        if (SessionUtil.getCurrentUser().isAdmin()) {
            hasGetBack = true;
        } else {
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List<PfPartitionInfoVo> lstfPartitions = sysAuthorService.getSystemResrouceFunAuthorList(roles, rid);

            if (lstfPartitions != null) {

                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().endsWith("取回")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("resGetBack")) {
                        hasGetBack = true;
                        break;
                    }
                }
            }

            String acitivityName = AppConfig.getProperty("hide.getBack.btn.activityName");
            if (StringUtils.isNotBlank(acitivityName)) {
                //配置隐藏取回下一个节点名称
                List<PfTaskVo> pfTaskVoList = taskService.getTaskListByInstance(workFlowInstanceVo.getWorkflowIntanceId());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(pfTaskVoList)) {
                    for (PfTaskVo pfTaskVo : pfTaskVoList) {
                        if (StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                            PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                            if (pfActivityVo != null && StringUtils.indexOf(acitivityName, pfActivityVo.getActivityName()) > -1) {
                                hasGetBack = false;
                                break;
                            }
                        }
                    }
                }
            }
        }
        boolean tabControlEnable=AppConfig.getBooleanProperty("taskhandle.tab.control.enable", false);
        UserInfo userInfo = SessionUtil.getCurrentUser();
        model.addAttribute("username", userInfo.getUsername());
        model.addAttribute("userid",userInfo.getId());
        model.addAttribute("fileTokenId", fileTokenId);
        model.addAttribute("fileCenterNodeId", fileCenterNodeId);
        model.addAttribute("defaultName", defaultName);
        model.addAttribute("busiType", busiType);
        model.addAttribute("readOnly", readOnly);
        model.addAttribute("canDelOthers", canDelOthers);
        model.addAttribute("workFlowInstanceVo", workFlowInstanceVo);
        model.addAttribute("taskid", taskid);
        model.addAttribute("menuCount", menuCount);
        model.addAttribute("menuList", menuList);
        model.addAttribute("hasFileBrowse", AppConfig.getBooleanProperty("file.browse.enable", false));
        model.addAttribute("hasGetBack", hasGetBack);
        model.addAttribute("tabControlEnable", tabControlEnable);
        if(tabControlEnable)
            return "task-overHandle-tab-control";
        else
            return "task-overHandle";
    }

}
