package com.gtis.portal.web;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.portal.model.Menu;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 任务办理中心
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/projectHandle")
public class ProjectHandleController {
    @Autowired
    SysWorkFlowDefineService workFlowDefineService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    SysMenuService menuService;

    @Autowired
    SysAuthorService sysAuthorService;

    @RequestMapping("")
    public String taskHandle(Model model, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "rid", required = false) String rid, @RequestParam(value = "proid", required = false) String proid, @RequestParam(value = "wdno", required = false) String wdno) throws Exception {
        if (StringUtils.isBlank(rid) || StringUtils.equals(rid, "undefined"))
            rid = "";
        if (StringUtils.isNotBlank(rid) && rid.startsWith("r:")) {
            rid = rid.replace("r:", "");
        }
        String fileTokenId = "";
        int fileCenterNodeId = 0;
        String defaultName = "";
        String busiType = "";
        String readOnly = "";
        boolean disable = false;
        boolean hasPriority = false;
        hasPriority = hasPriorityVisible(rid);
        int menuCount = 0;
        PfWorkFlowInstanceVo workFlowInstanceVo;
        PfWorkFlowDefineVo workFlowDefineVo = null;
        List<Menu> menuList = null;
        String userid = SessionUtil.getCurrentUserId();
        boolean showToolBar = AppConfig.getBooleanProperty("report.showtoolbar.enable", false);

        if (wiid != null && !wiid.equals("")) {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(wiid);
        } else {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstanceByProId(proid);
        }
        if (workFlowInstanceVo != null) {
            workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
            wiid = workFlowInstanceVo.getWorkflowIntanceId();
        } else if (StringUtils.isNotBlank(wdno)) {
            workFlowDefineVo = workFlowDefineService.getWorkFlowByDefinitionNo(wdno);
        }
        if (workFlowDefineVo != null) {
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(workFlowDefineVo);
            disable = xmlDao.isDisable();
            ///////客户端用来获取附件////////////////////////////////////////
            Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF, true);
            try {
                Node node = null;
                if (StringUtils.isBlank(wiid))
                    node = nodeService.getNode(space.getId(), proid, true);
                else
                    node = nodeService.getNode(space.getId(), wiid, false);
                if (node != null) {
                    fileTokenId = nodeService.getToken(node);
                    fileCenterNodeId = node.getId();
                }
            } catch (Exception ex) {

            }
            disable = AppConfig.getBooleanProperty("projectList.handle.url.param.disable.enable", false);

            ////////////////////////////////////////////////////////////
            //扩展属性中关于勘测定界管理模块的配置属性获取
            busiType = xmlDao.getExtendedAttribute("BusiType") + "";
            if (StringUtils.isBlank(busiType)) {
                busiType = xmlDao.getExtendedAttribute("busiType") + "";
            }
            //取办理菜单
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            if (wiid != null && !wiid.equals("")) {
                workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(wiid);
            } else {
                workFlowInstanceVo = workFlowIntanceService.getWorkflowInstanceByProId(proid);
            }
            if (workFlowInstanceVo != null) {
                workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
            } else if (StringUtils.isNotBlank(wdno)) {
                workFlowDefineVo = workFlowDefineService.getWorkFlowByDefinitionNo(wdno);
            }
            List<PfResourceVo> lstResult = menuService.getProjectMenu(roles,
                    workFlowDefineVo.getWorkflowDefinitionId());
            String hideMenuname = AppConfig.getProperty("hide.resource.menuname");
            /**
             * 此处主要是存放已经插入的菜单，如果存在id和name相同的资源，则不再重复插入
             */
            HashMap<String, String> insertedMenuMap = new HashMap<String, String>();
            String menuname = AppConfig.getProperty("show.report.showtoolbar.menuname");
            if (lstResult != null) {
                menuList = new ArrayList<Menu>();
                for (int i = 0; i < lstResult.size(); i++) {
                    PfResourceVo menuVo = lstResult.get(i);
                    String tempKey = menuVo.getResourceId() + "_" + menuVo.getResourceName();
                    if (insertedMenuMap.get(tempKey) != null) {
                        continue;
                    }
                    insertedMenuMap.put(tempKey, tempKey);
                    Menu menu = new Menu();
                    menu.setId(menuVo.getResourceId());
                    String name = menuVo.getResourceName();
                    menu.setText(name);
                    boolean showToolBarBol = showToolBar;
                    if (StringUtils.indexOf(menuname, name) > -1)
                        showToolBarBol = true;
                    if (disable)
                        menu.setLink("/SysResource.action?from=pro&disable=true&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + wiid + "&rid=" + menuVo.getResourceId() + "&userid=" + userid + "&isProjectList=true&__showtoolbar__=" + showToolBarBol);
                    else
                        menu.setLink("/SysResource.action?proid=" + workFlowInstanceVo.getProId() + "&wiid=" + wiid + "&rid=" + menuVo.getResourceId() + "&userid=" + userid + "&isProjectList=true&__showtoolbar__=" + showToolBarBol);
                    if (StringUtils.isBlank(hideMenuname) || StringUtils.indexOf(hideMenuname, menu.getText()) < 0)
                        menuList.add(menu);
                }
            }
        }


        if (workFlowInstanceVo == null)
            workFlowInstanceVo = new PfWorkFlowInstanceVo();
        if (menuList == null)
            menuList = new ArrayList<Menu>();
        boolean tabControlEnable = AppConfig.getBooleanProperty("taskhandle.tab.control.enable", false);
        UserInfo userInfo = SessionUtil.getCurrentUser();
        model.addAttribute("username", userInfo.getUsername());
        model.addAttribute("userid", userInfo.getId());
        model.addAttribute("fileTokenId", fileTokenId);
        model.addAttribute("fileCenterNodeId", fileCenterNodeId);
        model.addAttribute("defaultName", defaultName);
        model.addAttribute("busiType", busiType);
        model.addAttribute("readOnly", readOnly);
        model.addAttribute("workFlowInstanceVo", workFlowInstanceVo);
        model.addAttribute("menuCount", menuCount);
        model.addAttribute("menuList", menuList);
        model.addAttribute("hasFileBrowse", AppConfig.getBooleanProperty("file.browse.enable", false));
        model.addAttribute("hasPriority", hasPriority);
        model.addAttribute("tabControlEnable", tabControlEnable);
        if (tabControlEnable)
            return "task-projectHandle-tab-control";
        else
            return "task-projectHandle";
    }

    /**
     * @param rid
     * @author : <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @date : 2019/5/22 17:37
     * @return:boolean
     * @Description : 权限控制表单页面的“调整优先级按钮是否显示”
     */
    private boolean hasPriorityVisible(String rid) {
        boolean hasPriority = false;
        if (SessionUtil.getCurrentUser().isAdmin()) {
            hasPriority = true;
        } else {
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List<PfPartitionInfoVo> lstfPartitions = sysAuthorService.getSystemResrouceFunAuthorList(roles, rid);
            if (lstfPartitions != null) {
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().endsWith("优先")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("priority")) {
                        hasPriority = true;
                        break;
                    }
                }
            }

        }
        return hasPriority;
    }

    /**
     * @param wiid 工作流实例
     * @return 节点名称
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 获取超期和剩余时间
     */
    @ResponseBody
    @RequestMapping("/getActivityNames")
    public Object getActivityNames(String wiid) {
        StringBuffer userNameBuffer = new StringBuffer();
        Map map = Maps.newHashMap();
        String activityName = "";
        String isOver = "false";
        if (StringUtils.isNotBlank(wiid)) {
            List<PfActivityVo> activityVoList = taskService.getWorkFlowInstanceActivityList(wiid);
            for (int i = 0; i < activityVoList.size(); i++) {
                if (i > 0) {
                    userNameBuffer.append(";");
                }
                try {
                    PfActivityVo activityVo = activityVoList.get(i);
                    activityName = activityVo.getActivityName();
                    userNameBuffer.append(activityVo.getActivityName());
                    String noComputeActivityNames = AppConfig.getProperty("overTime.noCompute.activityNames");
                    if (StringUtils.isNotBlank(noComputeActivityNames)) {
                        List<PfTaskVo> taskList = taskService.getTaskListByActivity(activityVo.getActivityId());
                        if (taskList != null && taskList.size() > 0) {
                            PfTaskVo taskVo = taskList.get(0);
                            if (taskVo.getOverTime().compareTo(CalendarUtil.getCurDate()) < 0) {
                                userNameBuffer.append("已超期");
                                isOver = "true";
                            } else {
                                long days = CalendarUtil.getDaysByTwoDate(CalendarUtil.getCurDate(), taskVo.getOverTime());
                                userNameBuffer.append("剩余" + days + "天");
                            }
                        }
                        if (i > 0) {
                            userNameBuffer.append("...");
                            break;
                        } else {
                            userNameBuffer.append("");
                        }
                    }
                } catch (Exception ex) {
                }
            }
        }
        map.put("activityDesc", userNameBuffer.toString());
        map.put("activityName", activityName);
        map.put("isOver", isOver);
        return map;
    }
}
