package com.gtis.portal.web;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.service.server.BdcSlbhService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.ClientInfoUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.ByteObjectAccess;
import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.dao.NewsDao;
import com.gtis.portal.entity.*;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.*;
import com.gtis.portal.service.impl.EnabledTurnStatusServiceContext;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.service.server.BdcZsService;
import com.gtis.portal.service.server.GjsqlxService;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.ReadXmlProps;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParamImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 信息发布
 *
 * @author <a href="mailto:shenfei@gtmap.cn">shenfei</a>
 * @version 1.0, 2019/5/31
 */
@Controller
@RequestMapping("/news")
public class NewsController {
    @Autowired
    private PfNewsService pfNewsService;
    private final static int PAGE_SIZE = 10;
    @Autowired
    NodeService nodeService;
    @Autowired
    LogService logService;

    /**
     * @param model
     * @author : <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @date : 2019-06-04 15:16
     * @return:java.lang.String
     * @Description :跳转到信息发布列表页
     */
    @RequestMapping("/list")
    public String list(Model model) throws Exception {

        return "newslist";
    }

    /**
     * @param model
     * @param page
     * @param dcxc
     * @param beginDate
     * @param endDate
     * @author : <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @date : 2019-06-04 15:17
     * @return:java.lang.Object
     * @Description : 加载列表页的数据
     */
    @ResponseBody
    @RequestMapping("/newsListPage")
    public Object newsListPage(Model model, Pageable page, String dcxc, String beginDate, String endDate) {

        Page<PfNews> newsListPage = null;
        int size = (page == null) ? PAGE_SIZE : page.getPageSize();
        int pagenum = (page == null) ? 1 : page.getPageNumber();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date beginTime = null;
        Date endTime = null;
        try {
            if (StringUtils.isNotBlank(beginDate)) {
                beginTime = sdf.parse(beginDate);
            }
            if (StringUtils.isNotBlank(endDate)) {
                endTime = sdf.parse(endDate);
            }
            page = new PageRequest(pagenum, size, Sort.Direction.DESC, "newdate");
            newsListPage = pfNewsService.queryNewsList(dcxc, beginTime, endTime, page);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (newsListPage == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("rows", newsListPage.getContent());
        json.put("total", newsListPage.getTotalPages());
        json.put("records", newsListPage.getTotalElements());
        json.put("page", newsListPage.getNumber() + 1);
        json.put("pageSize", newsListPage.getSize());
        return json;
    }

    /**
     * @param pfNews
     * @author : <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @date : 2019-06-04 15:17
     * @return:java.lang.Object
     * @Description : 删除信息发布
     */
    @ResponseBody
    @RequestMapping("/deleteNews")
    public Object deleteNews(PfNews pfNews, HttpServletRequest request) {

        boolean result = false;
        if (pfNews != null && StringUtils.isNotBlank(pfNews.getNewid())) {
            pfNewsService.deleteNews(pfNews);
            //保存日志
            logService.saveLog(request, SessionUtil.getCurrentUserId(),  "用户删除" + pfNews.getNewid(), "删除信息发布");
            result = true;
        }
        return result;
    }

    /**
     * @param pfNews
     * @param request
     * @author : <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @date : 2019-06-04 15:18
     * @return:java.lang.Object
     * @Description : 信息发布的保存操作
     */
    @ResponseBody
    @RequestMapping("/createNews")
    public Object createNews(PfNews pfNews, HttpServletRequest request) {

        Map<String, Object> result = new HashMap<String, Object>(3);
        try {
            if (StringUtils.isBlank(pfNews.getNewid())) {
                String newId = UUIDGenerator.generate18();
                Space space = nodeService.getWorkSpace(Constants.MESSAGE_FILE, true);
                Node msgNode = nodeService.getNode(space.getId(), newId, true);
                Integer nodeId = msgNode.getId();
                String token = nodeService.getToken(msgNode);
                result.put("newId", newId);
                result.put("nodeId", nodeId);
                result.put("token", token);
            } else {
                //保存数据
                pfNewsService.saveNews(pfNews);
                //保存日志
                logService.saveLog(request, SessionUtil.getCurrentUserId(),  "用户新增" + pfNews.getNewid(), "新增信息发布");
                result.put("result", true);
            }
        } catch (Exception e) {
            result.put("result", false);
            e.printStackTrace();
        }

        return result;
    }

    /**
     * @param newId
     * @param messageType
     * @param model
     * @author : <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @date : 2019-06-04 15:18
     * @return:java.lang.Object
     * @Description : 初始化修改的信息发布数据
     */
    @RequestMapping("/getModify")
    @ResponseBody
    public Object getModify(@RequestParam(value = "newId", required = true) String newId, String messageType, Model model) {

        Space space = nodeService.getWorkSpace(Constants.MESSAGE_FILE, true);
        Node msgNode = nodeService.getNode(space.getId(), newId, true);
        Integer nodeId = msgNode.getId();
        String token = nodeService.getToken(msgNode);
        PfNews pfNews = pfNewsService.getById(newId);
        Map<String, Object> result = new HashMap<String, Object>(3);
        result.put("token", token);
        result.put("nodeId", nodeId);
        result.put("pfNews", pfNews);
        return result;
    }

    /**
     * @param pfNews
     * @param request
     * @author : <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @date : 2019-06-04 15:18
     * @return:java.lang.Object
     * @Description : 信息发布更新操作
     */
    @ResponseBody
    @RequestMapping("/updateNews")
    public Object updateNews(PfNews pfNews, HttpServletRequest request) {

        boolean result = false;
        try {
            pfNewsService.updateNews(pfNews);
            //保存日志
            logService.saveLog(request, SessionUtil.getCurrentUserId(),  "用户修改" + pfNews.getNewid(), "修改信息发布");
            result = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * @param
     * @author : <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @date : 2019-06-04 16:06
     * @return:com.gtis.portal.entity.PfNews
     * @Description : 获取最新的一条公告，如果状态启用返回，否则不返回
     */
    @RequestMapping("/getRecentNews")
    @ResponseBody
    public PfNews getRecentNews() {
        List<PfNews> pfNewsList = pfNewsService.getList();
        PfNews pfNews = new PfNews();
        if (pfNewsList.size() > 0 && "1".equals(pfNewsList.get(0).getIspublish())) {
            pfNews = pfNewsList.get(0);
            return pfNews;
        } else {
            return null;
        }
    }
}
