package com.gtis.portal.web;

import cn.gtmap.estateplat.model.server.core.BdcNewBdcdy;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Statistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2017/7/25
 * @description 缓存管理
 */
@Controller
@RequestMapping("/cache")
public class CacheController extends BaseController{
    @Autowired
    private CacheManager cacheManager;

    @RequestMapping("/index")
    public String index(Model model){
        List<Statistics> caches = new ArrayList<Statistics>();
        for (String cacheName : cacheManager.getCacheNames()) {
            caches.add(cacheManager.getCache(cacheName).getStatistics());
        }
        model.addAttribute("caches",caches);
        return "cache";
    }


    @RequestMapping("/clean/{name}")
    public Object cleanCache(@PathVariable("name") String name){
        if ("all".equals(name)) {
            cacheManager.clearAll();
        } else {
            Cache cache = cacheManager.getCache(name);
            cache.removeAll();
        }
        return "redirect:/cache/index";
    }
}
