package com.gtis.portal.util;

import cn.gtmap.estateplat.model.server.core.BdcZdQlzt;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: zx
 * Date: 15-9-7
 * Time: 下午9:03
 * Des:读取xml配置
 * To change this template use File | Settings | File Templates.
 */
public class ReadXmlProps {
    /**
     * 获取部署的地区
     *
     * @return
     */
    public static List<Map> getDeployRegionList(String loginName) {
        List<Map> deployRegionList = new ArrayList<Map>();
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(AppConfig.getEgovHome() + "/conf/portal/deploy-region.xml");
        } catch (DocumentException e) {

        }
        if (document != null) {
            Element root = document.getRootElement();
            List<Node> nodes = root.selectNodes("region");
            if (nodes != null) {
                for (int i = 0; i < nodes.size(); i++) {
                    Map map= Maps.newHashMap();
                    map.put("xzqdm",((Element)(nodes.get(i).selectNodes("xzqdm").get(0))).getText());
                    map.put("xzqmc",((Element)(nodes.get(i).selectNodes("xzqmc").get(0))).getText());
                    String sysUrl=((Element)(nodes.get(i).selectNodes("sys-url").get(0))).getText();
                    if(StringUtils.isNotBlank(sysUrl) && StringUtils.indexOf(sysUrl,"/portal")>-1) {
                        String casUrl=StringUtils.substring(sysUrl, 0, StringUtils.indexOf(sysUrl, "portal")) + "cas";
                        String platformUrl=StringUtils.substring(sysUrl, 0, StringUtils.indexOf(sysUrl, "portal")) + "platform";
                        map.put("sysUrl",casUrl+"/calogin?username="+loginName+"&url="+sysUrl);
                        map.put("getTaskCountUrl",platformUrl+"/workFlowInstanceService.service");
                    }
                    deployRegionList.add(map);
                }
            }
        }
        return deployRegionList;
    }
    /**
     * 获取部署的地区
     *
     * @return
     */
    public static List<Map> getTasklistFilterList() {
        List<Map> tasklistFilterList = new ArrayList<Map>();
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(AppConfig.getEgovHome() + "/conf/portal/tasklist-filter.xml");
        } catch (DocumentException e) {

        }
        if (document != null) {
            Element root = document.getRootElement();
            List<Node> nodes = root.selectNodes("filter");
            if (nodes != null) {
                for (int i = 0; i < nodes.size(); i++) {
                    Map map= Maps.newHashMap();
                    map.put("butName",((Element)(nodes.get(i).selectNodes("butName").get(0))).getText());
                    String wdids="";
                    List<Element> wdidsEles=nodes.get(i).selectNodes("wdids/wdid");
                    if(wdidsEles!=null){
                        for(Element ele:wdidsEles){
                            if(StringUtils.isBlank(wdids))
                                wdids=ele.getText();
                            else
                                wdids=wdids+","+ele.getText();
                        }
                    }
                    map.put("wdids",wdids);
                    tasklistFilterList.add(map);
                }
            }
        }
        return tasklistFilterList;
    }

    /**
     * 获取超期配置
     *
     * @return
     */
    public static List<Map> getOverTimeConfigList() {
        List<Map> overTimeConfigList = new ArrayList<Map>();
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(AppConfig.getEgovHome() + "/conf/portal/overtime-tasklist-config.xml");
        } catch (DocumentException e) {

        }
        if (document != null) {
            Element root = document.getRootElement();
            List<Node> nodes = root.selectNodes("config");
            if (nodes != null) {
                for (int i = 0; i < nodes.size(); i++) {
                    Map map= Maps.newHashMap();
                    map.put("wfName",((Element)(nodes.get(i).selectNodes("wfName").get(0))).getText());
                    map.put("activityName",((Element)(nodes.get(i).selectNodes("activityName").get(0))).getText());
                    map.put("overtimeDay",((Element)(nodes.get(i).selectNodes("overtimeDay").get(0))).getText());
                    overTimeConfigList.add(map);
                }
            }
        }
        return overTimeConfigList;
    }
    public static void main(String[] args) {
        ReadXmlProps.getTasklistFilterList();
    }
}

