package com.gtis.portal.util;


import java.awt.*;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

/**
 * Created by IntelliJ IDEA.
 * User: ibm
 * Date: 2017/8/11.
 * Time: 15:50
 * To change this template use File | Settings | File Templates.
 */
public class ImageUtil {

    private static String CSSCOLOR = "#bf8f79";
    private static float ALPHA = 0.4f;

    public static BufferedImage createMark(WaterMarkBO waterMarkBO) {
        BufferedImage bimage = buildGraph2d(waterMarkBO);
        return bimage;
    }

    //构造2d画笔
    private static BufferedImage buildGraph2d(WaterMarkBO waterMarkBO){
        Color markContentColor = Color.gray;

        int width = (int) Math.ceil((waterMarkBO.getMarkContent().length()*waterMarkBO.getFontSize()+20)* Math.sin(Math.PI*60/180))+110;
        int height = (waterMarkBO.getMarkContent().length()*waterMarkBO.getFontSize()+20)/2+50;
        //为画出图片的大小
        BufferedImage bimage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        //2d 画笔
        Graphics2D g = bimage.createGraphics();
        bimage = g.getDeviceConfiguration().createCompatibleImage(width,height, Transparency.TRANSLUCENT);
        g.dispose();
        g = bimage.createGraphics();
        g.setColor(Color.lightGray);
        g.setBackground(Color.BLUE);
        //g.setBackground(Color.WHITE);

        //g.setPaint(new Color(0,0,255));
        //g.fillRect(0,0,100,10);
        g.setStroke(new BasicStroke(1));


        //--------对要显示的文字进行处理--------------
        AttributedCharacterIterator iter = buildFont(waterMarkBO.getMarkContent(), waterMarkBO.getFontType(),
                waterMarkBO.getFontSize());
        //Color color = Color.decode(CSSCOLOR);

        // 设置水印旋转
        /*AffineTransform at = new AffineTransform();
        at.translate(width/2,height/2);*/
        g.rotate(Math.toRadians(-30),width/2,height/2);

        FontRenderContext context = g.getFontRenderContext();
        Font font = new Font(waterMarkBO.getFontType(), Font.PLAIN, waterMarkBO.getFontSize());
        Rectangle2D bounds = font.getStringBounds(waterMarkBO.getMarkContent(),context);

        double x = (width-bounds.getWidth())/3+50;
        double y = (height-bounds.getHeight())/2+50;
        g.setFont(font);
        g.drawString(waterMarkBO.getMarkContent(),(int)x,(int)y);
        //添加水印的文字和设置水印文字出现的内容 ----位置
        g.dispose();//画笔结束
        return bimage;
    }



    //形成字体属性
    private static AttributedCharacterIterator buildFont(String markContent,
                                                         String fontType, int fontSize) {
        AttributedString ats = new AttributedString(markContent);
        Font f = new Font(fontType, Font.PLAIN, fontSize);
        ats.addAttribute(TextAttribute.FONT, f, 0, markContent.length());
        AttributedCharacterIterator iter = ats.getIterator();
        return iter;
    }
}
