package com.gtis.portal.service.server.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.server.AutoTurnAllTaskDao;
import com.gtis.portal.entity.BdcZdpjjlAll;
import com.gtis.portal.service.impl.TaskAfterTurnGeneralServiceImpl;
import com.gtis.portal.service.server.AutoTurnAllTaskService;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.util.QueryCondition;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.List;

import static com.gtis.portal.entity.QBdcZdpjjlAll.bdcZdpjjlAll;

@Service
public class AutoTurnAllTaskServiceImpl extends TaskAfterTurnGeneralServiceImpl implements AutoTurnAllTaskService {
    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;

    @PersistenceContext(unitName = "entityManagerFactory_server")
    EntityManager em;

    @Autowired
    AutoTurnAllTaskDao autoTurnAllTaskDao;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    BdcXmService bdcXmService;

    @Autowired
    SysTaskService taskService;

    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;

    @Override
    public Page<BdcZdpjjlAll> queryBdcZdpjjlallList(String userid, String kqzt, Pageable page) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank(kqzt))
            expression = bdcZdpjjlAll.kqzt.eq(kqzt);

        if (StringUtils.isNotBlank(userid)) {
            if (expression == null)
                expression = bdcZdpjjlAll.yhid.eq(userid);
            else
                expression = expression.and(bdcZdpjjlAll.yhid.eq(userid));
        }

        return autoTurnAllTaskDao.findAll(expression, page);
    }


    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public BdcZdpjjlAll getBdcZdpjjl(String yhjlId) {
        return baseDao.getById(BdcZdpjjlAll.class, yhjlId);
    }


    @Override
    public BdcZdpjjlAll getBdcZdpjjlByWdidAndJdidAndYhid(String yhid) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("yhid", QueryCondition.EQ, yhid);
        queryConditions.add(queryCondition);
        List<BdcZdpjjlAll> bdcZdpjjlList = baseDao.get(BdcZdpjjlAll.class, queryConditions);
        if (CollectionUtils.isNotEmpty(bdcZdpjjlList))
            return bdcZdpjjlList.get(0);
        return null;
    }


    @Override
    public void save(BdcZdpjjlAll bdcZdpjjl) {
        if (StringUtils.isBlank(bdcZdpjjl.getPjjlid()))
            bdcZdpjjl.setPjjlid(UUIDGenerator.generate());
        //根据id查询当前记录
        BdcZdpjjlAll getBdcZdpjjl = getBdcZdpjjl(bdcZdpjjl.getPjjlid());
        if (StringUtils.isNotBlank(bdcZdpjjl.getYhid())) {
            PfUserVo pfUserVo = sysUserService.getUserVo(bdcZdpjjl.getYhid());
            if (pfUserVo != null) {
                bdcZdpjjl.setYhmc(pfUserVo.getUserName());
            }
        }
        if (bdcZdpjjl.getSjpjsl() == null) {
            bdcZdpjjl.setSjpjsl(0);
        }
        if (bdcZdpjjl.getXnpjsl() == null) {
            bdcZdpjjl.setXnpjsl(0);
        }
        if (bdcZdpjjl.getPjsx() == null) {
            bdcZdpjjl.setPjsx(1);
        }
        if (StringUtils.isBlank(bdcZdpjjl.getKqzt())) {
            bdcZdpjjl.setKqzt("1");
        }
        if (getBdcZdpjjl != null) {
            updateBdcZdpjjl(bdcZdpjjl);
        } else {
            addBdcZdpjjl(bdcZdpjjl);
        }
        //如果这个人是从请假变为正常，那么把同角色的所有人虚拟派件数量都更新为0
        if (bdcZdpjjl != null && getBdcZdpjjl != null && "1".equals(bdcZdpjjl.getKqzt()) && "0".equals(getBdcZdpjjl.getKqzt())) {
            List<PfRoleVo> roleListByUser1 = sysUserService.getRoleListByUser(bdcZdpjjl.getYhid());
            List<BdcZdpjjlAll> bdcZdpjjlAllList = queryBdcZdpjjlList("", "");
            for (int i = 0; i < bdcZdpjjlAllList.size(); i++) {
                BdcZdpjjlAll bdcZdpjjlAll = bdcZdpjjlAllList.get(i);
                List<PfRoleVo> roleListByUser2 = sysUserService.getRoleListByUser(bdcZdpjjlAll.getYhid());
                for (int j = 0; j <roleListByUser2.size() ; j++) {
                    for (int k = 0; k < roleListByUser1.size(); k++) {
                        if(roleListByUser1.get(k).getRoleId().equals(roleListByUser2.get(j).getRoleId()))
                        {
                            bdcZdpjjlAll.setXnpjsl(0);
                        }
                    }
                }
                updateBdcZdpjjl(bdcZdpjjlAll);
            }
        }
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void delBdcZdpjjl(String id) {
        baseDao.delete(BdcZdpjjlAll.class, id);
    }

    @Override
    public List<BdcZdpjjlAll> queryBdcZdpjjlList(String userid, String kqzt) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        if (StringUtils.isNotBlank(userid)) {
            QueryCondition queryCondition1 = new QueryCondition("yhid", QueryCondition.EQ, userid);
            queryConditions.add(queryCondition1);
        }
        if (StringUtils.isNotBlank(kqzt)) {
            QueryCondition queryCondition1 = new QueryCondition("kqzt", QueryCondition.EQ, kqzt);
            queryConditions.add(queryCondition1);
        }

        return baseDao.get(BdcZdpjjlAll.class, queryConditions);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void updateBdcZdpjjl(BdcZdpjjlAll bdcZdpjjl) {
        baseDao.update(bdcZdpjjl);
    }

    public void addBdcZdpjjl(BdcZdpjjlAll bdcZdpjjl) {
        baseDao.save(bdcZdpjjl);
    }
}
