package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.service.portal.TaskPerformerFilterService;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.portal.entity.BdcXm;
import com.gtis.portal.service.TaskAfterTurnGeneralService;
import com.gtis.portal.service.TaskGeneralService;
import com.gtis.portal.service.server.AutoTurnTaskService;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/9/21
 * @description 自动派件（转发时候按照申请类型和节点计算办件量，通过办件量进行按顺序派件）
 */
public class TaskPerformerMinWorkloadFilterServiceImpl implements TaskPerformerFilterService {
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    AutoTurnTaskService autoTurnTaskService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Resource(name = "taskPerformerMinWorkloadFilterService")
    TaskPerformerFilterService taskPerformerFilterService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysTaskService taskService;
    @Resource(name = "taskAfterTurnGeneralServiceImpl")
    TaskAfterTurnGeneralService taskAfterTurnGeneralServiceImpl;


    @Override
    public List<PfUserVo> getTaskPerformers(String wiid, String targetActivityDefinitionId, PfTaskVo sourceTask, List<PfUserVo> sourceUsers,String wdid) {
        //是否只有银行申请自动派件
        String onlyYhsq = AppConfig.getProperty("yhsq.only.autoTurnTask.enble");
        if (StringUtils.equals(onlyYhsq, "true")) {
            if (StringUtils.isNotBlank(wiid)) {
                List<BdcXm> bdcXmList = bdcXmService.getBdcXmList(wiid);
                boolean isyhsq = false;
                if (CollectionUtils.isNotEmpty(bdcXmList)) {
                    for (BdcXm bdcXm : bdcXmList) {
                        if (bdcXm != null && StringUtils.isNotBlank(bdcXm.getYhsqywh())) {
                            isyhsq = true;
                            break;
                        }
                    }
                }else
                    isyhsq=true;
                if (!isyhsq)
                    return null;
            }
        }
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
        if (pfWorkFlowInstanceVo != null && StringUtils.isBlank(wiid))
            wdid = pfWorkFlowInstanceVo.getWorkflowDefinitionId();
        String userid = autoTurnTaskService.getZdpjYhid(wdid, targetActivityDefinitionId, sourceUsers);
        if (StringUtils.isNotBlank(userid)) {
            PfUserVo pfUserVo = sysUserService.getUserVo(userid);
            if (pfUserVo != null)
                return Lists.newArrayList(pfUserVo);
        }
        return null;
    }

    @Override
    public WorkFlowInfo createWorkFlowInstance(PfWorkFlowInstanceVo intanceVo, String userId) throws Exception {
        WorkFlowInfo workFlowInfo = null;
        PfWorkFlowDefineVo pfWorkFlowDefineVo = null;
        if (intanceVo == null || StringUtils.isBlank(intanceVo.getWorkflowDefinitionId()))
            return null;
        pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(intanceVo.getWorkflowDefinitionId());
        WorkFlowXml workXml = WorkFlowXmlUtil.getDefineModel(pfWorkFlowDefineVo);
        List<ActivityModel> activityModelList = workXml.getActivityList();
        ActivityModel activityModel = null;
        if (CollectionUtils.isNotEmpty(activityModelList))
            activityModel = activityModelList.get(0);

        //根据模型过滤用户
        String autoTurnTaskEnable = AppConfig.getProperty("autoTurnTask.enble");
        if (activityModel != null && StringUtils.equals(autoTurnTaskEnable, "true")) {
            List<PfUserVo> performerUsers = null;
            List<PfUserVo> pfUserVoList = Lists.newArrayList();
            for (PerformerModel performerModel : activityModel.getPerformerList()) {
                if (StringUtils.isNotBlank(performerModel.getUserId())) {
                    PfUserVo pfUserVo = new PfUserVo();
                    pfUserVo.setUserId(performerModel.getUserId());
                    pfUserVo.setUserName(sysUserService.getUserVo(performerModel.getUserId()).getUserName());
                    pfUserVoList.add(pfUserVo);
                }
                if (StringUtils.isNotBlank(performerModel.getRoleId())) {
                    List<PfUserVo> pfUserVoList1 = sysUserService.getUserListByRole(performerModel.getRoleId());
                    if (CollectionUtils.isNotEmpty(pfUserVoList1))
                        pfUserVoList.addAll(pfUserVoList1);
                }
                if (StringUtils.isNotBlank(performerModel.getOrganId())) {
                    List<PfUserVo> pfUserVoList1 = sysUserService.getUserListByOragn(performerModel.getOrganId());
                    if (CollectionUtils.isNotEmpty(pfUserVoList1))
                        pfUserVoList.addAll(pfUserVoList1);
                }

            }
            performerUsers = taskPerformerFilterService.getTaskPerformers(intanceVo.getWorkflowIntanceId(), activityModel.getDefineId(), null, pfUserVoList,intanceVo.getWorkflowDefinitionId());
            if (CollectionUtils.isNotEmpty(performerUsers))
                workFlowInfo = workFlowService.createWorkFlowInstance(intanceVo, performerUsers.get(0).getUserId());
            else
                workFlowInfo = workFlowService.createWorkFlowInstance(intanceVo, userId);
            //计算工作量
            if(workFlowInfo!=null)
                taskAfterTurnGeneralServiceImpl.doWork(workFlowInfo);
        }

        return workFlowInfo;
    }
}
