package com.gtis.portal.service.impl;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.TaskAfterTurnGeneralService;
import com.gtis.portal.service.TaskGeneralService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhagnxing@gtmap.cn">zx</a>
 * @version 1.0, 2016/10/18
 * @description 任务转发后通用服务
 */
public class TaskAfterTurnGeneralServiceImpl implements TaskAfterTurnGeneralService {
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    ThreadPoolTaskScheduler taskScheduler;

    private List<Map<TaskAfterTurnGeneralService, String>> taskAfterTurnGeneralServiceList;

    Map.Entry<TaskAfterTurnGeneralService, String> taskAfterTurnGeneralServiceMapEntry;


    public WorkFlowInfo workFlowInfo;

    public List<Map<TaskAfterTurnGeneralService, String>> getTaskAfterTurnGeneralServiceList() {
        return taskAfterTurnGeneralServiceList;
    }

    public void setTaskAfterTurnGeneralServiceList(List<Map<TaskAfterTurnGeneralService, String>> taskAfterTurnGeneralServiceList) {
        this.taskAfterTurnGeneralServiceList = taskAfterTurnGeneralServiceList;
    }


    /**
     * @author <a href="mailto:zhagnxing@gtmap.cn">zx</a>
     * @param info 工作流信息
     * @return 是否验证通过
     * @exception PortalException 未验证通过则返回异常
     * @description 验证任务
     */
    @Override
    public boolean doWork(WorkFlowInfo info) throws PortalException{
        workFlowInfo=info;
        boolean turnEnable=false;
        try {
            if (CollectionUtils.isNotEmpty(taskAfterTurnGeneralServiceList)) {
                for (Map<TaskAfterTurnGeneralService, String> workFlowEventServiceMap : taskAfterTurnGeneralServiceList) {
                    for (Map.Entry<TaskAfterTurnGeneralService, String> workFlowEventServiceEntry : workFlowEventServiceMap.entrySet()) {
                        taskAfterTurnGeneralServiceMapEntry = workFlowEventServiceEntry;
                        String async=workFlowEventServiceEntry.getValue();
                        if(StringUtils.equals(async,"true")) {
                            //异步
                            taskScheduler.execute(new Runnable() {
                                @Override
                                public void run() {
                                    taskAfterTurnGeneralServiceMapEntry.getKey().doWork(workFlowInfo);
                                }
                            });
                        }else
                            //同步
                            taskAfterTurnGeneralServiceMapEntry.getKey().doWork(workFlowInfo);
                    }
                }
            }
            turnEnable=true;
        } catch (PortalException e) {
            throw new PortalException(ExceptionCode.TASK_AFTERTURN_GENERAL_ERROR);
        }
        return turnEnable;
    }

    public WorkFlowInfo getInfoObj(String taskid, String userid) {
        WorkFlowInfo info=new WorkFlowInfo();
        info.setUserId(userid);
        PfTaskVo pfTaskVo=taskService.getHistoryTask(taskid);
        if(pfTaskVo!=null) {
            info.setSourceTask(pfTaskVo);
            if(StringUtils.isNotBlank(pfTaskVo.getActivityId())){
                PfActivityVo pfActivityVo=taskService.getActivity(pfTaskVo.getActivityId());
                if(pfActivityVo!=null){
                    //转发前的节点
                    info.setSourceActivity(pfActivityVo);
                    if(StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId())){
                        PfWorkFlowInstanceVo pfWorkFlowInstanceVo=sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                        if(pfWorkFlowInstanceVo!=null) {
                            info.setWorkFlowIntanceVo(pfWorkFlowInstanceVo);
                            if(StringUtils.isNotBlank(pfWorkFlowInstanceVo.getWorkflowDefinitionId())){
                                PfWorkFlowDefineVo pfWorkFlowDefineVo=sysWorkFlowDefineService.getWorkFlowDefine(pfWorkFlowInstanceVo.getWorkflowDefinitionId());
                                info.setWorkFlowDefineVo(pfWorkFlowDefineVo);
                            }
                        }
                        //获取转发后的节点
                        List<PfActivityVo> targetActivityVoList= taskService.getWorkFlowInstanceActivityList(pfActivityVo.getWorkflowInstanceId());
                        if(CollectionUtils.isNotEmpty(targetActivityVoList)){
                            List<PfActivityVo> targetActivityList=new ArrayList<PfActivityVo>();
                            for (PfActivityVo activityVo:targetActivityVoList){
                                if(activityVo.getActivityState()==1){
                                    List<PfTaskVo> targetTaskList= taskService.getTaskListByActivity(activityVo.getActivityId());
                                    targetActivityList.add(activityVo);
                                    info.setTargetTasks(targetTaskList);
                                }
                            }
                            info.setTargetActivitys(targetActivityList);
                        }
                    }
                }
            }
        }
        return info;
    }

}
