package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfTaskVo;
import com.gtis.portal.entity.PfWorkFlowInstanceExtVo;
import com.gtis.portal.service.PfTaskService;
import com.gtis.portal.service.PfWorkflowInstanceExtService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

/**
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2016/9/30
 * @description 工作流实例登记信息管理接口方法
 */
@Service
public class PfWorkflowInstanceExtServiceImpl implements PfWorkflowInstanceExtService {
    @Resource(name = "baseDaoImpl")
    BaseDao baseDao;

    @Override
    public PfWorkFlowInstanceExtVo queryPfWorkFlowInstanceExtByTaskId(String wiid) {
        if (StringUtils.isNotBlank(wiid))
            return baseDao.getById(PfWorkFlowInstanceExtVo.class, wiid);
        return null;
    }

    @Override
    public void updatePfWorkFlowInstanceExtVo(PfWorkFlowInstanceExtVo pfWorkFlowInstanceExtVo) {
        if (pfWorkFlowInstanceExtVo != null && StringUtils.isNotBlank(pfWorkFlowInstanceExtVo.getWorkflowInstanceId())) {
            baseDao.update(pfWorkFlowInstanceExtVo);
        }
    }

    @Override
    public void updateLzrq(String wiid,String lzrq) {
        if(StringUtils.isNotBlank(wiid) && StringUtils.isNotBlank(lzrq)){
            Date lzrq1= CalendarUtil.formatDate(lzrq);
            PfWorkFlowInstanceExtVo pfWorkFlowInstanceExtVo=queryPfWorkFlowInstanceExtByTaskId(wiid);
            if(pfWorkFlowInstanceExtVo!=null){
                pfWorkFlowInstanceExtVo.setDate1(lzrq1);
                baseDao.update(pfWorkFlowInstanceExtVo);
            }else{
                PfWorkFlowInstanceExtVo pfWorkFlowInstanceExtVo1=new PfWorkFlowInstanceExtVo();
                pfWorkFlowInstanceExtVo1.setDate1(lzrq1);
                pfWorkFlowInstanceExtVo1.setWorkflowInstanceId(wiid);
                baseDao.save(pfWorkFlowInstanceExtVo1);
            }

        }
    }
}
