package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.utils.DateUtils;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.TaskBeforeTurnValidationService;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/10/18
 * @description下一个时间的任务验证
 */
@Service
public class NextTimeTaskUnhandledValidationServiceImpl implements TaskBeforeTurnValidationService {
    @Autowired
    private SysTaskService sysTaskService;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    //排除节点名称
    private String excludeActivityNames;

    public String getExcludeActivityNames() {
        return excludeActivityNames;
    }

    public void setExcludeActivityNames(String excludeActivityNames) {
        this.excludeActivityNames = excludeActivityNames;
    }

    @Override
    public boolean validateTask(String taskId, String userId) throws PortalException {
        PfTaskVo pfTaskVo = sysTaskService.getTask(taskId);
        String wdid = "";
        //取出工作流定义id
        PfActivityVo pfActivityVo = null;
        Date createDate = null;
        if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
            pfActivityVo = sysTaskService.getActivity(pfTaskVo.getActivityId());
            if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId())) {
                PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                if (pfWorkFlowInstanceVo != null && StringUtils.isNotBlank(pfWorkFlowInstanceVo.getWorkflowDefinitionId()))
                    wdid = pfWorkFlowInstanceVo.getWorkflowDefinitionId();
                if (pfWorkFlowInstanceVo != null)
                    createDate = pfWorkFlowInstanceVo.getCreateTime();
                if (StringUtils.equals(pfWorkFlowInstanceVo.getPriority(), "2") || StringUtils.equals(pfWorkFlowInstanceVo.getPriority(), "3"))
                    return true;
            }

        }
        if (StringUtils.isNotBlank(wdid)) {
            //判断当前任务是否是本人在这个工作流的第一个任务
            HashMap param = Maps.newHashMap();
            if (StringUtils.isBlank(userId)) {
                userId = SessionUtil.getCurrentUserId();
            }
            param.put("userId", userId);
            param.put("WORKFLOW_DEFINITION_ID", wdid);
            param.put("LESS_CREATE_TIME", createDate);
            param.put("PRIORITY", "1");
            param.put("STATE", "1");
            int taskCount = Integer.parseInt(sysWorkFlowInstanceService.getTaskCount(param));
            int turnEnabledCount = 1;
            if (StringUtils.isNotBlank(AppConfig.getProperty("trun.enabled.count"))) {
                turnEnabledCount = Integer.parseInt(AppConfig.getProperty("trun.enabled.count"));
            }
            if (taskCount >= turnEnabledCount && taskCount > 0 && (StringUtils.isBlank(excludeActivityNames) || (pfActivityVo != null && StringUtils.indexOf(excludeActivityNames, pfActivityVo.getActivityName()) < 0)))
                throw new PortalException(ExceptionCode.NEXT_TIME_TASK_UNHANDLED);
        }
        return true;
    }
}
