package com.gtis.portal.service.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.FcNodeDao;
import com.gtis.portal.entity.FcNode;
import com.gtis.portal.entity.PfMenu;

import com.gtis.portal.model.Menu;
import com.gtis.portal.service.FcNodeService;
import com.gtis.portal.service.PfMenuService;
import com.mysema.query.Query;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

@Service
public class FcNodeServiceImpl implements FcNodeService {
    @Resource(name="baseDaoImpl")
    BaseDao baseDao;
    @PersistenceContext(unitName = "entityManagerFactory")
    EntityManager em;

    @Override
    public List<FcNode> getChildNodesInParentIds( List<String> parentIds) {
        String sql="select t from FcNode t where parentId in(:aList)";
        TypedQuery<FcNode> query = em.createQuery(sql, FcNode.class);
        query.setParameter("aList", parentIds);
        return query.getResultList();
    }

    @Override
    public FcNode getNodeByNodeName(String nodeName) {
        String sql="select t from FcNode t where nodeName =?0";
        List<FcNode> fcNodeList= baseDao.getByJpql(sql,nodeName);
        if(CollectionUtils.isNotEmpty(fcNodeList))
            return fcNodeList.get(0);
        else
            return  null;
    }
}
