package com.gtis.portal.entity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: jibo
 * Date: 14-5-8
 * Time: 上午6:41
 * To change this template use File | Settings | File Templates.
 * create table PF_MESSAGE_ACCEPT
 (
 messageaccept_id     VARCHAR2(32) not null,
 messagesend_id      VARCHAR2(32),
 messagesend_username  VARCHAR2(50) not null,
 messageaccept_user    VARCHAR2(32) not null,
 messagesend_date    DATE not null,
 message_type   number(1) default 0,
 messagesend_title    VARCHAR2(32),
 messagesend_content    VARCHAR2(1000),
 messageaccept_date   DATE
 );
 alter table PF_MESSAGE_ACCEPT
 add constraint PK_PF_MESSAGE_ACCEPT primary key (messageaccept_id);
 */
@Entity
@Table(name = "PF_MESSAGEACCEPT")
public class PfMessageAccept implements Serializable {
    @Id
    @Column(name="MESSAGEACCEPT_ID")
    private String messageacceptId;

    @ManyToOne(cascade = CascadeType.MERGE)
    @JoinColumn(name="MESSAGESEND_ID")
    private PfMessageSend messageSend;
    //接收人id
    @OneToOne
    @JoinColumn(name="MESSAGEACCEPT_MAN")
    private PfUser messageacceptUser;
    //消息状态
    @Column(name="MESSAGEACCEPT_STATUS")
    private int messageacceptStatus;
    //接受时间
    @Column(name="MESSAGEACCEPT_DATE")
    private Date messageacceptDate;


    public String getMessageacceptId() {
        return messageacceptId;
    }

    public void setMessageacceptId(String messageacceptId) {
        this.messageacceptId = messageacceptId;
    }

    public PfMessageSend getMessageSend() {
        return messageSend;
    }

    public void setMessageSend(PfMessageSend messageSend) {
        this.messageSend = messageSend;
    }

    public PfUser getMessageacceptUser() {
        return messageacceptUser;
    }

    public void setMessageacceptUser(PfUser messageacceptUser) {
        this.messageacceptUser = messageacceptUser;
    }

    public int getMessageacceptStatus() {
        return messageacceptStatus;
    }

    public void setMessageacceptStatus(int messageacceptStatus) {
        this.messageacceptStatus = messageacceptStatus;
    }

    public Date getMessageacceptDate() {
        return messageacceptDate;
    }

    public void setMessageacceptDate(Date messageacceptDate) {
        this.messageacceptDate = messageacceptDate;
    }
}



