/*
 * Copyright (c) 2014. Lorem ipsum dolor sit amet, consectetur adipiscing elit.
 * Morbi non lorem porttitor neque feugiat blandit. Ut vitae ipsum eget quam lacinia accumsan.
 * Etiam sed turpis ac ipsum condimentum fringilla. Maecenas magna.
 * Proin dapibus sapien vel ante. Aliquam erat volutpat. Pellentesque sagittis ligula eget metus.
 * Vestibulum commodo. Ut rhoncus gravida arcu.
 */

var _menuJsonObj;

function findMenuObj(menuObj, menuId) {
    for (var i = 0; i < menuObj.children.length; i++) {
        if (menuObj.children[i].id == menuId) {
            return  menuObj.children[i];
        } else {
            var menu = findMenuObj(menuObj.children[i], menuId);
            if (menu != null)
                return menu;
        }
    }
}

function setFrameHeight() {
    var offset = 0;
    var userAgent = navigator.userAgent.toLowerCase();
    if (/firefox/.test(userAgent))
        offset = 3;
    else if (/msie/.test(userAgent))
        offset = 3;
    else if(/chrome/.test(userAgent))
        offset = 2;

    var topOffset=120;
    var breadcrumbs = $('#breadcrumbs');
    if(breadcrumbs.is(':hidden'))
        topOffset=79;

    var mainheight = $(window).height() - topOffset - offset;
    $('#mainFrame').height(mainheight);
    $('.page-content').height(mainheight);
}
$(document).ready(function () {
    setFrameHeight();
    $(window).resize(function () {
        setFrameHeight();
    });
    //一级菜单
    $.get("getmenu", function (result) {
        _menuJsonObj = result;
        var rootMenuChilds = _menuJsonObj.children;
        if (rootMenuChilds.length > 1) {
            for (var i = 0; i < rootMenuChilds.length; i++) {
                var menu = rootMenuChilds[i];
                var tabStr = '<li ><a href="#" data-toggle="tab" onclick="initTab(\'' + menu.id + '\')" style="border-top-left-radius:5px;border-top-right-radius:5px;border-bottom-right-radius:0px;border-bottom-left-radius:0px;">' +
                    '<i class="bigger-110 ' + menu.cls + '"></i> ' + menu.text +
                    '</a></li>';
                $(tabStr).appendTo('#menuTab');
            }
        }
        //初始化第一个tab
        if (_menuJsonObj.children.length > 0) {
            initTab(_menuJsonObj.children[menuIndex].id);
            $('#menuTab li:eq(' + menuIndex + ')').addClass("active");
        }

    });
    $.getJSON(platform_url+"/portal!count.action",function(result){
        if(result!=null){
            $('#task').text(result.task);
            $('#taskCount').text(result.task);
            $('#taskOverCount').text(result.taskover);
            $('#taskCqCount').text(result.taskcq);
        }
    });

});

function initTab(menuId) {
    $("#breadcrumbs .breadcrumb").html('');
    $(".nav-list").html('');

    var secondMenu;
    for (var i = 0; i < _menuJsonObj.children.length; i++) {
        if (_menuJsonObj.children[i].id == menuId) {
            addLinkBar(_menuJsonObj.children[i].id);
            //加载默认页面
            openMenuResource(_menuJsonObj.children[i].link, _menuJsonObj.children[i].model);
            secondMenu = _menuJsonObj.children[i];
            break;
        }
    }
    if (secondMenu.children.length > 0) {
        displaySidebar(true);
        for (var i = 0; i < secondMenu.children.length; i++) {
            if(i==0&&secondMenu.children[i].children.length==0)
                addMenu(secondMenu.children[i],true);
            else
                addMenu(secondMenu.children[i],false);
        }
    }else{
        displaySidebar(false);
    }
}

function MakeMenuActive(menuObj) {
    try {
        if (menuObj.parent()[0].tagName != "DIV") {
            if (menuObj.parent()[0].tagName == "LI") {
                $(menuObj.parent()[0]).addClass("active open");
            }
            MakeMenuActive(menuObj.parent());
        }
    } catch (e) {
    }
}

function MakeMenuNoActive() {
    $('#sidebar li').each(function () {
        $(this).removeClass('active');
    });
}

function addMenu(menuObj,isActive) {
    if (!menuObj.cls)
        menuObj.cls = 'fa fa-angle-double-right';

    var menuHtml = "<li menuid='" + menuObj.id + "'>" +
        '<a href="#" class="dropdown-toggle" link="' + menuObj.link + '" model="' + menuObj.model + '" onclick="MenuClickEvent(this)" >' +
        '<i class="' + menuObj.cls + '"/>' +
        '<span class="menu-text"> ' + menuObj.text + '</span>';
    if (menuObj.children.length > 0)
        menuHtml = menuHtml + '<b class="arrow fa fa-angle-down"></b>';
    menuHtml = menuHtml + '</a>';
    if (menuObj.children.length > 0) {
        if (menuObj.expanded)
            menuHtml = menuHtml + '<ul class="submenu" style="display:block"/>';
        else
            menuHtml = menuHtml + '<ul class="submenu"/>';
    }
    menuHtml = menuHtml + '</li>';

    var pMenu = $('#sidebar li[menuid="' + menuObj.pid + '"]');
    if (pMenu.length > 0) {
        var submenu = $(pMenu[0]).find("ul");
        $(submenu[0]).append($(menuHtml));
    } else {
        $('#sidebar ul:first').append($(menuHtml));
    }
    for (var i = 0; i < menuObj.children.length; i++) {
        addMenu(menuObj.children[i],false);
    }

    if (menuObj.text === menuText || (isActive!=null&&isActive)) {
        $("#breadcrumbs .breadcrumb").html('');
        addLinkBar(menuObj.id);   //导航栏
        MakeMenuNoActive();
        $("#sidebar li[menuid='" + menuObj.id + "']").addClass("active");
        MakeMenuActive($("#sidebar li[menuid='" + menuObj.id + "']"));
        openMenuResource(menuObj.link, menuObj.model);
    }
}

function MenuClickEvent(aobj) {
    var menuId = $(aobj).parent().attr('menuid');
    if (menuId) {
        if ($(aobj).parent().children("ul").children("li").length == 0) {
            $("#breadcrumbs .breadcrumb").html('');
            addLinkBar(menuId);   //导航栏
            MakeMenuNoActive();
            $("#sidebar li[menuid='" + menuId + "']").addClass("active");
            MakeMenuActive($("#sidebar li[menuid='" + menuId + "']"));
            openMenuResource($(aobj).attr('link'), $(this).attr('model'));
        }
    }
}


function openMenuResource(linkstr, model) {
    if (linkstr != null) {
        $.get("menu/open?link=" + linkstr, function (result) {
            var resourceUrl = buildLinkUrl(result.resourceUrl);
            if (!model || model == 0)
                $('#mainFrame').attr("src", resourceUrl);
            else if (model == 2)
                window.document.location = resourceUrl;
            else if (model == 3)
                $('#mainFrame').load(resourceUrl);

        });
    }
}

function buildLinkUrl(resourceUrl) {
    if (resourceUrl.substr(0, 1) != "/" && resourceUrl.substr(0, 1) != "h") {
        return platform_url + '/' + resourceUrl;
    } else {
        return  resourceUrl;
    }
}

/**
 * 导航条
 */
function addLinkBar(menuId) {
    var menuObj = findMenuObj(_menuJsonObj, menuId);
    if (!menuObj) return;
    var btnHtml = "<li menuid='" + menuObj.id + "'>";
    if (menuObj.pid == null || menuObj.pid == '1')
        btnHtml = btnHtml + '<i class="' + menuObj.cls + ' home-icon "></i>';

    if (menuObj.link && menuObj.link!='' && menuObj.link != null)
        btnHtml = btnHtml + '<a href="#" onclick="MenuClickEvent(this)" link="' + menuObj.link + '" model="' + menuObj.model + '">' + menuObj.text + '</a>';
    else
        btnHtml = btnHtml + menuObj.text;
    btnHtml = btnHtml + '</li>';

    var firstLiObj = $("#breadcrumbs .breadcrumb li:first");
    if (firstLiObj.length == 0)
        $("#breadcrumbs .breadcrumb").append($(btnHtml));
    else
        $(btnHtml).insertBefore(firstLiObj);

    if (menuObj.pid) {
        addLinkBar(menuObj.pid);
    }
}


function displaySidebar(display){
    var sidebar = $('#sidebar');
    var mainContent = $('.main-content')[0];
    var breadcrumbs = $('#breadcrumbs');
    if(display){
        $(mainContent).removeClass('no-margin');
        breadcrumbs.show();
        sidebar.show();
        setFrameHeight();
    }else{
        breadcrumbs.hide();
        sidebar.hide();
        setFrameHeight();
        $(mainContent).addClass('no-margin');
    }

}



