<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <title>消息传递</title>
    <meta name="description" content="overview &amp; stats"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <link rel="stylesheet" href="${base}/static/thirdparty/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/css/ace.min.css">
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/css/font-awesome.min.css">
    <link rel="stylesheet" href="${base}/static/thirdparty/select2/select2.css">
    <script src="${base}/static/thirdparty/jquery/jquery-2.1.0.min.js"></script>
    <script src="${base}/static/thirdparty/jquery/jquery.form.js"></script>
    <script src="${base}/static/thirdparty/bootstrap/js/bootstrap.min.js"></script>
    <script src="${base}/static/thirdparty/ace/js/ace.min.js"></script>
    <script src="${base}/static/thirdparty/ace/js/jquery.nestable.min.js"></script>
    <script src="${base}/static/thirdparty/select2/select2.min.js"></script>
    <link rel="stylesheet" href="${base}/static/thirdparty/font-awesome/css/font-awesome.css">
    <style type="text/css">
        body{
            font-family:'Microsoft Yahei', verdana;
            font-kerning: auto;
            font-style: normal;
            font-variant: normal;
            font-weight: normal;
        }
    </style>
    <script type="text/javascript">
        $(document).ready(function () {
            $("span").find(".text").click(function(){
                var msgId=$(this).attr("messageId");
                showMessageContent(msgId);

            });
        });

        function showMessageContent(msgId){
            $.get("${base}/message/send?messageId="+msgId, function(result){
                var messageContent= '<div class="message-content">'+
                            '<div class="message-header clearfix">'+
                                '<div class="pull-left">'+
                                    '<span class="blue bigger-125">'+ result.messagesendTitle +'</span>' +
                                    '<div class="space-4"></div>'+
                                    '<i class="icon-star orange2 mark-star"></i>' +
                                    '<span class="sender">'+result.messagesendUser.userName+'</span>  &nbsp;'+
                                    '<i class="icon-time bigger-110 orange middle"></i>' +
                                    '<span class="time">'+result.messagesendDate.toLocaleString()+'</span>'+
                                '</div>' +
                            '</div>' +
                            '<div class="hr hr-double"></div>'+
                            '<div class="slimScrollDiv" style="overflow: hidden; width: auto; max-height: 200px;">'+
                                '<div class="message-body" style="overflow: hidden; width: auto; ">'+
                                    result.messagesendContent +
                                '</div>'+
                            '</div>'+
                        '</div>';
                var divMessage= $('span [messageId="'+result.messagesendId+'"]');
                $(messageContent).appendTo($(divMessage).parent().parent());

            });
        }
    </script>
</head>
<body>
<div class="page-content">
    <div class="row">
        <div class="col-xs-12">
            <div class="tabbable">
                <ul id="inbox-tabs" class="inbox-tabs nav nav-tabs padding-16 tab-size-bigger tab-space-1">
                    <li class="li-new-mail pull-right">
                        <a data-toggle="tab" href="#write" data-target="write" class="btn-new-mail">
                            <span class="btn bt1n-small btn-purple no-border">
                                <i class=" icon-envelope bigger-130"></i>
                                <span class="bigger-110">信息发送</span>
                            </span>
                        </a>
                    </li><!-- ./li-new-mail -->

                    <li class="active">
                        <a data-toggle="tab" href="#inbox" data-target="inbox">
                            <i class="blue icon-inbox bigger-130"></i>
                            <span class="bigger-110">收件箱</span>
                        </a>
                    </li>

                    <li>
                        <a data-toggle="tab" href="#sent" data-target="sent">
                            <i class="orange icon-location-arrow bigger-130 "></i>
                            <span class="bigger-110">发件箱</span>
                        </a>
                    </li>
                </ul>
                <div class="tab-content no-border no-padding">
                    <div class="tab-pane in active">
                        <div class="message-container">
                            <div class="message-list-container">

                                <div id="id-message-list-navbar" class="message-navbar align-center clearfix">
                                    <div class="message-bar">

                                    </div>
                                </div>
                                <div class="message-list" id="message-list">
                                    <#list messageSendPage.content as messageSend>
                                    <div class="message-item">
                                        <label class="inline">
                                            <input type="checkbox" class="ace">
                                            <span class="lbl"></span>
                                        </label>

                                        <i class="message-star icon-star-empty light-grey"></i>
                                        <span class="sender">${messageSend.messagesendUser.userName}</span>
                                        <span class="time" style="width:120px">${messageSend.messagesendDate?string("yyyy-MM-dd HH:mm")}</span>

                                        <span class="summary">
                                            <span class="text" messageId="${messageSend.messagesendId}">
                                            ${messageSend.messagesendTitle}
                                            </span>
                                        </span>
                                    </div>
                                    </#list>
                                    <#assign _pageobj=messageSendPage/>
                                    <#include "common/page.ftl"/>
                                </div>
                            </div> <!-- /.message-list-container -->
                        </div> <!-- /.message-container -->
                    </div> <!-- /.tab-pane -->
                </div> <!-- /.tab-content -->
            </div><!-- /.tabbable -->
        </div><!-- /.col -->
    </div><!-- /.row -->
<!-- PAGE CONTENT ENDS -->
</div>


</body>