<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <title>菜单编辑</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />
    <link rel="stylesheet" href="${base}/static/thirdparty/select2/select2.css">


    <!-- bootstrap & fontawesome -->
    <link rel="stylesheet" href="${base}/static/thirdparty/bootstrap/css/bootstrap.min.css" />
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/css/font-awesome.min.css" />

    <!-- text fonts -->
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/css/ace-fonts.css" />

    <!-- ace styles -->
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/css/ace.min.css" />

    <!--[if lte IE 9]>
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/css/ace-part2.min.css" />
    <![endif]-->

    <!--[if lte IE 9]>
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/assets/css/ace-ie.min.css" />
    <![endif]-->

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lte IE 8]>
    <script src="${base}/static/thirdparty/ace/js/html5shiv.js"></script>
    <script src="${base}/static/thirdparty/ace/js/respond.min.js"></script>
    <![endif]-->

    <!--[if !IE]> -->
    <script type="text/javascript">
        window.jQuery || document.write("<script src='${base}/static/thirdparty/jquery/jquery-2.1.0.min.js'>"+"<"+"/script>");
    </script>
    <!-- <![endif]-->

    <!--[if IE]>
    <script type="text/javascript">
        window.jQuery || document.write("<script src='${base}/static/thirdparty/jquery/jquery-1.11.0.min.js'>"+"<"+"/script>");
    </script>
    <![endif]-->

    <script src="${base}/static/thirdparty/jquery/jquery.form.js"></script>
    <script src="${base}/static/thirdparty/bootstrap/js/bootstrap.min.js"></script>
    <script src="${base}/static/thirdparty/ace/js/ace.min.js"></script>
    <script src="${base}/static/thirdparty/ace/js/jquery.nestable.min.js"></script>
    <script src="${base}/static/thirdparty/select2/select2.min.js"></script>


    <style type="text/css">
        body{
            font-family:'Microsoft Yahei', verdana;
            font-kerning: auto;
            font-style: normal;
            font-variant: normal;
            font-weight: normal;
        }
    </style>
    <script type="text/javascript">
        $(document).ready(function () {
            initMenu();


        });
        function initMenu(){
            $('#menuRoot').html("");
            $.get("${base}/getmenu", function(result){
                var rootMenuChilds=result.children;
                for(var i=0;i<rootMenuChilds.length;i++){
                    var menu=rootMenuChilds[i];
                    addMenu(menu);
                }
                $('.dd').nestable();
                collapseAll();
            });
        }
        function collapseAll(){
            $('li button[data-action="collapse"]').each(function(){
                $(this).css('display','none');
            });
            $('li button[data-action="expand"]').each(function(){
                $(this).css('display','block');
            });
        }
        function addMenu(menuObj){
            if (!menuObj.cls)
                menuObj.cls='icon-double-angle-right blue';
            var menuStr= '<li class="dd-item dd2-item" menu-id="'+menuObj.id+'">'+
                    '<div class="dd-handle dd2-handle">'+
                    '<i class="normal-icon bigger-130 '+menuObj.cls+'"></i>'+
                    '<i class="drag-icon icon-move bigger-125"></i>'+
                    '</div>' +
                    '<div class="dd2-content" onclick="menuClick()">'+menuObj.text+'</div>' +
                    '</li>';
            var pMenu=$('#menuRoot li[menu-id="'+menuObj.pid+'"]');

            if (pMenu.length==0){
                $(menuStr).appendTo($('#menuRoot'));
            }else{
                if ($(pMenu[0]).find('ol').length==0)
                    $('<ol class="dd-list" style="display: none; ">' + menuStr + '</ol>').appendTo($(pMenu[0]));
                else{
                    $(menuStr).appendTo($(pMenu[0]).find('ol')[0]);
                    $(pMenu[0]).addClass('dd-expanded');
                }
            }
            for(var i=0;i<menuObj.children.length;i++){
                addMenu(menuObj.children[i]);
            }
        }

        function menuClick(){
            $('.dd2-content').each(function(){
                $(this).removeClass('btn-info');
            });
            $(event.target).addClass('btn-info');

            var menuLi=$(event.target).parent();
            var menuId=$(menuLi).attr("menu-id");
            $("#menuEditor").load('${base}/editor/menu-prop?menuId=' + menuId);
            $("#menuResource").load('${base}/editor/resource?menuId=' + menuId);
        }
    </script>
</head>
<body>


    <div class="page-content">
        <!-- PAGE CONTENT BEGINS -->

        <div class="row">

            <div class="col-sm-6">
                <div class="widget-box widget-color-blue">
                    <div class="widget-header ">
                        <h4 class="lighter smaller">菜单编辑</h4>
                        <button class="pull-right btn btn-success" id="btnMenuReload">
                            <i class="ace-icon fa fa-refresh icon-only bigger-125"></i>
                        </button>
                    </div>
                    <div class="dd dd-draghandle">
                        <ol class="dd-list" id="menuRoot">


                        </ol>
                    </div>
                </div>
            </div>
            <div class="col-sm-6" >
                <div class="tabbable">
                    <ul class="nav nav-tabs padding-12 tab-color-blue background-blue" id="myTab4">
                        <li class="active">
                            <a data-toggle="tab" href="#menuEditor">菜单属性</a>
                        </li>

                        <li>
                            <a data-toggle="tab" href="#menuResource">菜单资源</a>
                        </li>

                    </ul>

                    <div class="tab-content">
                        <div id="menuEditor" class="tab-pane in active" >
                        </div>

                        <div id="menuResource" class="tab-pane">
                        </div>


                    </div>
                </div>
            </div>

        </div><!-- PAGE CONTENT ENDS -->
    </div><!-- /.col -->


</body>