<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"/>
    <meta charset="utf-8"/>
    <title>全流程优化审批</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0"/>

    <!-- bootstrap & fontawesome -->
    <link rel="stylesheet" href="${base}/static/thirdparty/bootstrap/css/bootstrap.min.css"/>
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/css/font-awesome.min.css"/>

    <!-- text fonts -->
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/css/ace-fonts.css"/>

    <!-- ace styles -->
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/css/ace.min.css"/>

    <!--[if lte IE 9]>
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/css/ace-part2.min.css"/>
    <![endif]-->

    <!--[if lte IE 9]>
    <link rel="stylesheet" href="${base}/static/thirdparty/ace/assets/css/ace-ie.min.css"/>
    <![endif]-->

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lte IE 8]>
    <script src="${base}/static/thirdparty/ace/js/html5shiv.js"></script>
    <script src="${base}/static/thirdparty/ace/js/respond.min.js"></script>
    <![endif]-->

    <link rel="stylesheet" href="${base}/static/thirdparty/qtip/jquery.qtip.min.css"/>
    <link rel="stylesheet" href="${base}/static/css/home.css" />

</head>
<body>
<#include "../common/home-header.ftl"/>
<div class="main-container main-container-buffer">
    <script type="application/javascript">
        try {
            ace.settings.check('main-container', 'fixed')
        } catch (e) {
        }
    </script>
    <div class="content">
        <div class="page-content">
            <h3 class="row header smaller lighter blue">
                <span class="col-xs-12"><i class="pink ace-icon fa fa-tachometer bigger-110"></i>全流程优化审批 </span>
            </h3>
            <div id="accordion" class="accordion-style1 panel-group accordion-style2">
            <#list setWorkFlowDefine as bstatus>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accordion-toggle <#if bstatus_index!=0>collapsed</#if>" data-toggle="collapse" data-parent="#accordion"
                               href="#collapse${bstatus_index}">
                                <i class="ace-icon glyphicon glyphicon-list"></i>
                                &nbsp;${bstatus.key}
                                <i class="pull-right bigger-125 ace-icon fa fa-angle-down icon-on-right"
                                   data-icon-hide="bigger-125 ace-icon fa fa-angle-down"
                                   data-icon-show="bigger-125 ace-icon fa fa-angle-right"></i>

                            </a>
                        </h4>
                    </div>

                    <div class="panel-collapse collapse <#if bstatus_index==0>in</#if>" id="collapse${bstatus_index}" style="height: auto;">
                        <div class="panel-body">
                            <p>
                                <#list bstatus.value as item>
                                    <button class="btn btn-success btn-sm" image-url="${path_platform}/showchart!simpleImage.action?wdid=${item.workflowDefinitionId}">${item.workflowName} </button>
                                </#list>
                            </p>
                        </div>
                    </div>
                </div>
            </#list>

            </div>
        </div>
    </div>
</div>


<#include "../common/home-footer.ftl"/>

<!--[if !IE]> -->
<script type="text/javascript">
    window.jQuery || document.write("<script src='${base}/static/thirdparty/jquery/jquery-2.1.0.min.js'>" + "<" + "/script>");
</script>
<!-- <![endif]-->

<!--[if IE]>
<script type="text/javascript">
    window.jQuery || document.write("<script src='${base}/static/thirdparty/jquery/jquery-1.11.0.min.js'>" + "<" + "/script>");
</script>
<![endif]-->

<script src="${base}/static/thirdparty/bootstrap/js/bootstrap.min.js"></script>
<!--[if lte IE 8]>
<script src="${base}/static/thirdparty/ace/js/excanvas.min.js"></script>
<![endif]-->

<script src="${base}/static/thirdparty/ace/js/ace-extra.min.js"></script>
<script src="${base}/static/thirdparty/ace/js/ace-elements.min.js"></script>
<script src="${base}/static/thirdparty/ace/js/ace.min.js"></script>
<script src="${base}/static/thirdparty/qtip/jquery.qtip.min.js"></script>
<script src="${base}/static/js/category.js"></script>
</body>