/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.editor;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.model.EnumObjectHelper;
import com.gtis.portal.service.PfMenuService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MenuEditorController {
    @Autowired
    PfMenuService menuService;

    @RequestMapping(value={"/editor/menu"})
    public String enter(Model model) {
        return "/editor/menu";
    }

    @RequestMapping(value={"/editor/menu-prop"})
    public String editor(Model model) {
        model.addAttribute("menuModelTypes", (Object)EnumObjectHelper.MenuOpenModel);
        return "/editor/menu-prop";
    }

    @ModelAttribute(value="menu")
    public PfMenu getMemu(@RequestParam(value="menuId", required=false) String menuId) {
        return menuId == null ? new PfMenu() : this.menuService.getMenu(menuId);
    }

    @RequestMapping(value={"/editor/menu/save"})
    @ResponseBody
    public String save(HttpServletRequest req, @ModelAttribute(value="menu") PfMenu menu, Model model) {
        if (menu != null) {
            menu.setMenuExpanded(StringUtils.isBlank((String)req.getParameter("menuExpanded")));
            this.menuService.updateMenu(menu);
        }
        return null;
    }

    @RequestMapping(value={"/editor/menu/add"})
    @ResponseBody
    public String add(HttpServletRequest req, @ModelAttribute(value="menu") PfMenu menu, Model model) {
        if (menu != null) {
            menu.setMenuExpanded(StringUtils.isBlank((String)req.getParameter("menuExpanded")));
            menu.setMenuParentId(menu.getMenuId());
            menu.setMenuId(UUIDGenerator.generate());
            menu.setResourceId(null);
            menu.setMenuExpanded(false);
            this.menuService.addMenu(menu);
        }
        return null;
    }

    @RequestMapping(value={"/editor/menu/del"})
    @ResponseBody
    public String del(@ModelAttribute(value="menu") PfMenu menu) {
        if (menu != null) {
            this.menuService.delMenu(menu);
            return null;
        }
        return null;
    }
}

