/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.gtis.config.AppConfig;
import com.gtis.config.PropertyPlaceholderHelper;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfResource;
import com.gtis.portal.model.Menu;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.web.SessionUtil;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SysMenuController {
    @Autowired
    PfMenuService menuService;
    @Autowired
    PfResourceService resourceService;

    @RequestMapping(value={"/getmenu"})
    @ResponseBody
    public Menu menu() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo.isAdmin()) {
            return this.menuService.getMenusByRole("");
        }
        return this.menuService.getMenusByRole(userInfo.getRoleIds());
    }

    @RequestMapping(value={"/menu/open"})
    @ResponseBody
    public PfResource openMenu(@RequestParam String link) {
        if (link.startsWith("r:")) {
            return this.handleResourceUrl(this.resourceService.getResource(link.replace("r:", "")));
        }
        return this.handleResourceUrl(this.resourceService.getResource(link));
    }

    private PfResource handleResourceUrl(PfResource pfResource) {
        PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
        if (StringUtils.isNotBlank((String)pfResource.getResourceUrl())) {
            String tmpUrl = pfResource.getResourceUrl();
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)AppConfig.getProperties());
            pfResource.setResourceUrl(propertyPlaceholderHelper.replacePlaceholders(tmpUrl, properties));
        }
        return pfResource;
    }
}

