/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.gtis.portal.entity.PfMessageAccept;
import com.gtis.portal.entity.PfMessageSend;
import com.gtis.portal.service.pfMessageService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MessageController {
    @Autowired
    pfMessageService messageService;
    private static int PAGE_SIZE = 15;

    @RequestMapping(value={"message"})
    public String enter(String title, Date beginDate, Date endDate, Pageable page, Model model) {
        return "message";
    }

    @RequestMapping(value={"message/sendlist"})
    public String sendlist(String title, Date beginDate, Date endDate, Pageable page, Model model) {
        page = new PageRequest(page.getPageNumber(), page.getPageSize(), Sort.Direction.DESC, new String[]{"messagesendDate"});
        Page messageSendPage = this.messageService.queryMessageSendList(null, title, beginDate, endDate, page);
        model.addAttribute("messageSendPage", (Object)messageSendPage);
        return "message-sendlist";
    }

    @RequestMapping(value={"message/send"})
    @ResponseBody
    public PfMessageSend send(@RequestParam(value="messageId", required=true) String messageId, Model model) {
        return this.messageService.getMessageSend(messageId);
    }

    @RequestMapping(value={"message/accept"})
    @ResponseBody
    public PfMessageAccept accept(@RequestParam(value="messageId", required=true) String messageId, Model model) {
        return this.messageService.getMessageAccept(messageId);
    }

    @RequestMapping(value={"message/acceptlist"})
    public String acceptlist(String title, Date beginDate, Date endDate, Pageable page, Model model) {
        if (page == null) {
            page = new PageRequest(1, PAGE_SIZE, null, null);
        }
        Page messageAcceptPage = this.messageService.queryMessageAcceptList(null, title, beginDate, endDate, page);
        model.addAttribute("messageAcceptPage", (Object)messageAcceptPage);
        return "message-acceptlist";
    }
}

